<?php

if(!function_exists('blaze_edge_tabs_map')) {
    function blaze_edge_tabs_map() {
		
        $panel = blaze_edge_add_admin_panel(array(
            'title' => esc_html__('Tabs', 'edge-cpt'),
            'name'  => 'panel_tabs',
            'page'  => '_elements_page'
        ));

        //Typography options
        blaze_edge_add_admin_section_title(array(
            'name' => 'typography_section_title',
            'title' => esc_html__('Tabs Navigation Typography',	'blaze'),
            'parent' => $panel
        ));

        $typography_group = blaze_edge_add_admin_group(array(
            'name' => 'typography_group',
            'title' => esc_html__('Tabs Navigation Typography', 'edge-cpt'),
			'description' => esc_html__('Setup typography for tabs navigation', 'edge-cpt'),
            'parent' => $panel
        ));

        $typography_row = blaze_edge_add_admin_row(array(
            'name' => 'typography_row',
            'next' => true,
            'parent' => $typography_group
        ));

        blaze_edge_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'fontsimple',
            'name'          => 'tabs_font_family',
            'default_value' => '',
            'label'         => esc_html__('Font Family', 'edge-cpt'),
        ));

        blaze_edge_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'selectsimple',
            'name'          => 'tabs_text_transform',
            'default_value' => '',
            'label'         => esc_html__('Text Transform', 'edge-cpt'),
            'options'       => blaze_edge_get_text_transform_array()
        ));

        blaze_edge_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'selectsimple',
            'name'          => 'tabs_font_style',
            'default_value' => '',
            'label'         => esc_html__('Font Style', 'edge-cpt'),
            'options'       => blaze_edge_get_font_style_array()
        ));

        blaze_edge_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'textsimple',
            'name'          => 'tabs_letter_spacing',
            'default_value' => '',
            'label'         => esc_html__('Letter Spacing', 'edge-cpt'),
            'args'          => array(
                'suffix' => 'px'
            )
        ));

        $typography_row2 = blaze_edge_add_admin_row(array(
            'name' => 'typography_row2',
            'next' => true,
            'parent' => $typography_group
        ));		
		
        blaze_edge_add_admin_field(array(
            'parent'        => $typography_row2,
            'type'          => 'selectsimple',
            'name'          => 'tabs_font_weight',
            'default_value' => '',
            'label'         => esc_html__('Font Weight', 'edge-cpt'),
            'options'       => blaze_edge_get_font_weight_array()
        ));
		
		//Initial Tab Color Styles
		
		blaze_edge_add_admin_section_title(array(
            'name' => 'tab_color_section_title',
            'title' => esc_html__('Tab Navigation Color Styles', 'edge-cpt'),
            'parent' => $panel
        ));
		$tabs_color_group = blaze_edge_add_admin_group(array(
            'name' => 'tabs_color_group',
            'title' => esc_html__('Navigation Color Styles', 'edge-cpt'),
			'description' => esc_html__('Set color styles for tab navigation', 'edge-cpt'),
            'parent' => $panel
        ));
		$tabs_color_row = blaze_edge_add_admin_row(array(
            'name' => 'tabs_color_row',
            'next' => true,
            'parent' => $tabs_color_group
        ));

        blaze_edge_add_admin_field(array(
            'parent'        => $tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'tabs_color',
            'default_value' => '',
            'label'         => esc_html__('Color', 'edge-cpt'),
        ));

		blaze_edge_add_admin_field(array(
            'parent'        => $tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'tabs_border_color',
            'default_value' => '',
            'label'         => esc_html__('Border Color', 'edge-cpt'),
        ));
		
		//Active Tab Color Styles
		
		$active_tabs_color_group = blaze_edge_add_admin_group(array(
            'name' => 'active_tabs_color_group',
            'title' => esc_html__('Active and Hover Navigation Color Styles', 'edge-cpt'),
			'description' => esc_html__('Set color styles for active and hover tabs', 'edge-cpt'),
            'parent' => $panel
        ));
		$active_tabs_color_row = blaze_edge_add_admin_row(array(
            'name' => 'active_tabs_color_row',
            'next' => true,
            'parent' => $active_tabs_color_group
        ));

        blaze_edge_add_admin_field(array(
            'parent'        => $active_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'tabs_color_active',
            'default_value' => '',
            'label'         => esc_html__('Color', 'edge-cpt')
        ));

		blaze_edge_add_admin_field(array(
            'parent'        => $active_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'tabs_border_color_active',
            'default_value' => '',
            'label'         => esc_html__('Border Color', 'edge-cpt')
        ));


        //Initial Boxed Tab Color Styles
		
		blaze_edge_add_admin_section_title(array(
            'name' => 'boxed_tab_color_section_title',
            'title' => esc_html__('Boxed Tab Navigation Color Styles',		'blaze'),
            'parent' => $panel
        ));
		$boxed_tabs_color_group = blaze_edge_add_admin_group(array(
            'name' => 'boxed_tabs_color_group',
            'title' => esc_html__('Navigation Color Styles', 'edge-cpt'),
			'description' => esc_html__('Set color styles for tab navigation', 'edge-cpt'),
            'parent' => $panel
        ));
		$boxed_tabs_color_row = blaze_edge_add_admin_row(array(
            'name' => 'boxed_tabs_color_row',
            'next' => true,
            'parent' => $boxed_tabs_color_group
        ));

        blaze_edge_add_admin_field(array(
            'parent'        => $boxed_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'boxed_tabs_color',
            'default_value' => '',
            'label'         => esc_html__('Color', 'edge-cpt')
        ));
		blaze_edge_add_admin_field(array(
            'parent'        => $boxed_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'boxed_tabs_back_color',
            'default_value' => '',
            'label'         => esc_html__('Background Color', 'edge-cpt')
        ));
		
		//Active Boxed Tab Color Styles
		
		$active_boxed_tabs_color_group = blaze_edge_add_admin_group(array(
            'name' => 'active_boxed_tabs_color_group',
            'title' => esc_html__('Active and Hover Navigation Color Styles', 'edge-cpt'),
			'description' => esc_html__('Set color styles for active and hover tabs', 'edge-cpt'),
            'parent' => $panel
        ));

		$active_boxed_tabs_color_row = blaze_edge_add_admin_row(array(
            'name' => 'active_boxed_tabs_color_row',
            'next' => true,
            'parent' => $active_boxed_tabs_color_group
        ));

        blaze_edge_add_admin_field(array(
            'parent'        => $active_boxed_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'boxed_tabs_color_active',
            'default_value' => '',
            'label'         => esc_html__('Color', 'edge-cpt')
        ));

		blaze_edge_add_admin_field(array(
            'parent'        => $active_boxed_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'boxed_tabs_back_color_active',
            'default_value' => '',
            'label'         => esc_html__('Background Color', 'edge-cpt')
        ));
    }

    add_action('blaze_edge_options_elements_map', 'blaze_edge_tabs_map');
}