<?php

if(!function_exists('blaze_edge_load_shortcode_interface')) {

	function blaze_edge_load_shortcode_interface() {

		include_once EDGE_CORE_ABS_PATH.'/shortcodes/lib/shortcode-interface.php';

	}

	add_action('blaze_edge_before_options_map', 'blaze_edge_load_shortcode_interface');

}

if(!function_exists('blaze_edge_load_shortcodes')) {
	/**
	 * Loades all shortcodes by going through all folders that are placed directly in shortcodes folder
	 * and loads load.php file in each. Hooks to blaze_edge_after_options_map action
	 *
	 * @see http://php.net/manual/en/function.glob.php
	 */
	function blaze_edge_load_shortcodes() {
		foreach(glob(EDGE_CORE_ABS_PATH.'/shortcodes/*/load.php') as $shortcode_load) {
			include_once $shortcode_load;
		}

		do_action('blaze_edge_shortcode_loader');
	}

	add_action('blaze_edge_before_options_map', 'blaze_edge_load_shortcodes');
}