<?php
namespace BlazeEdge\Modules\Shortcodes\Lib;

use BlazeEdge\Modules\ImageWithText\ImageWithText;
use BlazeEdge\Modules\Shortcodes\Accordion\Accordion;
use BlazeEdge\Modules\Shortcodes\AccordionTab\AccordionTab;
use BlazeEdge\Modules\Shortcodes\Blockquote\Blockquote;
use BlazeEdge\Modules\Shortcodes\BlogList\BlogList;
use BlazeEdge\Modules\Shortcodes\BlogSlider\BlogSlider;
use BlazeEdge\Modules\Shortcodes\Button\Button;
use BlazeEdge\Modules\Shortcodes\CallToAction\CallToAction;
use BlazeEdge\Modules\Shortcodes\Counter\Countdown;
use BlazeEdge\Modules\Shortcodes\Counter\Counter;
use BlazeEdge\Modules\Shortcodes\CustomFont\CustomFont;
use BlazeEdge\Modules\Shortcodes\DevicePresentation\DevicePresentation;
use BlazeEdge\Modules\Shortcodes\Dropcaps\Dropcaps;
use BlazeEdge\Modules\Shortcodes\ElementsHolder\ElementsHolder;
use BlazeEdge\Modules\Shortcodes\ElementsHolderItem\ElementsHolderItem;
use BlazeEdge\Modules\Shortcodes\GoogleMap\GoogleMap;
use BlazeEdge\Modules\Shortcodes\Highlight\Highlight;
use BlazeEdge\Modules\Shortcodes\Icon\Icon;
use BlazeEdge\Modules\Shortcodes\IconListItem\IconListItem;
use BlazeEdge\Modules\Shortcodes\IconWithText\IconWithText;
use BlazeEdge\Modules\Shortcodes\ImageGallery\ImageGallery;
use BlazeEdge\Modules\ImageMerge\ImageMerge;
use BlazeEdge\Modules\Shortcodes\Message\Message;
use BlazeEdge\Modules\Shortcodes\OrderedList\OrderedList;
use BlazeEdge\Modules\Shortcodes\PieCharts\PieChartBasic\PieChartBasic;
use BlazeEdge\Modules\Shortcodes\PieCharts\PieChartDoughnut\PieChartDoughnut;
use BlazeEdge\Modules\Shortcodes\PieCharts\PieChartDoughnut\PieChartPie;
use BlazeEdge\Modules\Shortcodes\PieCharts\PieChartWithIcon\PieChartWithIcon;
use BlazeEdge\Modules\Shortcodes\PricingTables\PricingTables;
use BlazeEdge\Modules\Shortcodes\PricingTable\PricingTable;
use BlazeEdge\Modules\Shortcodes\Process\ProcessHolder;
use BlazeEdge\Modules\Shortcodes\Process\ProcessItem;
use BlazeEdge\Modules\Shortcodes\ProgressBar\ProgressBar;
use BlazeEdge\Modules\Shortcodes\Separator\Separator;
use BlazeEdge\Modules\Shortcodes\SocialShare\SocialShare;
use BlazeEdge\Modules\Shortcodes\Tabs\Tabs;
use BlazeEdge\Modules\Shortcodes\Tab\Tab;
use BlazeEdge\Modules\Shortcodes\Team\Team;
use BlazeEdge\Modules\Shortcodes\UnorderedList\UnorderedList;
use BlazeEdge\Modules\Shortcodes\VerticalSplitSlider\VerticalSplitSlider;
use BlazeEdge\Modules\Shortcodes\VerticalSplitSliderContentItem\VerticalSplitSliderContentItem;
use BlazeEdge\Modules\Shortcodes\VerticalSplitSliderLeftPanel\VerticalSplitSliderLeftPanel;
use BlazeEdge\Modules\Shortcodes\VerticalSplitSliderRightPanel\VerticalSplitSliderRightPanel;
use BlazeEdge\Modules\Shortcodes\VideoButton\VideoButton;
use BlazeEdge\Modules\Shortcodes\ShopGallery\ShopGallery;
use BlazeEdge\Modules\Shortcodes\Clients\Clients;
use BlazeEdge\Modules\Shortcodes\Client\Client;
use BlazeEdge\Modules\Shortcodes\CrossfadeImages\CrossfadeImages;
use BlazeEdge\Modules\Shortcodes\InteractiveLinkShowcase\InteractiveLinkShowcase;
use BlazeEdge\Modules\Shortcodes\ScrollSlider\ScrollSlider;

/**
 * Class ShortcodeLoader
 */
class ShortcodeLoader {
	/**
	 * @var private instance of current class
	 */
	private static $instance;
	/**
	 * @var array
	 */
	private $loadedShortcodes = array();

	/**
	 * Private constuct because of Singletone
	 */
	private function __construct() {}

	/**
	 * Private sleep because of Singletone
	 */
	private function __wakeup() {}

	/**
	 * Private clone because of Singletone
	 */
	private function __clone() {}

	/**
	 * Returns current instance of class
	 * @return ShortcodeLoader
	 */
	public static function getInstance() {
		if(self::$instance == null) {
			return new self;
		}

		return self::$instance;
	}

	/**
	 * Adds new shortcode. Object that it takes must implement ShortcodeInterface
	 * @param ShortcodeInterface $shortcode
	 */
	private function addShortcode(ShortcodeInterface $shortcode) {
		if(!array_key_exists($shortcode->getBase(), $this->loadedShortcodes)) {
			$this->loadedShortcodes[$shortcode->getBase()] = $shortcode;
		}
	}

	/**
	 * Adds all shortcodes.
	 *
	 * @see ShortcodeLoader::addShortcode()
	 */
	private function addShortcodes() {
		$this->addShortcode(new Accordion());
		$this->addShortcode(new AccordionTab());
		$this->addShortcode(new Blockquote());
		$this->addShortcode(new BlogList());
		$this->addShortcode(new BlogSlider());
		$this->addShortcode(new Button());
		$this->addShortcode(new CallToAction());
		$this->addShortcode(new Counter());
		$this->addShortcode(new Countdown());
		$this->addShortcode(new CustomFont());
		$this->addShortcode(new DevicePresentation());
		$this->addShortcode(new Dropcaps());
		$this->addShortcode(new ElementsHolder());
		$this->addShortcode(new ElementsHolderItem());
		$this->addShortcode(new GoogleMap());
		$this->addShortcode(new Highlight());
		$this->addShortcode(new Icon());
		$this->addShortcode(new IconListItem());
		$this->addShortcode(new IconWithText());
		$this->addShortcode(new ImageGallery());
		$this->addShortcode(new ImageMerge());
		$this->addShortcode(new ImageWithText());
		$this->addShortcode(new Message());
		$this->addShortcode(new OrderedList());
		$this->addShortcode(new PieChartBasic());
		$this->addShortcode(new PieChartPie());
		$this->addShortcode(new PieChartDoughnut());
		$this->addShortcode(new PieChartWithIcon());
		$this->addShortcode(new PricingTables());
		$this->addShortcode(new PricingTable());
		$this->addShortcode(new ProgressBar());
		$this->addShortcode(new ProcessHolder());
		$this->addShortcode(new ProcessItem());
		$this->addShortcode(new Separator());
		$this->addShortcode(new SocialShare());
		$this->addShortcode(new Tabs());
		$this->addShortcode(new Tab());
		$this->addShortcode(new Team());
		$this->addShortcode(new UnorderedList());
		$this->addShortcode(new VideoButton());
		$this->addShortcode(new VerticalSplitSlider());
		$this->addShortcode(new VerticalSplitSliderLeftPanel());
		$this->addShortcode(new VerticalSplitSliderRightPanel());
		$this->addShortcode(new VerticalSplitSliderContentItem());
		$this->addShortcode(new Clients());
		$this->addShortcode(new Client());
		$this->addShortcode(new CrossfadeImages());
		$this->addShortcode(new InteractiveLinkShowcase());
		$this->addShortcode(new ScrollSlider());

		if(blaze_edge_is_woocommerce_installed()){
			$this->addShortcode(new ShopGallery());
		}
	}
	/**
	 * Calls ShortcodeLoader::addShortcodes and than loops through added shortcodes and calls render method
	 * of each shortcode object
	 */
	public function load() {
		$this->addShortcodes();

		foreach ($this->loadedShortcodes as $shortcode) {
			add_shortcode($shortcode->getBase(), array($shortcode, 'render'));
		}
	}
}

$shortcodeLoader = ShortcodeLoader::getInstance();
$shortcodeLoader->load();