<div class="edgtf-image-gallery clearfix">
	<div class="edgtf-image-gallery-grid <?php echo esc_attr($gallery_classes); ?> <?php echo esc_attr($columns); ?>" >
		<?php foreach ($images as $image) { ?>
			<div class="edgtf-gallery-image">
				<?php if ($pretty_photo) { ?>
					<a href="<?php echo esc_url($image['url'])?>" data-rel="prettyPhoto[single_pretty_photo]" title="<?php echo esc_attr($image['title']); ?>">
				<?php } 
				elseif ($image['link'] !== '') { ?>
					<a href="<?php echo esc_url($image['link'])?>" target="<?php echo esc_attr($image['link_target']);?>">
				<?php } ?>
					<?php if(is_array($image_size) && count($image_size)) : ?>
						<?php echo blaze_edge_generate_thumbnail($image['image_id'], null, $image_size[0], $image_size[1]); ?>
					<?php else: ?>
						<?php echo wp_get_attachment_image($image['image_id'], $image_size); ?>
					<?php endif; ?>
				<?php if ($pretty_photo || $image['link'] !== '') {?>
					</a>
				<?php } ?>
			</div>
		<?php } ?>
	</div>
</div>