<div class="edgtf-image-with-text <?php echo esc_attr($classes);?>">
	<div class="edgtf-image-with-text-holder-inner">
		<?php if($link != '') { ?>
		<a class="edgtf-image-with-text-link" href="<?php echo esc_url($link); ?>" <?php blaze_edge_inline_attr($target, 'target'); ?>></a>
		<?php } ?>
		<div class="edgtf-image-with-text-image-holder">
			<div class="edgtf-image-with-text-image">
				<img src="<?php echo esc_url($image); ?>" alt="<?php esc_attr_e( 'Image thumbnail', 'edge-cpt' ); ?>" />
			</div>
		</div>
		<?php if($title != '' || $subtitle != '' || $link != '') { ?>
			<div class="edgtf-image-with-text-overlay">
				<div class="edgtf-image-with-text-overlay-inner">
					<div class="edgtf-image-with-text-text-holder">
						<div class="edgtf-image-with-text-text-holder-inner">
							<?php if($title != '') { ?>
								<div class="edgtf-image-with-text-title-holder">
									<h3<?php blaze_edge_inline_style($title_styles); ?> class="edgtf-image-with-text-title">
										<span><?php echo esc_html($title); ?></span>
										<span class="edgtf-sub-line"></span>
									</h3>
								</div>
							<?php } ?>
							<?php if($subtitle != '') { ?>
								<div class="edgtf-image-with-text-subtitle-holder">
									<span>- </span>
									<span class="edgtf-image-with-text-subtitle" <?php blaze_edge_inline_style($subtitle_styles); ?>><?php echo esc_html($subtitle); ?></span>
								</div>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		<?php } ?>
	</div>
</div>