<?php
namespace BlazeEdge\Modules\ImageMerge;

use BlazeEdge\Modules\Shortcodes\Lib\ShortcodeInterface;

class ImageMerge implements ShortcodeInterface{
	private $base;

	function __construct() {
		$this->base = 'edgtf_image_merge';
		add_action('vc_before_init', array($this, 'vcMap'));
	}
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if(function_exists('vc_map')){
			vc_map( 
				array(
					'name' => esc_html__( 'Image Merge', 'edge-cpt' ),
					'base' => $this->base,
					'category' => esc_html__( 'by EDGE', 'edge-cpt' ),
					'icon' => 'icon-wpb-image-merge extended-custom-icon',
					'allowed_container_element' => 'vc_row',
					"params" => array(
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__("Scroll Amount (px)", 'edge-cpt'),
							"param_name" => "height",
							"description" => esc_html__("How many pixels of scrolling the animation lasts. The default value adapts to smaller screens.", 'edge-cpt')
						),
						array(
							"type" => "attach_image",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__("Quicker Top Image", 'edge-cpt'),
							"param_name" => "ver_img_1",
							"description" => esc_html__("This image enters the screen from top moving faster.", 'edge-cpt')
						),
						array(
							"type" => "attach_image",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__("Quicker Bottom Image", 'edge-cpt'),
							"param_name" => "ver_img_2",
							"description" => esc_html__("This image enters the screen from bottom moving faster.", 'edge-cpt')
						),
						array(
							"type" => "attach_image",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__("Slower Top Image", 'edge-cpt'),
							"param_name" => "ver_img_3",
							"description" => esc_html__("This image enters the screen from top moving slower.", 'edge-cpt')
						),
						array(
							"type" => "attach_image",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__("Slower Bottom Image", 'edge-cpt'),
							"param_name" => "ver_img_4",
							"description" => esc_html__("This image enters the screen from bottom moving slower.", 'edge-cpt')
						),
						array(
							"type" => "attach_image",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__("Image Entering From the Left", 'edge-cpt'),
							"param_name" => "hor_img_1",
							"description" => esc_html__("This image enters the screen from the left.", 'edge-cpt')
						),
						array(
							"type" => "attach_image",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__("Image Entering From the Right", 'edge-cpt'),
							"param_name" => "hor_img_2",
							"description" => esc_html__("This image enters the screen from the right.", 'edge-cpt')
						)
					)				
				)
			);			
		}
	}

	public function render($atts, $content = null) {
		$args = array(
			'height'     	=> '',
			'ver_img_1'     => '',
			'ver_img_2'     => '',
			'ver_img_3'     => '',
			'ver_img_4'     => '',
			'hor_img_1'     => '',
			'hor_img_2'     => '',
		);
		
		$params = 	shortcode_atts($args, $atts);
		extract($params);

		$params['shortcode_styles'] =  $this->getShortcodeStyles($params);

		$html = edge_cpt_get_cpt_shortcode_template_part('templates/image-merge-template', 'image-merge', '', $params);

		return $html;
	}


	/**
	 * Return shortcode styles
	 *
	 * @param $params
	 * @return array
	 */
	private function getShortcodeStyles($params) {

		$shortcode_styles = array();

		if ($params['height'] !== '') {
			$shortcode_styles[] = 'height: ' . blaze_edge_filter_px($params['height']);
		}

		return implode(';', $shortcode_styles);

	}

}
