<?php
namespace BlazeEdge\Modules\Shortcodes\DevicePresentation;

use BlazeEdge\Modules\Shortcodes\Lib\ShortcodeInterface;

class DevicePresentation implements ShortcodeInterface{
	private $base;

	function __construct() {
		$this->base = 'degtf_device_presentation';
		add_action('vc_before_init', array($this, 'vcMap'));
	}
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if(function_exists('vc_map')){
			vc_map( 
				array(
					'name' => esc_html__('Device Presentation', 'edge-cpt'),
					'base' => $this->base,
					'content_element' => true,
					'category' => esc_html__( 'by EDGE', 'edge-cpt' ),
					'icon' => 'icon-wpb-device-presentation extended-custom-icon',
					'show_settings_on_create' => true,
					'params' => array(
						array(
							'type' => 'attach_image',
							'class' => '',
							'heading' => esc_html__('Hero Image', 'edge-cpt'),
							'param_name' => 'hero_image',
							'value' => '',
							'group'	=> esc_html__('Hero Image', 'edge-cpt')
						),
						array(
							'type' => 'textfield',
							'class' => '',
							'heading' => esc_html__('Link', 'edge-cpt'),
							'param_name' => 'hero_image_link',
							'value' => '',
							'description' => esc_html__('Set an external URL to link to.', 'edge-cpt'),
						    'dependency' => array('element' => 'hero_image', 'not_empty' => true),
							'group'	=> esc_html__('Hero Image', 'edge-cpt')
						),
						array(
							'type' => 'dropdown',
							'class' => '',
							'heading' => esc_html__('Target', 'edge-cpt'),
							'param_name' => 'hero_image_target',
							'value' => array(
								esc_html__('Same Window', 'edge-cpt')    => '_self',
								esc_html__('New Window', 'edge-cpt')    => '_blank',
							),
						    'dependency' => array('element' => 'hero_image_link', 'not_empty' => true),
							'save_always' => true,
							'group'	=> esc_html__('Hero Image', 'edge-cpt')
						),
						array(
							'type' => 'attach_image',
							'class' => '',
							'heading' => esc_html__('Left Tablet Image', 'edge-cpt'),
							'param_name' => 'left_tablet_image',
							'value' => '',
							'group'	=> esc_html__('Tablet Images', 'edge-cpt')
						),
						array(
							'type' => 'textfield',
							'class' => '',
							'heading' => esc_html__('Link', 'edge-cpt'),
							'param_name' => 'left_tablet_image_link',
							'value' => '',
							'description' => esc_html__('Set an external URL to link to.', 'edge-cpt'),
						    'dependency' => array('element' => 'left_tablet_image', 'not_empty' => true),
							'group'	=> esc_html__('Tablet Images', 'edge-cpt')
						),
						array(
							'type' => 'dropdown',
							'class' => '',
							'heading' => esc_html__('Target', 'edge-cpt'),
							'param_name' => 'left_tablet_image_target',
							'value' => array(
								esc_html__('Same Window', 'edge-cpt')    => '_self',
								esc_html__('New Window', 'edge-cpt')    => '_blank',
							),
						    'dependency' => array('element' => 'left_tablet_image_link', 'not_empty' => true),
							'save_always' => true,
							'group'	=> esc_html__('Tablet Images', 'edge-cpt')
						),
						array(
							'type' => 'attach_image',
							'class' => '',
							'heading' => esc_html__('Right Tablet Image', 'edge-cpt'),
							'param_name' => 'right_tablet_image',
							'value' => '',
							'group'	=> esc_html__('Tablet Images', 'edge-cpt')
						),
						array(
							'type' => 'textfield',
							'class' => '',
							'heading' => esc_html__('Link', 'edge-cpt'),
							'param_name' => 'right_tablet_image_link',
							'value' => '',
							'description' => esc_html__('Set an external URL to link to.', 'edge-cpt'),
						    'dependency' => array('element' => 'right_tablet_image', 'not_empty' => true),
							'group'	=> esc_html__('Tablet Images', 'edge-cpt')
						),
						array(
							'type' => 'dropdown',
							'class' => '',
							'heading' => esc_html__('Target', 'edge-cpt'),
							'param_name' => 'right_tablet_image_target',
							'value' => array(
								esc_html__('Same Window', 'edge-cpt')    => '_self',
								esc_html__('New Window', 'edge-cpt')    => '_blank',
							),
						    'dependency' => array('element' => 'right_tablet_image_link', 'not_empty' => true),
							'save_always' => true,
							'group'	=> esc_html__('Tablet Images', 'edge-cpt')
						),
						array(
							'type' => 'attach_image',
							'class' => '',
							'heading' => esc_html__('Left Phone Image', 'edge-cpt'),
							'param_name' => 'left_phone_image',
							'value' => '',
							'group'	=> esc_html__('Phone Images', 'edge-cpt')
						),
						array(
							'type' => 'textfield',
							'class' => '',
							'heading' => esc_html__('Link', 'edge-cpt'),
							'param_name' => 'left_phone_image_link',
							'value' => '',
							'description' => esc_html__('Set an external URL to link to.', 'edge-cpt'),
						    'dependency' => array('element' => 'left_phone_image', 'not_empty' => true),
							'group'	=> esc_html__('Phone Images', 'edge-cpt')
						),
						array(
							'type' => 'dropdown',
							'class' => '',
							'heading' => esc_html__('Target', 'edge-cpt'),
							'param_name' => 'left_phone_image_target',
							'value' => array(
								esc_html__('Same Window', 'edge-cpt')    => '_self',
								esc_html__('New Window', 'edge-cpt')    => '_blank',
							),
						    'dependency' => array('element' => 'left_phone_image_link', 'not_empty' => true),
							'save_always' => true,
							'group'	=> esc_html__('Phone Images', 'edge-cpt')
						),
						array(
							'type' => 'attach_image',
							'class' => '',
							'heading' => esc_html__('Right Phone Image', 'edge-cpt'),
							'param_name' => 'right_phone_image',
							'value' => '',
							'group'	=> esc_html__('Phone Images', 'edge-cpt')
						),
						array(
							'type' => 'textfield',
							'class' => '',
							'heading' => esc_html__('Link', 'edge-cpt'),
							'param_name' => 'right_phone_image_link',
							'value' => '',
							'description' => esc_html__('Set an external URL to link to.', 'edge-cpt'),
						    'dependency' => array('element' => 'right_phone_image', 'not_empty' => true),
							'group'	=> esc_html__('Phone Images', 'edge-cpt')
						),
						array(
							'type' => 'dropdown',
							'class' => '',
							'heading' => esc_html__('Target', 'edge-cpt'),
							'param_name' => 'right_phone_image_target',
							'value' => array(
								esc_html__('Same Window', 'edge-cpt')    => '_self',
								esc_html__('New Window', 'edge-cpt')    => '_blank',
							),
						    'dependency' => array('element' => 'right_phone_image_link', 'not_empty' => true),
							'save_always' => true,
							'group'	=> esc_html__('Phone Images', 'edge-cpt')
						),
						array(
							'type' => 'dropdown',
							'class' => '',
							'heading' => esc_html__('Animate on Appear', 'edge-cpt'),
							'param_name' => 'animate_on_appear',
							'value' => array(
								esc_html__('Yes', 'edge-cpt')    => 'yes',
								esc_html__('No', 'edge-cpt')    => 'no',
							),
							'save_always' => true,
							'group'	=> esc_html__('Behavior', 'edge-cpt')
						),
					)
				)
			);			
		}
	}

	public function render($atts, $content = null) {
		$args = array(
			'hero_image' => '',
			'hero_image_link' => '',
			'hero_image_target' => '_self',
			'left_tablet_image' => '',
			'left_tablet_image_link' => '',
			'left_tablet_image_target' => '_self',
			'right_tablet_image' => '',
			'right_tablet_image_link' => '',
			'right_tablet_image_target' => '_self',
			'left_phone_image' => '',
			'left_phone_image_link' => '',
			'left_phone_image_target' => '_self',
			'right_phone_image' => '',
			'right_phone_image_link' => '',
			'right_phone_image_target' => '_self',
			'animate_on_appear' => 'yes',
		);
		
		$params = shortcode_atts($args, $atts);
		extract($params);

		$params['shortcode_classes'] = $this->getShortcodeClasses($params);

		$html = edge_cpt_get_cpt_shortcode_template_part('templates/device-presentation-template' , 'device-presentation', '', $params);

		return $html;
	}

	/**
	 * Return Device Presentation classes
	 *
	 * @param $params
	 * @return array
	 */
	private function getShortcodeClasses($params) {

		$shortcode_classes = array();

		$shortcode_classes[] = 'edgtf-device-presentation';

		if ($params['animate_on_appear'] == 'yes') {
			$shortcode_classes[] = 'edgtf-animate-on-appear';
		}

		return implode(' ', $shortcode_classes);

	}

}
