<?php
namespace BlazeEdge\Modules\Shortcodes\CrossfadeImages;

use BlazeEdge\Modules\Shortcodes\Lib\ShortcodeInterface;

/**
 * Class CrossfadeImages
 */
class CrossfadeImages implements ShortcodeInterface {
    /**
     * @var string
     */
	private $base; 
	
    /**
     * CrossfadeImages constructor.
     */
	function __construct() {
		$this->base = 'edgtf_crossfade_images';

		add_action('vc_before_init', array($this, 'vcMap'));
	}
	
	/**
		* Returns base for shortcode
		* @return string
	 */
	public function getBase() {
		return $this->base;
	}	
    
	public function vcMap() {
						
		vc_map( array(
			'name' => esc_html__( 'Crossfade Images', 'edge-cpt' ),
			'base' => $this->getBase(),
			'category' => esc_html__( 'by EDGE', 'edge-cpt' ),
			'icon' => 'icon-wpb-crossfade-images extended-custom-icon',
			'params' =>	array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__('Initial Image', 'edge-cpt'),
                    'param_name' => 'initial_image'
                ),
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__('Hover Image', 'edge-cpt'),
                    'param_name' => 'hover_image'
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Title', 'edge-cpt'),
                    'param_name' => 'title',
                    'admin_label' => true,
                ),
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__('Link', 'edge-cpt'),
                    'param_name'  => 'link',
                    'admin_label' => true
                ),
                array(
                    'type'        => 'dropdown',
                    'heading'     => esc_html__('Link target', 'edge-cpt'),
                    'param_name'  => 'link_target',
                    'description' => '',
                    'value'       => array(
	                    esc_html__('New Window', 'edge-cpt') => '_blank',
	                    esc_html__('Same Window', 'edge-cpt')  => '_self'
                    ),
                    'save_always' => true,
                    'dependency' => array( 'element' => 'link', 'not_empty' => true )
                ),
                array(
                    'type'        => 'colorpicker',
                    'heading'     => esc_html__('Background Color', 'edge-cpt'),
                    'param_name'  => 'background_color',
                    'group'       => esc_html__('Design Options', 'edge-cpt')
                ),
            )
		) );

	}

	public function render($atts, $content = null) {
		
		$args = array(
            'initial_image' => '',
            'hover_image'   => '',
            'title'         => '',
            'link'          => '',
            'link_target'   => '',
            'background_color'   => '',
        );

        $params = shortcode_atts($args, $atts);

        extract($params);

        return edge_cpt_get_cpt_shortcode_template_part('templates/crossfade-images-template', 'crossfade-images', '', $params);
    }
}