<?php 

if(!function_exists('blaze_edge_accordions_typography_styles')){
	function blaze_edge_accordions_typography_styles(){
		$selector = '.edgtf-accordion-holder .edgtf-title-holder';
		$styles = array();
		
		$font_family = blaze_edge_options()->getOptionValue('accordions_font_family');
		if(blaze_edge_is_font_option_valid($font_family)){
			$styles['font-family'] = blaze_edge_get_font_option_val($font_family);
		}
		
		$text_transform = blaze_edge_options()->getOptionValue('accordions_text_transform');
       if(!empty($text_transform)) {
           $styles['text-transform'] = $text_transform;
       }

       $font_style = blaze_edge_options()->getOptionValue('accordions_font_style');
       if(!empty($font_style)) {
           $styles['font-style'] = $font_style;
       }

       $letter_spacing = blaze_edge_options()->getOptionValue('accordions_letter_spacing');
       if($letter_spacing !== '') {
           $styles['letter-spacing'] = blaze_edge_filter_px($letter_spacing).'px';
       }

       $font_weight = blaze_edge_options()->getOptionValue('accordions_font_weight');
       if(!empty($font_weight)) {
           $styles['font-weight'] = $font_weight;
       }

       echo blaze_edge_dynamic_css($selector, $styles);
	}
	add_action('blaze_edge_style_dynamic', 'blaze_edge_accordions_typography_styles');
}

if(!function_exists('blaze_edge_accordions_initial_color_styles')){

	function blaze_edge_accordions_initial_color_styles(){

		$selector = '.edgtf-accordion-holder .edgtf-title-holder';
		$styles = array();
		
		if(blaze_edge_options()->getOptionValue('accordions_title_color')) {
			$styles['color'] = blaze_edge_options()->getOptionValue('accordions_title_color');
		}
		
		if(blaze_edge_options()->getOptionValue('accordions_back_color')) {
			$styles['background-color'] = blaze_edge_options()->getOptionValue('accordions_back_color');
		}

		echo blaze_edge_dynamic_css($selector, $styles);
	}

	add_action('blaze_edge_style_dynamic', 'blaze_edge_accordions_initial_color_styles');
}

if(!function_exists('blaze_edge_accordions_active_color_styles')){
	
	function blaze_edge_accordions_active_color_styles(){
		$selector = array(
			'.edgtf-accordion-holder .edgtf-title-holder.ui-state-active',
			'.edgtf-accordion-holder .edgtf-title-holder.ui-state-hover'
		);
		$styles = array();
		
		if(blaze_edge_options()->getOptionValue('accordions_title_color_active')) {
			$styles['color'] = blaze_edge_options()->getOptionValue('accordions_title_color_active');
		}
		
		if(blaze_edge_options()->getOptionValue('accordions_back_color_active')) {
			$styles['background-color'] = blaze_edge_options()->getOptionValue('accordions_back_color_active');
		}

		echo blaze_edge_dynamic_css($selector, $styles);
	}

	add_action('blaze_edge_style_dynamic', 'blaze_edge_accordions_active_color_styles');
}