<?php $sidebar = blaze_edge_sidebar_layout(); ?>
<?php get_header(); ?>
<?php 

$blog_page_range = blaze_edge_get_blog_page_range();
$max_number_of_pages = blaze_edge_get_max_number_of_pages();

if ( get_query_var('paged') ) { $paged = get_query_var('paged'); }
elseif ( get_query_var('page') ) { $paged = get_query_var('page'); }
else { $paged = 1; }
?>
<?php blaze_edge_get_title(); ?>
	<div class="edgtf-container">
		<?php do_action('blaze_edge_after_container_open'); ?>
		<div class="edgtf-container-inner clearfix">
			<div class="edgtf-container">
				<?php do_action('blaze_edge_after_container_open'); ?>
				<div class="edgtf-container-inner" >
					<div class="edgtf-blog-holder edgtf-blog-type-standard edgtf-search-page">
				<?php if(have_posts()) : while ( have_posts() ) : the_post(); ?>
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<div class="edgtf-post-content">
							<div class="edgtf-post-text">
								<div class="edgtf-post-text-inner">
									<h3>
										<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
									</h3>
									<p>
										<?php the_excerpt();?>
									</p>
									<?php
									if (shortcode_exists('edgtf_button')) {
										blaze_edge_read_more_button();
									} else { ?>
										<a href="<?php the_permalink(); ?>" target="_self" class="edgtf-btn edgtf-btn-large edgtf-btn-outline">
											<span class="edgtf-btn-text"><?php echo esc_html_e('Read More','blaze'); ?></span>
										</a>
									<?php }	?>
								</div>
							</div>
						</div>
					</article>
					<?php endwhile; ?>
					<?php
						if(blaze_edge_options()->getOptionValue('pagination') == 'yes') {
							blaze_edge_pagination($max_number_of_pages, $blog_page_range, $paged);
						}
					?>
					<?php else: ?>
					<div class="entry">
						<p><?php esc_html_e('No posts were found.', 'blaze'); ?></p>
					</div>
					<?php endif; ?>
				</div>
				<?php do_action('blaze_edge_before_container_close'); ?>
			</div>
			</div>
		</div>
		<?php do_action('blaze_edge_before_container_close'); ?>
	</div>
	<?php do_action('blaze_edge_after_container_close'); ?>
<?php get_footer(); ?>