<?php
include_once get_template_directory().'/theme-includes.php';

if(!function_exists('blaze_edge_styles')) {
    /**
     * Function that includes theme's core styles
     */
    function blaze_edge_styles() {
        wp_register_style('blaze-edge-blog', EDGE_ASSETS_ROOT.'/css/blog.min.css');

        //include theme's core styles
        wp_enqueue_style('blaze-edge-default-style', EDGE_ROOT.'/style.css');
        wp_enqueue_style('blaze-edge-modules-plugins', EDGE_ASSETS_ROOT.'/css/plugins.min.css');
        wp_enqueue_style('blaze-edge-modules', EDGE_ASSETS_ROOT.'/css/modules.min.css');

        blaze_edge_icon_collections()->enqueueStyles();

        if(blaze_edge_load_blog_assets()) {
            wp_enqueue_style('blaze-edge-blog');
        }

        if(blaze_edge_load_blog_assets() || is_singular('portfolio-item')) {
            wp_enqueue_style('wp-mediaelement');
        }

        $style_dynamic_deps_array = array();
        //is woocommerce installed?
        if(blaze_edge_is_woocommerce_installed()) {
            if (blaze_edge_load_woo_assets()) {

                //include theme's woocommerce styles
                wp_enqueue_style('blaze-edge-woocommerce', EDGE_ASSETS_ROOT . '/css/woocommerce.min.css');

                //is responsive option turned on?
                if (blaze_edge_options()->getOptionValue('responsiveness') == 'yes') {
                    //include theme's woocommerce responsive styles

                    wp_enqueue_style('blaze-edge-woocommerce-responsive', EDGE_ASSETS_ROOT . '/css/woocommerce-responsive.min.css');
                    $style_dynamic_deps_array = array('blaze-edge-woocommerce', 'blaze-edge-woocommerce-responsive');
                }
            }
        }


        if(file_exists(EDGE_ROOT_DIR.'/assets/css/style_dynamic.css') && blaze_edge_is_css_folder_writable() && !is_multisite()) {
            wp_enqueue_style('blaze-edge-style-dynamic', EDGE_ASSETS_ROOT.'/css/style_dynamic.css', $style_dynamic_deps_array, filemtime(EDGE_ROOT_DIR.'/assets/css/style_dynamic.css')); //it must be included after woocommerce styles so it can override it
        } else if(file_exists(EDGE_ROOT_DIR.'/assets/css/style_dynamic_ms_id_'. blaze_edge_get_multisite_blog_id() .'.css') && blaze_edge_is_css_folder_writable() && is_multisite()) {
            wp_enqueue_style('blaze-edge-style-dynamic', EDGE_ASSETS_ROOT.'/css/style_dynamic_ms_id_'. blaze_edge_get_multisite_blog_id() .'.css', $style_dynamic_deps_array, filemtime(EDGE_ROOT_DIR.'/assets/css/style_dynamic_ms_id_'. blaze_edge_get_multisite_blog_id() .'.css')); //it must be included after woocommerce styles so it can override it
        }

        //is responsive option turned on?
        if(blaze_edge_is_responsive_on()) {
            wp_enqueue_style('blaze-edge-modules-responsive', EDGE_ASSETS_ROOT.'/css/modules-responsive.min.css');
            wp_enqueue_style('blaze-edge-blog-responsive', EDGE_ASSETS_ROOT.'/css/blog-responsive.min.css');

            //include proper styles
            if(file_exists(EDGE_ROOT_DIR.'/assets/css/style_dynamic_responsive.css') && blaze_edge_is_css_folder_writable() && !is_multisite()) {
                wp_enqueue_style('blaze-edge-style-dynamic-responsive', EDGE_ASSETS_ROOT.'/css/style_dynamic_responsive.css', array(), filemtime(EDGE_ROOT_DIR.'/assets/css/style_dynamic_responsive.css'));
            } elseif(file_exists(EDGE_ROOT_DIR.'/assets/css/style_dynamic_responsive_ms_id_'. blaze_edge_get_multisite_blog_id() .'.css') && blaze_edge_is_css_folder_writable() && is_multisite()) {
                wp_enqueue_style('blaze-edge-style-dynamic-responsive', EDGE_ASSETS_ROOT.'/css/style_dynamic_responsive_ms_id_'. blaze_edge_get_multisite_blog_id() .'.css', array(), filemtime(EDGE_ROOT_DIR.'/assets/css/style_dynamic_responsive_ms_id_'. blaze_edge_get_multisite_blog_id() .'.css'));
            }
        }

        //include Visual Composer styles
        if(class_exists('WPBakeryVisualComposerAbstract')) {
            wp_enqueue_style('js_composer_front');
        }
    }

    add_action('wp_enqueue_scripts', 'blaze_edge_styles');
}

if(!function_exists('blaze_edge_google_fonts_styles')) {
	/**
	 * Function that includes google fonts defined anywhere in the theme
	 */
    function blaze_edge_google_fonts_styles() {
        $font_simple_field_array = blaze_edge_options()->getOptionsByType('fontsimple');
        if(!(is_array($font_simple_field_array) && count($font_simple_field_array) > 0)) {
            $font_simple_field_array = array();
        }

        $font_field_array = blaze_edge_options()->getOptionsByType('font');
        if(!(is_array($font_field_array) && count($font_field_array) > 0)) {
            $font_field_array = array();
        }

        $available_font_options = array_merge($font_simple_field_array, $font_field_array);
        $font_weight_str        = '100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic';

        //define available font options array
        $fonts_array = array();
        foreach($available_font_options as $font_option) {
            //is font set and not set to default and not empty?
            $font_option_value = blaze_edge_options()->getOptionValue($font_option);
            if(blaze_edge_is_font_option_valid($font_option_value) && !blaze_edge_is_native_font($font_option_value)) {
                $font_option_string = $font_option_value.':'.$font_weight_str;
                if(!in_array($font_option_string, $fonts_array)) {
                    $fonts_array[] = $font_option_string;
                }
            }
        }

        $fonts_array         = array_diff($fonts_array, array('-1:'.$font_weight_str));
        $google_fonts_string = implode('|', $fonts_array);

        //default fonts should be separated with %7C because of HTML validation
        $default_font_string = 'Yantramanav:'.$font_weight_str;
        $protocol = is_ssl() ? 'https:' : 'http:';

        //is google font option checked anywhere in theme?
        if (count($fonts_array) > 0) {

            //include all checked fonts
            $fonts_full_list = $default_font_string . '|' . str_replace('+', ' ', $google_fonts_string);
            $fonts_full_list_args = array(
                'family' => urlencode($fonts_full_list),
                'subset' => urlencode('latin,latin-ext'),
            );

            $blaze_edge_fonts = add_query_arg( $fonts_full_list_args, $protocol.'//fonts.googleapis.com/css' );
            wp_enqueue_style( 'blaze-edge-google-fonts', esc_url_raw($blaze_edge_fonts), array(), '1.0.0' );

        } else {
            //include default google font that theme is using
            $default_fonts_args = array(
                'family' => urlencode($default_font_string),
                'subset' => urlencode('latin,latin-ext'),
            );
            $blaze_edge_fonts = add_query_arg( $default_fonts_args, $protocol.'//fonts.googleapis.com/css' );
            wp_enqueue_style( 'blaze-edge-google-fonts', esc_url_raw($blaze_edge_fonts), array(), '1.0.0' );
        }

    }

	add_action('wp_enqueue_scripts', 'blaze_edge_google_fonts_styles');
}

if(!function_exists('blaze_edge_scripts')) {
    /**
     * Function that includes all necessary scripts
     */
    function blaze_edge_scripts() {
        global $wp_scripts;

        //init theme core scripts
		wp_enqueue_script( 'jquery-ui-core');
		wp_enqueue_script( 'jquery-ui-tabs');
		wp_enqueue_script( 'jquery-ui-accordion');
		wp_enqueue_script( 'wp-mediaelement');


		// 3rd party JavaScripts that we used in our theme
		wp_enqueue_script( 'appear', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.appear.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'modernizr', EDGE_ASSETS_ROOT . '/js/modules/plugins/modernizr.custom.85257.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'hoverIntent' );
		wp_enqueue_script( 'jquery-plugin', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.plugin.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'countdown', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.countdown.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'parallax', EDGE_ASSETS_ROOT . '/js/modules/plugins/parallax.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'select2', EDGE_ASSETS_ROOT . '/js/modules/plugins/select2.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'easypiechart', EDGE_ASSETS_ROOT . '/js/modules/plugins/easypiechart.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'waypoints', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.waypoints.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'chart', EDGE_ASSETS_ROOT . '/js/modules/plugins/Chart.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'counter', EDGE_ASSETS_ROOT . '/js/modules/plugins/counter.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'fluidvids', EDGE_ASSETS_ROOT . '/js/modules/plugins/fluidvids.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'prettyphoto', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.prettyPhoto.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'nicescroll', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.nicescroll.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'scroll-to-plugin', EDGE_ASSETS_ROOT . '/js/modules/plugins/ScrollToPlugin.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'tweenlight', EDGE_ASSETS_ROOT . '/js/modules/plugins/TweenLite.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'mixitup', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.mixitup.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'waitforimages', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.waitforimages.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'jquery-easing-1.3', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.easing.1.3.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'skrollr', EDGE_ASSETS_ROOT . '/js/modules/plugins/skrollr.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'slick', EDGE_ASSETS_ROOT . '/js/modules/plugins/slick.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'bootstrapCarousel', EDGE_ASSETS_ROOT . '/js/modules/plugins/bootstrapCarousel.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'touchSwipe', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.touchSwipe.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'multiscroll', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.multiscroll.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'typed', EDGE_ASSETS_ROOT . '/js/modules/plugins/typed.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'swiper', EDGE_ASSETS_ROOT . '/js/modules/plugins/swiper.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'stretch', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.stretch.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'mousewheel', EDGE_ASSETS_ROOT . '/js/modules/plugins/jquery.mousewheel.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'isotope', EDGE_ASSETS_ROOT.'/js/jquery.isotope.min.js', array('jquery'), false, true);

		if(blaze_edge_is_smoth_scroll_enabled()) {
			wp_enqueue_script("blaze-edge-smooth-page-scroll", EDGE_ASSETS_ROOT . "/js/smoothPageScroll.js", array(), false, true);
		}

        //include google map api script
		if(blaze_edge_options()->getOptionValue('google_maps_api_key') != '') {
			$google_maps_api_key = blaze_edge_options()->getOptionValue('google_maps_api_key');
			wp_enqueue_script('google-map-api', '//maps.googleapis.com/maps/api/js?key=' . $google_maps_api_key, array(), false, true);
		}

        wp_enqueue_script('blaze-edge-modules', EDGE_ASSETS_ROOT.'/js/modules.min.js', array('jquery'), false, true);

        if(blaze_edge_load_blog_assets()) {
            wp_enqueue_script('blaze-edge-blog', EDGE_ASSETS_ROOT.'/js/blog.min.js', array('jquery'), false, true);
        }

        //include comment reply script
        $wp_scripts->add_data('comment-reply', 'group', 1);
        if(is_singular() && comments_open() && get_option( 'thread_comments' )) {
            wp_enqueue_script("comment-reply");
        }

        //include Visual Composer script
        if(class_exists('WPBakeryVisualComposerAbstract')) {
            wp_enqueue_script('wpb_composer_front_js');
        }
    }

    add_action('wp_enqueue_scripts', 'blaze_edge_scripts');
}

//defined content width variable
if (!isset( $content_width )) $content_width = 1060;

if(!function_exists('blaze_edge_theme_setup')) {
    /**
     * Function that adds various features to theme. Also defines image sizes that are used in a theme
     */
    function blaze_edge_theme_setup() {
        //add support for feed links
        add_theme_support('automatic-feed-links');

        //add support for post formats
        add_theme_support('post-formats', array('gallery', 'link', 'quote', 'video', 'audio'));

        //add theme support for post thumbnails
        add_theme_support('post-thumbnails');

        //add theme support for title tag
		add_theme_support('title-tag');

        /*
         * This theme styles the visual editor to resemble the theme style
         */
        add_editor_style('assets/css/editor-style.css');

        //define thumbnail sizes
        add_image_size('blaze_edge_square', 650, 650, true);
        add_image_size('blaze_edge_landscape', 800, 600, true);
        add_image_size('blaze_edge_portrait', 600, 800, true);
        add_image_size('blaze_edge_large_width', 1300, 650, true);
        add_image_size('blaze_edge_large_height', 650, 1300, true);
        add_image_size('blaze_edge_large_width_height', 1300, 1300, true);

        load_theme_textdomain( 'blaze', get_template_directory().'/languages' );
    }

    add_action('after_setup_theme', 'blaze_edge_theme_setup');
}

if ( ! function_exists( 'blaze_edge_enqueue_editor_customizer_styles' ) ) {
	/**
	 * Enqueue supplemental block editor styles
	 */
	function blaze_edge_enqueue_editor_customizer_styles() {
		wp_enqueue_style( 'blaze-style-modules-admin-styles', EDGE_FRAMEWORK_ADMIN_ASSETS_ROOT . '/css/edgtf-modules-admin.css' );
		wp_enqueue_style( 'blaze-style-handle-editor-customizer-styles', EDGE_FRAMEWORK_ADMIN_ASSETS_ROOT . '/css/editor-customizer-style.css' );
	}

	// add google font
	add_action( 'enqueue_block_editor_assets', 'blaze_edge_google_fonts_styles' );
	// add action
	add_action( 'enqueue_block_editor_assets', 'blaze_edge_enqueue_editor_customizer_styles' );
}

if(!function_exists('blaze_edge_rgba_color')) {
    /**
     * Function that generates rgba part of css color property
     *
     * @param $color string hex color
     * @param $transparency float transparency value between 0 and 1
     *
     * @return string generated rgba string
     */
    function blaze_edge_rgba_color($color, $transparency) {
        if($color !== '' && $transparency !== '') {
            $rgba_color = '';

            $rgb_color_array = blaze_edge_hex2rgb($color);
            $rgba_color .= 'rgba('.implode(', ', $rgb_color_array).', '.$transparency.')';

            return $rgba_color;
        }
    }
}


if(!function_exists('blaze_edge_header_meta')) {
    /**
     * Function that echoes meta data if our seo is enabled
     */
    function blaze_edge_header_meta() { ?>

        <meta charset="<?php bloginfo('charset'); ?>"/>
        <link rel="profile" href="http://gmpg.org/xfn/11"/>
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>"/>

    <?php }

    add_action('blaze_edge_header_meta', 'blaze_edge_header_meta');
}

if(!function_exists('blaze_edge_user_scalable_meta')) {
    /**
     * Function that outputs user scalable meta if responsiveness is turned on
     * Hooked to blaze_edge_header_meta action
     */
    function blaze_edge_user_scalable_meta() {
        //is responsiveness option is chosen?
        if(blaze_edge_is_responsive_on()) { ?>
            <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no">
        <?php } else { ?>
            <meta name="viewport" content="width=1200,user-scalable=yes">
        <?php }
    }

    add_action('blaze_edge_header_meta', 'blaze_edge_user_scalable_meta');
}

if(!function_exists('blaze_edge_get_page_id')) {
	/**
	 * Function that returns current page / post id.
	 * Checks if current page is woocommerce page and returns that id if it is.
	 * Checks if current page is any archive page (category, tag, date, author etc.) and returns -1 because that isn't
	 * page that is created in WP admin.
	 *
	 * @return int
	 *
	 * @version 0.1
	 *
	 * @see blaze_edge_is_woocommerce_installed()
	 * @see blaze_edge_is_woocommerce_shop()
	 */
	function blaze_edge_get_page_id() {
		if(blaze_edge_is_woocommerce_installed() && blaze_edge_is_woocommerce_shop()) {
			return blaze_edge_get_woo_shop_page_id();
		}

		if(is_archive() || is_search() || is_404() || (is_home() && is_front_page())) {
			return -1;
		}

		return get_queried_object_id();
	}
}


if(!function_exists('blaze_edge_is_default_wp_template')) {
    /**
     * Function that checks if current page archive page, search, 404 or default home blog page
     * @return bool
     *
     * @see is_archive()
     * @see is_search()
     * @see is_404()
     * @see is_front_page()
     * @see is_home()
     */
    function blaze_edge_is_default_wp_template() {
        return is_archive() || is_search() || is_404() || (is_front_page() && is_home());
    }
}

if(!function_exists('blaze_edge_get_page_template_name')) {
    /**
     * Returns current template file name without extension
     * @return string name of current template file
     */
    function blaze_edge_get_page_template_name() {
        $file_name = '';

        if(!blaze_edge_is_default_wp_template()) {
            $file_name_without_ext = preg_replace('/\\.[^.\\s]{3,4}$/', '', basename(get_page_template()));

            if($file_name_without_ext !== '') {
                $file_name = $file_name_without_ext;
            }
        }

        return $file_name;
    }
}

if(!function_exists('blaze_edge_has_shortcode')) {
    /**
     * Function that checks whether shortcode exists on current page / post
     *
     * @param string shortcode to find
     * @param string content to check. If isn't passed current post content will be used
     *
     * @return bool whether content has shortcode or not
     */
    function blaze_edge_has_shortcode($shortcode, $content = '') {
        $has_shortcode = false;

        if($shortcode) {
            //if content variable isn't past
            if($content == '') {
                //take content from current post
                $page_id = blaze_edge_get_page_id();
                if(!empty($page_id)) {
                    $current_post = get_post($page_id);

                    if(is_object($current_post) && property_exists($current_post, 'post_content')) {
                        $content = $current_post->post_content;
                    }
                }
            }

            //does content has shortcode added?
            if(stripos($content, '['.$shortcode) !== false) {
                $has_shortcode = true;
            }
        }

        return $has_shortcode;
    }
}

if(!function_exists('blaze_edge_get_dynamic_sidebar')) {
    /**
     * Return Custom Widget Area content
     *
     * @return string
     */
    function blaze_edge_get_dynamic_sidebar($index = 1) {
        ob_start();
        dynamic_sidebar($index);
        $sidebar_contents = ob_get_clean();

        return $sidebar_contents;
    }
}

if(!function_exists('blaze_edge_get_sidebar')) {
    /**
     * Return Sidebar
     *
     * @return string
     */
    function blaze_edge_get_sidebar() {

        $id = blaze_edge_get_page_id();

        $sidebar = "sidebar";

        if (get_post_meta($id, 'edgtf_custom_sidebar_meta', true) != '') {
            $sidebar = get_post_meta($id, 'edgtf_custom_sidebar_meta', true);
        } else {
            if (is_single() && blaze_edge_options()->getOptionValue('blog_single_custom_sidebar') != '') {
                $sidebar = esc_attr(blaze_edge_options()->getOptionValue('blog_single_custom_sidebar'));
            } elseif ((is_archive() || (is_home() && is_front_page())) && blaze_edge_options()->getOptionValue('blog_custom_sidebar') != '') {
                $sidebar = esc_attr(blaze_edge_options()->getOptionValue('blog_custom_sidebar'));
            } elseif (is_page() && blaze_edge_options()->getOptionValue('page_custom_sidebar') != '') {
                $sidebar = esc_attr(blaze_edge_options()->getOptionValue('page_custom_sidebar'));
            }
        }

        return $sidebar;
    }
}



if( !function_exists('blaze_edge_sidebar_columns_class') ) {

    /**
     * Return classes for columns holder when sidebar is active
     *
     * @return array
     */

    function blaze_edge_sidebar_columns_class() {

        $sidebar_class = array();
        $sidebar_layout = blaze_edge_sidebar_layout();

        switch($sidebar_layout):
            case 'sidebar-33-right':
                $sidebar_class[] = 'edgtf-two-columns-66-33';
                break;
            case 'sidebar-25-right':
                $sidebar_class[] = 'edgtf-two-columns-75-25';
                break;
            case 'sidebar-33-left':
                $sidebar_class[] = 'edgtf-two-columns-33-66';
                break;
            case 'sidebar-25-left':
                $sidebar_class[] = 'edgtf-two-columns-25-75';
                break;

        endswitch;

        $sidebar_class[] = 'clearfix';

        return blaze_edge_class_attribute($sidebar_class);

    }

}


if( !function_exists('blaze_edge_sidebar_layout') ) {

    /**
     * Function that check is sidebar is enabled and return type of sidebar layout
     */

    function blaze_edge_sidebar_layout() {

        $sidebar_layout = '';
        $page_id        = blaze_edge_get_page_id();

        $page_sidebar_meta = get_post_meta($page_id, 'edgtf_sidebar_meta', true);

        if(($page_sidebar_meta !== '') && $page_id !== -1) {
            if($page_sidebar_meta == 'no-sidebar') {
                $sidebar_layout = '';
            } else {
                $sidebar_layout = $page_sidebar_meta;
            }
        } else {
            if(is_single() && blaze_edge_options()->getOptionValue('blog_single_sidebar_layout')) {
                $sidebar_layout = esc_attr(blaze_edge_options()->getOptionValue('blog_single_sidebar_layout'));
            } elseif((is_archive() || (is_home() && is_front_page())) && blaze_edge_options()->getOptionValue('archive_sidebar_layout')) {
                $sidebar_layout = esc_attr(blaze_edge_options()->getOptionValue('archive_sidebar_layout'));
            } elseif(is_page() && blaze_edge_options()->getOptionValue('page_sidebar_layout')) {
                $sidebar_layout = esc_attr(blaze_edge_options()->getOptionValue('page_sidebar_layout'));
            } elseif (! empty( $sidebar_layout ) && ! is_active_sidebar( blaze_edge_get_sidebar() ) ) {
				$sidebar_layout = '';
			}
        }

        return $sidebar_layout;

    }

}


if( !function_exists('blaze_edge_page_custom_style') ) {

    /**
     * Function that print custom page style
     */

    function blaze_edge_page_custom_style() {
       $style = array();
       $html = '';
       $style = apply_filters('blaze_edge_add_page_custom_style', $style);

		if($style !== '') {
			wp_add_inline_style( 'blaze-edge-modules', implode(' ', $style));
		}
    }
	add_action('wp_enqueue_scripts', 'blaze_edge_page_custom_style');
    
}


if( !function_exists('blaze_edge_register_page_custom_style') ) {

    /**
     * Function that print custom page style
     */

    function blaze_edge_register_page_custom_style() {
       add_action( 'wp_head', 'blaze_edge_page_custom_style' );
    }

    add_action( 'blaze_edge_after_options_map', 'blaze_edge_register_page_custom_style' );
}

if(!function_exists('blaze_edge_get_unique_page_class')) {
	/**
	 * Returns unique page class based on post type and page id
	 *
	 * @return string
	 */
	function blaze_edge_get_unique_page_class() {
		$id = blaze_edge_get_page_id();
		$page_class = '';

		if(is_single()) {
			$page_class = '.postid-'.$id;
		} elseif($id === blaze_edge_get_woo_shop_page_id()) {
			$page_class = '.archive';
        } elseif(is_home()) {
            $page_class .= '.home';
		} else {
			$page_class .= '.page-id-'.$id;
		}

		return $page_class;
	}
}

if( !function_exists('blaze_edge_container_style') ) {

    /**
     * Function that return container style
     */

    function blaze_edge_container_style($style) {
        $id = blaze_edge_get_page_id();
        $class_prefix = blaze_edge_get_unique_page_class();

        $container_selector = array(
            $class_prefix.' .edgtf-content .edgtf-content-inner > .edgtf-container',
            $class_prefix.' .edgtf-content .edgtf-content-inner > .edgtf-full-width',
        );

        $container_class = array();
        $page_background_color = get_post_meta($id, "edgtf_page_background_color_meta", true);

        if($page_background_color){
            $container_class['background-color'] = $page_background_color;
        }

        $current_style = blaze_edge_dynamic_css($container_selector, $container_class);
		$style[]       = $current_style;

        return $style;

    }
    add_filter('blaze_edge_add_page_custom_style', 'blaze_edge_container_style');
}

if( !function_exists('blaze_edge_page_padding') ) {

    /**
     * Function that return container style
     */

    function blaze_edge_page_padding( $style ) {
		
		$id = blaze_edge_get_page_id();
		$class_prefix = blaze_edge_get_unique_page_class();


        $page_selector = array(
			$class_prefix . ' .edgtf-content .edgtf-content-inner > .edgtf-container > .edgtf-container-inner',
			$class_prefix . ' .edgtf-content .edgtf-content-inner > .edgtf-full-width > .edgtf-full-width-inner'
        );

        //if single page, add selector without space and additional class
        if (is_singular( 'post' )){
			$page_selector[] = $class_prefix . '.single-post .edgtf-content .edgtf-content-inner > .edgtf-container > .edgtf-container-inner';
			$page_selector[] = $class_prefix . '.single-post .edgtf-content .edgtf-content-inner > .edgtf-full-width > .edgtf-full-width-inner';
        }

        $page_css = array();

        $page_padding = get_post_meta($id, 'edgtf_page_padding_meta', true);

        if($page_padding !== ''){
            $page_css['padding'] = $page_padding;
        }

        $current_style = blaze_edge_dynamic_css($page_selector, $page_css);

		$style[]       = $current_style;

        return $style;

    }
    add_filter('blaze_edge_add_page_custom_style', 'blaze_edge_page_padding');
}

if( !function_exists('blaze_edge_page_boxed_style') ) {

	/**
	 * Function that return container style
	 */

	function blaze_edge_page_boxed_style( $style ) {

		$id = blaze_edge_get_page_id();
		$class_prefix = blaze_edge_get_unique_page_class();

		$page_selector = array(
			$class_prefix . '.edgtf-boxed .edgtf-wrapper'
		);
		$page_css = array();

		$page_background_color 				= get_post_meta($id, 'edgtf_page_background_color_in_box_meta', true);
		$page_background_image				= get_post_meta($id, 'edgtf_boxed_background_image_meta', true);
		$page_background_image_repeating	= get_post_meta($id, 'edgtf_boxed_background_image_repeating_meta', true);

		if($page_background_color !== ''){
			$page_css['background-color'] = $page_background_color;
		}
		if($page_background_image !== '' && $page_background_image_repeating != ''){
			$page_css['background-image'] = 'url(' .$page_background_image . ')';
			$page_css['background-repeat'] = $page_background_image_repeating;

			if($page_background_image_repeating == 'no') {
				$page_css['background-position']	= 'center 0';
				$page_css['background-repeat'] 		= 'no-repeat';
			} else {
				$page_css['background-position'] 	= '0 0';
				$page_css['background-repeat'] 		= 'repeat';
			}
		}

		$current_style = blaze_edge_dynamic_css($page_selector, $page_css);

		$style[]       = $current_style;

		return $style;

	}
	add_filter('blaze_edge_add_page_custom_style', 'blaze_edge_page_boxed_style');
}

if( !function_exists('blaze_edge_header_height_style') ) {

    /**
     * Function that return header height style
     */

    function blaze_edge_header_height_style($style) {
        $id = blaze_edge_get_page_id();
        $class_prefix = blaze_edge_get_unique_page_class();

        $header_standard_selector = array(
            $class_prefix.'.edgtf-header-standard .edgtf-page-header .edgtf-menu-area',
            $class_prefix.'.edgtf-header-standard .edgtf-page-header .edgtf-logo-wrapper a',
            $class_prefix.'.edgtf-header-standard .edgtf-side-menu .edgtf-close-side-menu-holder',
        );

        $header_standard_style = array();
        $header_standard_height = get_post_meta($id, "edgtf_menu_area_height_header_standard_meta", true);

        if($header_standard_height){
            $header_standard_style['height'] = blaze_edge_filter_px($header_standard_height).'px';
        }

        $current_style = blaze_edge_dynamic_css($header_standard_selector, $header_standard_style);

        $header_fullscreen_selector = array(
            $class_prefix.'.edgtf-header-full-screen .edgtf-page-header .edgtf-menu-area',
            $class_prefix.'.edgtf-header-full-screen .edgtf-page-header .edgtf-logo-wrapper a',
            $class_prefix.'.edgtf-header-full-screen .edgtf-side-menu .edgtf-close-side-menu-holder',
        );

        $header_fullscreen_style = array();
        $header_fullscreen_height = get_post_meta($id, "edgtf_menu_area_height_header_full_screen_meta", true);

        if($header_fullscreen_height){
            $header_fullscreen_style['height'] = blaze_edge_filter_px($header_fullscreen_height).'px';
        }

        $current_style .= blaze_edge_dynamic_css($header_fullscreen_selector, $header_fullscreen_style);

        $header_expanding_selector = array(
            $class_prefix.'.edgtf-header-expanding .edgtf-page-header .edgtf-menu-area',
            $class_prefix.'.edgtf-header-expanding .edgtf-page-header .edgtf-logo-wrapper a',
            $class_prefix.'.edgtf-header-expanding .edgtf-side-menu .edgtf-close-side-menu-holder',
        );

        $header_expanding_style = array();
        $header_expanding_height = get_post_meta($id, "edgtf_menu_area_height_header_expanding_meta", true);

        if($header_expanding_height){
            $header_expanding_style['height'] = blaze_edge_filter_px($header_expanding_height).'px';
			$current_style .= blaze_edge_dynamic_css($class_prefix.'.edgtf-header-expanding.edgtf-menu-icon-with-bckg .edgtf-menu-area .edgtf-expanding-icon-holder', array('width' => $header_expanding_height.'px'));
			$current_style .= blaze_edge_dynamic_css($class_prefix.'.edgtf-header-expanding.edgtf-menu-expanded.edgtf-menu-icon-bckg-spread .edgtf-menu-area .edgtf-expanding-background', array('width' => 'calc(100% - '.$header_expanding_height.'px)'));
			$current_style .= blaze_edge_dynamic_css($class_prefix.'.edgtf-header-expanding.edgtf-menu-icon-with-bckg.edgtf-menu-icon-bckg-spread .edgtf-menu-area .edgtf-expanding-background', array('right' => $header_expanding_height.'px'));
        }

        $current_style .= blaze_edge_dynamic_css($header_expanding_selector, $header_expanding_style);
		$style[]       = $current_style;

        return $style;

    }
    add_filter('blaze_edge_add_page_custom_style', 'blaze_edge_header_height_style');
}

if(!function_exists('blaze_edge_print_custom_css')) {
    /**
     * Prints out custom css from theme options
     */
    function blaze_edge_print_custom_css() {
        $custom_css = blaze_edge_options()->getOptionValue('custom_css');

        if($custom_css !== '') {
            wp_add_inline_style( 'blaze-edge-modules', $custom_css);
        }
    }

    add_action('wp_enqueue_scripts', 'blaze_edge_print_custom_css');
}

if(!function_exists('blaze_edge_print_custom_js')) {
    /**
     * Prints out custom css from theme options
     */
    function blaze_edge_print_custom_js() {
        $custom_js = blaze_edge_options()->getOptionValue('custom_js');

        if($custom_js !== '') {
			wp_add_inline_script('blaze-edge-modules', $custom_js);
        }

    }

	add_action('wp_enqueue_scripts', 'blaze_edge_print_custom_js');
}


if(!function_exists('blaze_edge_get_global_variables')) {
    /**
     * Function that generates global variables and put them in array so they could be used in the theme
     */
    function blaze_edge_get_global_variables() {

        $global_variables = array();
        $element_appear_amount = -120;

        $global_variables['edgtfAddForAdminBar'] = is_admin_bar_showing() ? 32 : 0;
        $global_variables['edgtfElementAppearAmount'] = blaze_edge_options()->getOptionValue('element_appear_amount') !== '' ? blaze_edge_options()->getOptionValue('element_appear_amount') : $element_appear_amount;
        $global_variables['edgtfFinishedMessage'] = esc_html__('No more posts', 'blaze');
        $global_variables['edgtfLoadMoreText'] = esc_html__('Load More', 'blaze');
        $global_variables['edgtfLoadingMoreText'] = esc_html__('Loading...', 'blaze');
        $global_variables['edgtfMessage'] = esc_html__('Loading new Posts...', 'blaze');
		$global_variables['edgtfAddingToCart'] = esc_html__('adding to cart...', 'blaze');

        $global_variables = apply_filters('blaze_edge_js_global_variables', $global_variables);

        wp_localize_script('blaze-edge-modules', 'edgtfGlobalVars', array(
            'vars' => $global_variables
        ));

    }

    add_action('wp_enqueue_scripts', 'blaze_edge_get_global_variables');
}

if(!function_exists('blaze_edge_per_page_js_variables')) {
	/**
	 * Outputs global JS variable that holds page settings
	 */
	function blaze_edge_per_page_js_variables() {
        $per_page_js_vars = apply_filters('blaze_edge_per_page_js_vars', array());

        wp_localize_script('blaze-edge-modules', 'edgtfPerPageVars', array(
            'vars' => $per_page_js_vars
        ));
    }

    add_action('wp_enqueue_scripts', 'blaze_edge_per_page_js_variables');
}

if(!function_exists('blaze_edge_content_elem_style_attr')) {
    /**
     * Defines filter for adding custom styles to content HTML element
     */
    function blaze_edge_content_elem_style_attr() {
        $styles = apply_filters('blaze_edge_content_elem_style_attr', array());

        blaze_edge_inline_style($styles);
    }
}

if(!function_exists('blaze_edge_is_woocommerce_installed')) {
    /**
     * Function that checks if woocommerce is installed
     * @return bool
     */
    function blaze_edge_is_woocommerce_installed() {
        return function_exists('is_woocommerce');
    }
}

if(!function_exists('blaze_edge_visual_composer_installed')) {
    /**
     * Function that checks if visual composer installed
     * @return bool
     */
    function blaze_edge_visual_composer_installed() {
        //is Visual Composer installed?
        if(class_exists('WPBakeryVisualComposerAbstract')) {
            return true;
        }

        return false;
    }
}

if(!function_exists('blaze_edge_contact_form_7_installed')) {
    /**
     * Function that checks if contact form 7 installed
     * @return bool
     */
    function blaze_edge_contact_form_7_installed() {
        //is Contact Form 7 installed?
        if(defined('WPCF7_VERSION')) {
            return true;
        }

        return false;
    }
}

if(!function_exists('blaze_edge_is_wpml_installed')) {
    /**
     * Function that checks if WPML plugin is installed
     * @return bool
     *
     * @version 0.1
     */
    function blaze_edge_is_wpml_installed() {
        return defined('ICL_SITEPRESS_VERSION');
    }
}

if ( ! function_exists( 'blaze_edge_is_plugin_installed' ) ) {
	/**
	 * Function that checks if forward plugin installed
	 *
	 * @param $plugin string
	 *
	 * @return bool
	 */
	function blaze_edge_is_plugin_installed( $plugin ) {
		switch ( $plugin ) {
			case 'core':
				return defined( 'EDGE_CORE_VERSION' );
				break;
			case 'woocommerce':
				return function_exists( 'is_woocommerce' );
				break;
			case 'visual-composer':
				return class_exists( 'WPBakeryVisualComposerAbstract' );
				break;
			case 'revolution-slider':
				return class_exists( 'RevSliderFront' );
				break;
			case 'contact-form-7':
				return defined( 'WPCF7_VERSION' );
				break;
			case 'wpml':
				return defined( 'ICL_SITEPRESS_VERSION' );
				break;
			case 'gutenberg-editor':
				return class_exists( 'WP_Block_Type' );
				break;
			case 'gutenberg-plugin':
				return function_exists( 'is_gutenberg_page' ) && is_gutenberg_page();
				break;
			default:
				return false;
				break;
		}
	}
}

if(!function_exists('blaze_edge_max_image_width_srcset')) {
	/**
	 * Set max width for srcset to 1920
	 *
	 * @return int
	 */
	function blaze_edge_max_image_width_srcset() {
        return 1920;
    }

	add_filter('max_srcset_image_width', 'blaze_edge_max_image_width_srcset');
}

if ( ! function_exists( 'blaze_edge_get_module_part' ) ) {
	function blaze_edge_get_module_part( $module ) {
		return $module;
	}
}

if ( ! function_exists( 'blaze_edge_is_wp_gutenberg_installed' ) ) {
    /**
     * Function that checks if WordPress 5.x with Gutenberg editor installed
     * @return bool
     */
    function blaze_edge_is_wp_gutenberg_installed() {
        return class_exists( 'WP_Block_Type' );
    }
}