<?php

class BlazeEdgeSideAreaOpener extends BlazeEdgeWidget {
    public function __construct() {
        parent::__construct(
            'edgtf_side_area_opener', // Base ID
            esc_html__('Edge Side Area Opener', 'blaze') // Name
        );

        $this->setParams();
    }

    protected function setParams() {

		$this->params = array(
			array(
				'name'			=> 'side_area_opener_icon_color',
				'type'			=> 'textfield',
				'title'			=> esc_html__('Icon Color', 'blaze'),
				'description'	=> esc_html__('Define color for Side Area opener icon', 'blaze')
			)
		);

    }


    public function widget($args, $instance) {
		
		$sidearea_icon_styles = array();

		if ( !empty($instance['side_area_opener_icon_color']) ) {
			$sidearea_icon_styles[] = 'color: ' . $instance['side_area_opener_icon_color'];
		}
		
		$icon_size = '';
		if ( blaze_edge_options()->getOptionValue('side_area_predefined_icon_size') ) {
			$icon_size = blaze_edge_options()->getOptionValue('side_area_predefined_icon_size');
		}
		?>
        <a class="edgtf-side-menu-button-opener <?php echo esc_attr( $icon_size ); ?>" <?php blaze_edge_inline_style($sidearea_icon_styles) ?> href="javascript:void(0)">
            <span class="edgtf-side-menu-icon">
				<span class="edgtf-line"></span>
				<span class="edgtf-line"></span>
			</span>
        </a>

    <?php }

}