<?php

if (!function_exists('blaze_edge_register_widgets')) {

	function blaze_edge_register_widgets() {

		$widgets = array(
			'BlazeEdgeFullScreenMenuOpener',
			'BlazeEdgeLatestPosts',
			'BlazeEdgeSearchOpener',
			'BlazeEdgeSideAreaOpener',
			'BlazeEdgeStickySidebar',
			'BlazeEdgeSocialIconWidget',
			'BlazeEdgeSeparatorWidget'
		);

		if( blaze_edge_is_woocommerce_installed() ) {
			$widgets[] = 'BlazeEdgeWoocommerceDropdownCart';
		}

		if( blaze_edge_core_installed() ) {
			foreach ($widgets as $widget) {
				blaze_edge_create_wp_widget($widget);
			}
		}
	}
}

add_action('widgets_init', 'blaze_edge_register_widgets');