<?php

if (!function_exists('blaze_edge_search_opener_icon_size')) {

	function blaze_edge_search_opener_icon_size()
	{

		if (blaze_edge_options()->getOptionValue('header_search_icon_size')) {
			echo blaze_edge_dynamic_css('.edgtf-search-opener, .edgtf-header-standard .edgtf-search-opener', array(
				'font-size' => blaze_edge_filter_px(blaze_edge_options()->getOptionValue('header_search_icon_size')) . 'px'
			));
		}

	}

	add_action('blaze_edge_style_dynamic', 'blaze_edge_search_opener_icon_size');

}

if (!function_exists('blaze_edge_search_opener_icon_colors')) {

	function blaze_edge_search_opener_icon_colors()
	{

		if (blaze_edge_options()->getOptionValue('header_search_icon_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-search-opener', array(
				'color' => blaze_edge_options()->getOptionValue('header_search_icon_color')
			));
		}

		if (blaze_edge_options()->getOptionValue('header_search_icon_hover_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-search-opener:hover', array(
				'color' => blaze_edge_options()->getOptionValue('header_search_icon_hover_color')
			));
		}

		if (blaze_edge_options()->getOptionValue('header_light_search_icon_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-light-header .edgtf-page-header > div:not(.edgtf-sticky-header) .edgtf-search-opener,
			.edgtf-light-header.edgtf-header-style-on-scroll .edgtf-page-header .edgtf-search-opener,
			.edgtf-light-header .edgtf-top-bar .edgtf-search-opener', array(
				'color' => blaze_edge_options()->getOptionValue('header_light_search_icon_color') . ' !important'
			));
		}

		if (blaze_edge_options()->getOptionValue('header_light_search_icon_hover_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-light-header .edgtf-page-header > div:not(.edgtf-sticky-header) .edgtf-search-opener:hover,
			.edgtf-light-header.edgtf-header-style-on-scroll .edgtf-page-header .edgtf-search-opener:hover,
			.edgtf-light-header .edgtf-top-bar .edgtf-search-opener:hover', array(
				'color' => blaze_edge_options()->getOptionValue('header_light_search_icon_hover_color') . ' !important'
			));
		}

		if (blaze_edge_options()->getOptionValue('header_dark_search_icon_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-dark-header .edgtf-page-header > div:not(.edgtf-sticky-header) .edgtf-search-opener,
			.edgtf-dark-header.edgtf-header-style-on-scroll .edgtf-page-header .edgtf-search-opener,
			.edgtf-dark-header .edgtf-top-bar .edgtf-search-opener', array(
				'color' => blaze_edge_options()->getOptionValue('header_dark_search_icon_color') . ' !important'
			));
		}
		if (blaze_edge_options()->getOptionValue('header_dark_search_icon_hover_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-dark-header .edgtf-page-header > div:not(.edgtf-sticky-header) .edgtf-search-opener:hover,
			.edgtf-dark-header.edgtf-header-style-on-scroll .edgtf-page-header .edgtf-search-opener:hover,
			.edgtf-dark-header .edgtf-top-bar .edgtf-search-opener:hover', array(
				'color' => blaze_edge_options()->getOptionValue('header_dark_search_icon_hover_color') . ' !important'
			));
		}

	}

	add_action('blaze_edge_style_dynamic', 'blaze_edge_search_opener_icon_colors');

}

if (!function_exists('blaze_edge_search_opener_icon_background_colors')) {

	function blaze_edge_search_opener_icon_background_colors()
	{

		if (blaze_edge_options()->getOptionValue('search_icon_background_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-search-opener', array(
				'background-color' => blaze_edge_options()->getOptionValue('search_icon_background_color')
			));
		}

		if (blaze_edge_options()->getOptionValue('search_icon_background_hover_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-search-opener:hover', array(
				'background-color' => blaze_edge_options()->getOptionValue('search_icon_background_hover_color')
			));
		}

	}

	add_action('blaze_edge_style_dynamic', 'blaze_edge_search_opener_icon_background_colors');
}

if (!function_exists('blaze_edge_search_opener_text_styles')) {

	function blaze_edge_search_opener_text_styles()
	{
		$text_styles = array();

		if (blaze_edge_options()->getOptionValue('search_icon_text_color') !== '') {
			$text_styles['color'] = blaze_edge_options()->getOptionValue('search_icon_text_color');
		}
		if (blaze_edge_options()->getOptionValue('search_icon_text_fontsize') !== '') {
			$text_styles['font-size'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('search_icon_text_fontsize')) . 'px';
		}
		if (blaze_edge_options()->getOptionValue('search_icon_text_lineheight') !== '') {
			$text_styles['line-height'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('search_icon_text_lineheight')) . 'px';
		}
		if (blaze_edge_options()->getOptionValue('search_icon_text_texttransform') !== '') {
			$text_styles['text-transform'] = blaze_edge_options()->getOptionValue('search_icon_text_texttransform');
		}
		if (blaze_edge_options()->getOptionValue('search_icon_text_google_fonts') !== '-1') {
			$text_styles['font-family'] = blaze_edge_get_formatted_font_family(blaze_edge_options()->getOptionValue('search_icon_text_google_fonts')) . ', sans-serif';
		}
		if (blaze_edge_options()->getOptionValue('search_icon_text_fontstyle') !== '') {
			$text_styles['font-style'] = blaze_edge_options()->getOptionValue('search_icon_text_fontstyle');
		}
		if (blaze_edge_options()->getOptionValue('search_icon_text_fontweight') !== '') {
			$text_styles['font-weight'] = blaze_edge_options()->getOptionValue('search_icon_text_fontweight');
		}		
		if (blaze_edge_options()->getOptionValue('search_icon_text_letterspacing') !== '') {
			$text_styles['letter-spacing'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('search_icon_text_letterspacing')).'px';
		}

		if (!empty($text_styles)) {
			echo blaze_edge_dynamic_css('.edgtf-search-icon-text', $text_styles);
		}
		if (blaze_edge_options()->getOptionValue('search_icon_text_color_hover') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-search-opener:hover .edgtf-search-icon-text', array(
				'color' => blaze_edge_options()->getOptionValue('search_icon_text_color_hover')
			));
		}

	}

	add_action('blaze_edge_style_dynamic', 'blaze_edge_search_opener_text_styles');
}

if (!function_exists('blaze_edge_search_opener_spacing')) {

	function blaze_edge_search_opener_spacing()
	{
		$spacing_styles = array();

		if (blaze_edge_options()->getOptionValue('search_padding_left') !== '') {
			$spacing_styles['padding-left'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('search_padding_left')) . 'px';
		}
		if (blaze_edge_options()->getOptionValue('search_padding_right') !== '') {
			$spacing_styles['padding-right'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('search_padding_right')) . 'px';
		}
		if (blaze_edge_options()->getOptionValue('search_margin_left') !== '') {
			$spacing_styles['margin-left'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('search_margin_left')) . 'px';
		}
		if (blaze_edge_options()->getOptionValue('search_margin_right') !== '') {
			$spacing_styles['margin-right'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('search_margin_right')) . 'px';
		}

		if (!empty($spacing_styles)) {
			echo blaze_edge_dynamic_css('.edgtf-search-opener', $spacing_styles);
		}

	}

	add_action('blaze_edge_style_dynamic', 'blaze_edge_search_opener_spacing');
}

if (!function_exists('blaze_edge_search_bar_background')) {

	function blaze_edge_search_bar_background()
	{

		if (blaze_edge_options()->getOptionValue('search_background_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-search-cover, .edgtf-search-fade .edgtf-fullscreen-search-holder .edgtf-fullscreen-search-table, .edgtf-fullscreen-search-overlay, .edgtf-search-slide-window-top, .edgtf-search-slide-window-top input[type="text"]', array(
				'background-color' => blaze_edge_options()->getOptionValue('search_background_color')
			));
		}
	}

	add_action('blaze_edge_style_dynamic', 'blaze_edge_search_bar_background');
}

if (!function_exists('blaze_edge_search_text_styles')) {

	function blaze_edge_search_text_styles()
	{
		$text_styles = array();

		if (blaze_edge_options()->getOptionValue('search_text_color') !== '') {
			$text_styles['color'] = blaze_edge_options()->getOptionValue('search_text_color');
			$placeholder_webkit = array(
				'.edgtf-search-slide-window-top input[type="text"]::-webkit-input-placeholder',
				'.edgtf-search-cover input[type="text"]::-webkit-input-placeholder',
				'.edgtf-form-holder .edgtf-search-field::-webkit-input-placeholder',
				'.edgtf-fullscreen-search-opened .edgtf-form-holder .edgtf-search-field::-webkit-input-placeholder'
			);
			$placeholder_moz1 = array(
				'.edgtf-search-slide-window-top input[type="text"]:-moz-input-placeholder',
				'.edgtf-search-cover input[type="text"]:-moz-input-placeholder',
				'.edgtf-form-holder .edgtf-search-field:-moz-input-placeholder',
				'edgtf-fullscreen-search-opened .edgtf-form-holder .edgtf-search-field:-moz-input-placeholder'
			);
			$placeholder_moz2 = array(
				'.edgtf-search-slide-window-top input[type="text"]::-moz-input-placeholder',
				'.edgtf-search-cover input[type="text"]::-moz-input-placeholder',
				'.edgtf-form-holder .edgtf-search-field::-moz-input-placeholder',
				'edgtf-fullscreen-search-opened .edgtf-form-holder .edgtf-search-field::-moz-input-placeholder'
			);
			$placeholder_ms = array(
				'.edgtf-search-slide-window-top input[type="text"]:-ms-input-placeholder',
				'.edgtf-search-cover input[type="text"]:-ms-input-placeholder',
				'.edgtf-form-holder .edgtf-search-field:-ms-input-placeholder',
				'edgtf-fullscreen-search-opened .edgtf-form-holder .edgtf-search-field:-ms-input-placeholder'
			);
			echo blaze_edge_dynamic_css($placeholder_webkit,array('color' => $text_styles['color']));
			echo blaze_edge_dynamic_css($placeholder_moz1,array('color' => $text_styles['color']));
			echo blaze_edge_dynamic_css($placeholder_moz2,array('color' => $text_styles['color']));
			echo blaze_edge_dynamic_css($placeholder_ms,array('color' => $text_styles['color']));
		}
		if (blaze_edge_options()->getOptionValue('search_text_fontsize') !== '') {
			$text_styles['font-size'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('search_text_fontsize')) . 'px';
		}
		if (blaze_edge_options()->getOptionValue('search_text_texttransform') !== '') {
			$text_styles['text-transform'] = blaze_edge_options()->getOptionValue('search_text_texttransform');
		}
		if (blaze_edge_options()->getOptionValue('search_text_google_fonts') !== '-1') {
			$text_styles['font-family'] = blaze_edge_get_formatted_font_family(blaze_edge_options()->getOptionValue('search_text_google_fonts')) . ', sans-serif';
		}
		if (blaze_edge_options()->getOptionValue('search_text_fontstyle') !== '') {
			$text_styles['font-style'] = blaze_edge_options()->getOptionValue('search_text_fontstyle');
		}
		if (blaze_edge_options()->getOptionValue('search_text_fontweight') !== '') {
			$text_styles['font-weight'] = blaze_edge_options()->getOptionValue('search_text_fontweight');
		}
		if (blaze_edge_options()->getOptionValue('search_text_letterspacing') !== '') {
			$text_styles['letter-spacing'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('search_text_letterspacing')) . 'px';
		}

		if (!empty($text_styles)) {
			echo blaze_edge_dynamic_css('.edgtf-search-cover input[type="text"], .edgtf-fullscreen-search-opened .edgtf-form-holder .edgtf-search-field, .edgtf-search-slide-window-top input[type="text"]', $text_styles);
		}

	}

	add_action('blaze_edge_style_dynamic', 'blaze_edge_search_text_styles');
}

if (!function_exists('blaze_edge_search_icon_styles')) {

	function blaze_edge_search_icon_styles()
	{

		if (blaze_edge_options()->getOptionValue('search_icon_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-search-cover input[type="submit"], .edgtf-fullscreen-search-holder .edgtf-search-submit, .edgtf-search-slide-window-top .edgtf-icon-search', array(
				'color' => blaze_edge_options()->getOptionValue('search_icon_color')
			));
		}
		if (blaze_edge_options()->getOptionValue('search_icon_hover_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-search-cover input[type="submit"]:hover, .edgtf-fullscreen-search-holder .edgtf-search-submit:hover,.edgtf-search-slide-window-top .edgtf-icon-search:hover', array(
				'color' => blaze_edge_options()->getOptionValue('search_icon_hover_color')
			));
		}
		if (blaze_edge_options()->getOptionValue('search_icon_size') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-search-cover input[type="submit"], .edgtf-fullscreen-search-holder .edgtf-search-submit, .edgtf-search-slide-window-top .edgtf-icon-search', array(
				'font-size' => blaze_edge_filter_px(blaze_edge_options()->getOptionValue('search_icon_size')) . 'px'
			));
		}

	}

	add_action('blaze_edge_style_dynamic', 'blaze_edge_search_icon_styles');
}

if (!function_exists('blaze_edge_search_close_icon_styles')) {

	function blaze_edge_search_close_icon_styles()
	{

		if (blaze_edge_options()->getOptionValue('search_close_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-search-slide-window-top .edgtf-search-close i, .edgtf-search-cover .edgtf-search-close a, .edgtf-fullscreen-search-holder .edgtf-fullscreen-search-close-container a', array(
				'color' => blaze_edge_options()->getOptionValue('search_close_color')
			));
		}
		if (blaze_edge_options()->getOptionValue('search_close_hover_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-search-slide-window-top .edgtf-search-close i:hover, .edgtf-search-cover .edgtf-search-close a:hover, .edgtf-fullscreen-search-holder .edgtf-fullscreen-search-close-container a:hover', array(
				'color' => blaze_edge_options()->getOptionValue('search_close_hover_color')
			));
		}
		if (blaze_edge_options()->getOptionValue('search_close_size') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-search-slide-window-top .edgtf-search-close i, .edgtf-search-cover .edgtf-search-close a, .edgtf-fullscreen-search-holder .edgtf-fullscreen-search-close-container a', array(
				'font-size' => blaze_edge_filter_px(blaze_edge_options()->getOptionValue('search_close_size')) . 'px'
			));
		}

	}

	add_action('blaze_edge_style_dynamic', 'blaze_edge_search_close_icon_styles');
}

if (!function_exists('blaze_edge_search_border_styles')) {

	function blaze_edge_search_border_styles()
	{

		if (blaze_edge_options()->getOptionValue('search_border_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-fullscreen-search-holder .edgtf-field-holder', array(
				'border-color' => blaze_edge_options()->getOptionValue('search_border_color')
			));
		}
		if (blaze_edge_options()->getOptionValue('search_border_focus_color') !== '') {
			echo blaze_edge_dynamic_css('.edgtf-fullscreen-search-holder .edgtf-field-holder .edgtf-line', array(
				'background-color' => blaze_edge_options()->getOptionValue('search_border_focus_color')
			));
		}

	}

	add_action('blaze_edge_style_dynamic', 'blaze_edge_search_border_styles');
}

?>
