<?php

if(!function_exists('blaze_edge_register_top_header_areas')) {
    /**
     * Registers widget areas for top header bar when it is enabled
     */
    function blaze_edge_register_top_header_areas() {
        $top_bar_layout  = blaze_edge_options()->getOptionValue('top_bar_layout');
            register_sidebar(array(
                'name'          => esc_html__('Top Bar Left', 'blaze'),
                'id'            => 'edgtf-top-bar-left',
                'before_widget' => '<div id="%1$s" class="widget %2$s edgtf-top-bar-widget">',
                'after_widget'  => '</div>',
				'description'   => esc_html__( 'Widgets added here will appear on the left side in the top bar header', 'blaze' )
            ));

            //register this widget area only if top bar layout is three columns
            if($top_bar_layout === 'three-columns') {
                register_sidebar(array(
                    'name'          => esc_html__('Top Bar Center', 'blaze'),
                    'id'            => 'edgtf-top-bar-center',
                    'before_widget' => '<div id="%1$s" class="widget %2$s edgtf-top-bar-widget">',
                    'after_widget'  => '</div>',
					'description'   => esc_html__( 'Widgets added here will appear on the center in the top bar header', 'blaze' )
                ));
            }

            register_sidebar(array(
                'name'          => esc_html__('Top Bar Right', 'blaze'),
                'id'            => 'edgtf-top-bar-right',
                'before_widget' => '<div id="%1$s" class="widget %2$s edgtf-top-bar-widget">',
                'after_widget'  => '</div>',
				'description'   => esc_html__( 'Widgets added here will appear on the right side in the top bar header', 'blaze' )
            ));
    }

    add_action('widgets_init', 'blaze_edge_register_top_header_areas');
}

if ( ! function_exists( 'blaze_edge_header_widget_areas' ) ) {
	/**
	 * Registers widget areas for header types
	 */
	function blaze_edge_header_widget_areas() {

		register_sidebar(
			array(
				'id'            => 'edgtf-header-widget-sticky-area',
				'name'          => esc_html__( 'Header Widget Sticky Area', 'blaze' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s edgtf-header-widget-sticky-area">',
				'after_widget'  => '</div>',
				'description'   => esc_html__( 'Widgets added here will appear in the sticky area', 'blaze' )
			)
		);

		if( blaze_edge_core_installed() ) {
			register_sidebar(
				array(
					'id' => 'edgtf-header-widget-menu-area',
					'name' => esc_html__('Header Widget Menu Area', 'blaze'),
					'before_widget' => '<div id="%1$s" class="widget %2$s edgtf-header-widget-menu-area">',
					'after_widget' => '</div>',
					'description' => esc_html__('Widgets added here will appear in the menu area', 'blaze')
				)
			);
		}
	}

	add_action( 'widgets_init', 'blaze_edge_header_widget_areas' );
}

if(!function_exists('blaze_edge_register_mobile_header_areas')) {
    /**
     * Registers widget areas for mobile header
     */
    function blaze_edge_register_mobile_header_areas() {
        if(blaze_edge_is_responsive_on()) {
            register_sidebar(array(
                'name'          => esc_html__('Right From Mobile Logo', 'blaze'),
                'id'            => 'edgtf-right-from-mobile-logo',
                'before_widget' => '<div id="%1$s" class="widget %2$s edgtf-right-from-mobile-logo">',
                'after_widget'  => '</div>',
                'description'   => esc_html__('Widgets added here will appear on the right hand side from the mobile logo', 'blaze')
            ));
        }
    }

    add_action('widgets_init', 'blaze_edge_register_mobile_header_areas');
}