<?php

if ( ! function_exists('blaze_edge_fullscreen_menu_options_map')) {

	function blaze_edge_fullscreen_menu_options_map() {

		$fullscreen_panel = blaze_edge_add_admin_panel(
			array(
				'title' => esc_html__('Minimal Menu','blaze'),
				'name' => 'fullscreen_menu',
				'page' => '_header_page',
				'hidden_property' => 'header_type',
				'hidden_value' => '',
				'hidden_values' => array(
					'header-standard',
					'header-vertical',
					'header-expanding'
				)
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $fullscreen_panel,
				'type' => 'yesno',
				'name' => 'enable_full_screen_menu_header_full_screen',
				'default_value' => 'yes',
				'label' => esc_html__('Enable Full Screen Menu','blaze'),
				'description' => esc_html__('Set header menu to open in fullscreen','blaze'),
				'args' => array(
					"dependence" => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#edgtf_header_full_screen_menu_full_container"
				)
			)
		);

		$header_full_screen_menu_full_container = blaze_edge_add_admin_container(array(
			'name' => 'header_full_screen_menu_full_container',
			'parent' => $fullscreen_panel,
			'hidden_property' => 'enable_full_screen_menu_header_full_screen',
			'hidden_value' => 'no'
		));

		blaze_edge_add_admin_field(
			array(
				'parent' => $header_full_screen_menu_full_container,
				'type' => 'select',
				'name' => 'fullscreen_menu_animation_style',
				'default_value' => 'fade-push-text-right',
				'label' => esc_html__('Fullscreen Menu Overlay Animation','blaze'),
				'description' => esc_html__('Choose animation type for fullscreen menu overlay','blaze'),
				'options' => array(
					'fade-push-text-right' => esc_html__('Fade Push Text Right','blaze'),
					'fade-push-text-top' => esc_html__('Fade Push Text Top','blaze'),
					'fade-text-scaledown' => esc_html__('Fade Text Scaledown','blaze'),
				)
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $header_full_screen_menu_full_container,
				'type' => 'selectblank',
				'name' => 'fullscreen_alignment',
				'default_value' => '',
				'label' => esc_html__('Fullscreen Menu Alignment','blaze'),
				'description' => esc_html__('Choose alignment for fullscreen menu content','blaze'),
				'options' => array(
					"left" => esc_html__('Left','blaze'),
					"center" => esc_html__('Center','blaze'),
					"right" => esc_html__('Right','blaze'),
				)
			)
		);

		$background_group = blaze_edge_add_admin_group(
			array(
				'parent' => $fullscreen_panel,
				'name' => 'background_group',
				'title' => esc_html__('Background','blaze'),
				'description' => esc_html__('Select a background color and transparency for Minimal Menu (0 = fully transparent, 1 = opaque)','blaze'),

			)
		);

		$background_group_row = blaze_edge_add_admin_row(
			array(
				'parent' => $background_group,
				'name' => 'background_group_row'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $background_group_row,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_background_color',
				'default_value' => '',
				'label' => esc_html__('Background Color','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $background_group_row,
				'type' => 'textsimple',
				'name' => 'fullscreen_menu_background_transparency',
				'default_value' => '',
				'label' => esc_html__('Transparency (values:0-1)','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $fullscreen_panel,
				'type' => 'image',
				'name' => 'fullscreen_menu_background_image',
				'default_value' => '',
				'label' => esc_html__('Background Image','blaze'),
				'description' => esc_html__('Choose a background image for Minimal Menu background','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $fullscreen_panel,
				'type' => 'image',
				'name' => 'fullscreen_menu_pattern_image',
				'default_value' => '',
				'label' => esc_html__('Pattern Background Image','blaze'),
				'description' => esc_html__('Choose a pattern image for Minimal Menu background','blaze'),
			)
		);

//1st level style group
		$first_level_style_group = blaze_edge_add_admin_group(
			array(
				'parent' => $fullscreen_panel,
				'name' => 'first_level_style_group',
				'title' => esc_html__('1st Level Style','blaze'),
				'description' => esc_html__('Define styles for 1st level in Minimal Menu','blaze'),
			)
		);

		$first_level_style_row1 = blaze_edge_add_admin_row(
			array(
				'parent' => $first_level_style_group,
				'name' => 'first_level_style_row1'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $first_level_style_row1,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_color',
				'default_value' => '',
				'label' => esc_html__('Text Color','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $first_level_style_row1,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_hover_color',
				'default_value' => '',
				'label' => esc_html__('Hover Text Color','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $first_level_style_row1,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_active_color',
				'default_value' => '',
				'label' => esc_html__('Active Text Color','blaze'),
			)
		);

		$first_level_style_row2 = blaze_edge_add_admin_row(
			array(
				'parent' => $first_level_style_group,
				'name' => 'first_level_style_row2'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $first_level_style_row2,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_hover_background_color',
				'default_value' => '',
				'label' => esc_html__('Background Hover Color','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $first_level_style_row2,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_active_background_color',
				'default_value' => '',
				'label' => esc_html__('Background Active Color','blaze'),
			)
		);

		$first_level_style_row3 = blaze_edge_add_admin_row(
			array(
				'parent' => $first_level_style_group,
				'name' => 'first_level_style_row3'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $first_level_style_row3,
				'type' => 'fontsimple',
				'name' => 'fullscreen_menu_google_fonts',
				'default_value' => '-1',
				'label' => esc_html__('Font Family','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $first_level_style_row3,
				'type' => 'textsimple',
				'name' => 'fullscreen_menu_fontsize',
				'default_value' => '',
				'label' => esc_html__('Font Size','blaze'),
				'args' => array(
					'suffix' => 'px'
				)
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $first_level_style_row3,
				'type' => 'textsimple',
				'name' => 'fullscreen_menu_lineheight',
				'default_value' => '',
				'label' => esc_html__('Line Height','blaze'),
				'args' => array(
					'suffix' => 'px'
				)
			)
		);

		$first_level_style_row4 = blaze_edge_add_admin_row(
			array(
				'parent' => $first_level_style_group,
				'name' => 'first_level_style_row4'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $first_level_style_row4,
				'type' => 'selectblanksimple',
				'name' => 'fullscreen_menu_fontstyle',
				'default_value' => '',
				'label' => esc_html__('Font Style','blaze'),
				'options' => blaze_edge_get_font_style_array()
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $first_level_style_row4,
				'type' => 'selectblanksimple',
				'name' => 'fullscreen_menu_fontweight',
				'default_value' => '',
				'label' => esc_html__('Font Weight','blaze'),
				'options' => blaze_edge_get_font_weight_array()
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $first_level_style_row4,
				'type' => 'textsimple',
				'name' => 'fullscreen_menu_letterspacing',
				'default_value' => '',
				'label' => esc_html__('Letter Spacing','blaze'),
				'args' => array(
					'suffix' => 'px'
				)
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $first_level_style_row4,
				'type' => 'selectblanksimple',
				'name' => 'fullscreen_menu_texttransform',
				'default_value' => '',
				'label' => esc_html__('Text Transform','blaze'),
				'options' => blaze_edge_get_text_transform_array()
			)
		);

//2nd level style group
		$second_level_style_group = blaze_edge_add_admin_group(
			array(
				'parent' => $fullscreen_panel,
				'name' => 'second_level_style_group',
				'title' => esc_html__('2nd Level Style','blaze'),
				'description' => esc_html__('Define styles for 2nd level in Minimal Menu','blaze'),
			)
		);

		$second_level_style_row1 = blaze_edge_add_admin_row(
			array(
				'parent' => $second_level_style_group,
				'name' => 'second_level_style_row1'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $second_level_style_row1,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_color_2nd',
				'default_value' => '',
				'label' => esc_html__('Text Color','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $second_level_style_row1,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_hover_color_2nd',
				'default_value' => '',
				'label' => esc_html__('Hover Text Color','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $second_level_style_row1,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_hover_background_color_2nd',
				'default_value' => '',
				'label' => esc_html__('Background Hover Color','blaze'),
			)
		);

		$second_level_style_row2 = blaze_edge_add_admin_row(
			array(
				'parent' => $second_level_style_group,
				'name' => 'second_level_style_row2'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $second_level_style_row2,
				'type' => 'fontsimple',
				'name' => 'fullscreen_menu_google_fonts_2nd',
				'default_value' => '-1',
				'label' => esc_html__('Font Family','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $second_level_style_row2,
				'type' => 'textsimple',
				'name' => 'fullscreen_menu_fontsize_2nd',
				'default_value' => '',
				'label' => esc_html__('Font Size','blaze'),
				'args' => array(
					'suffix' => 'px'
				)
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $second_level_style_row2,
				'type' => 'textsimple',
				'name' => 'fullscreen_menu_lineheight_2nd',
				'default_value' => '',
				'label' => esc_html__('Line Height','blaze'),
				'args' => array(
					'suffix' => 'px'
				)
			)
		);

		$second_level_style_row3 = blaze_edge_add_admin_row(
			array(
				'parent' => $second_level_style_group,
				'name' => 'second_level_style_row3'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $second_level_style_row3,
				'type' => 'selectblanksimple',
				'name' => 'fullscreen_menu_fontstyle_2nd',
				'default_value' => '',
				'label' => esc_html__('Font Style','blaze'),
				'options' => blaze_edge_get_font_style_array()
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $second_level_style_row3,
				'type' => 'selectblanksimple',
				'name' => 'fullscreen_menu_fontweight_2nd',
				'default_value' => '',
				'label' => esc_html__('Font Weight','blaze'),
				'options' => blaze_edge_get_font_weight_array()
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $second_level_style_row3,
				'type' => 'textsimple',
				'name' => 'fullscreen_menu_letterspacing_2nd',
				'default_value' => '',
				'label' => esc_html__('Letter Spacing','blaze'),
				'args' => array(
					'suffix' => 'px'
				)
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $second_level_style_row3,
				'type' => 'selectblanksimple',
				'name' => 'fullscreen_menu_texttransform_2nd',
				'default_value' => '',
				'label' => esc_html__('Text Transform','blaze'),
				'options' => blaze_edge_get_text_transform_array()
			)
		);

		$third_level_style_group = blaze_edge_add_admin_group(
			array(
				'parent' => $fullscreen_panel,
				'name' => 'third_level_style_group',
				'title' => esc_html__('3rd Level Style','blaze'),
				'description' => esc_html__('Define styles for 3rd level in Minimal Menu','blaze'),
			)
		);

		$third_level_style_row1 = blaze_edge_add_admin_row(
			array(
				'parent' => $third_level_style_group,
				'name' => 'third_level_style_row1'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $third_level_style_row1,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_color_3rd',
				'default_value' => '',
				'label' => esc_html__('Text Color','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $third_level_style_row1,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_hover_color_3rd',
				'default_value' => '',
				'label' => esc_html__('Hover Text Color','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $third_level_style_row1,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_hover_background_color_3rd',
				'default_value' => '',
				'label' => esc_html__('Background Hover Color','blaze'),
			)
		);

		$third_level_style_row2 = blaze_edge_add_admin_row(
			array(
				'parent' => $third_level_style_group,
				'name' => 'second_level_style_row2'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $third_level_style_row2,
				'type' => 'fontsimple',
				'name' => 'fullscreen_menu_google_fonts_3rd',
				'default_value' => '-1',
				'label' => esc_html__('Font Family','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $third_level_style_row2,
				'type' => 'textsimple',
				'name' => 'fullscreen_menu_fontsize_3rd',
				'default_value' => '',
				'label' => esc_html__('Font Size','blaze'),
				'args' => array(
					'suffix' => 'px'
				)
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $third_level_style_row2,
				'type' => 'textsimple',
				'name' => 'fullscreen_menu_lineheight_3rd',
				'default_value' => '',
				'label' => esc_html__('Line Height','blaze'),
				'args' => array(
					'suffix' => 'px'
				)
			)
		);

		$third_level_style_row3 = blaze_edge_add_admin_row(
			array(
				'parent' => $third_level_style_group,
				'name' => 'second_level_style_row3'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $third_level_style_row3,
				'type' => 'selectblanksimple',
				'name' => 'fullscreen_menu_fontstyle_3rd',
				'default_value' => '',
				'label' => esc_html__('Font Style','blaze'),
				'options' => blaze_edge_get_font_style_array()
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $third_level_style_row3,
				'type' => 'selectblanksimple',
				'name' => 'fullscreen_menu_fontweight_3rd',
				'default_value' => '',
				'label' => esc_html__('Font Weight','blaze'),
				'options' => blaze_edge_get_font_weight_array()
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $third_level_style_row3,
				'type' => 'textsimple',
				'name' => 'fullscreen_menu_letterspacing_3rd',
				'default_value' => '',
				'label' => esc_html__('Letter Spacing','blaze'),
				'args' => array(
					'suffix' => 'px'
				)
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $third_level_style_row3,
				'type' => 'selectblanksimple',
				'name' => 'fullscreen_menu_texttransform_3rd',
				'default_value' => '',
				'label' => esc_html__('Text Transform','blaze'),
				'options' => blaze_edge_get_text_transform_array()
			)
		);

		$icon_colors_group = blaze_edge_add_admin_group(
			array(
				'parent' => $fullscreen_panel,
				'name' => 'fullscreen_menu_icon_colors_group',
				'title' => esc_html__('Minimal Menu Icon Style','blaze'),
				'description' => esc_html__('Define styles for Minimal Menu Icon','blaze'),
			)
		);

		$icon_colors_row1 = blaze_edge_add_admin_row(
			array(
				'parent' => $icon_colors_group,
				'name' => 'icon_colors_row1'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $icon_colors_row1,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_icon_color',
				'label' => esc_html__('Color','blaze'),
			)
		);
		blaze_edge_add_admin_field(
			array(
				'parent' => $icon_colors_row1,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_icon_hover_color',
				'label' => esc_html__('Hover Color','blaze'),
			)
		);
		$icon_colors_row2 = blaze_edge_add_admin_row(
			array(
				'parent' => $icon_colors_group,
				'name' => 'icon_colors_row2',
				'next' => true
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $icon_colors_row2,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_light_icon_color',
				'label' => esc_html__('Light Menu Icon Color','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $icon_colors_row2,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_light_icon_hover_color',
				'label' => esc_html__('Light Menu Icon Hover Color','blaze'),
			)
		);

		$icon_colors_row3 = blaze_edge_add_admin_row(
			array(
				'parent' => $icon_colors_group,
				'name' => 'icon_colors_row3',
				'next' => true
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $icon_colors_row3,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_dark_icon_color',
				'label' => esc_html__('Dark Menu Icon Color','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $icon_colors_row3,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_dark_icon_hover_color',
				'label' => esc_html__('Dark Menu Icon Hover Color','blaze'),
			)
		);

		$icon_colors_row4 = blaze_edge_add_admin_row(
			array(
				'parent' => $icon_colors_group,
				'name' => 'icon_colors_row4',
				'next' => true
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $icon_colors_row4,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_icon_background_color',
				'label' => esc_html__('Background Color','blaze'),
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $icon_colors_row4,
				'type' => 'colorsimple',
				'name' => 'fullscreen_menu_icon_background_hover_color',
				'label' => esc_html__('Background Hover Color','blaze'),
			)
		);

		$icon_spacing_group = blaze_edge_add_admin_group(
			array(
				'parent' => $fullscreen_panel,
				'name' => 'icon_spacing_group',
				'title' => esc_html__('Minimal Menu Icon Spacing','blaze'),
				'description' => esc_html__('Define padding and margin for minimal menu icon','blaze'),
			)
		);

		$icon_spacing_row = blaze_edge_add_admin_row(
			array(
				'parent' => $icon_spacing_group,
				'name' => 'icon_spacing_row'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $icon_spacing_row,
				'type' => 'textsimple',
				'name' => 'fullscreen_menu_icon_margin_left',
				'default_value' => '',
				'label' => esc_html__('Margin Left','blaze'),
				'args' => array(
					'suffix' => 'px'
				)
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $icon_spacing_row,
				'type' => 'textsimple',
				'name' => 'fullscreen_menu_icon_margin_right',
				'default_value' => '',
				'label' => esc_html__('Margin Right','blaze'),
				'args' => array(
					'suffix' => 'px'
				)
			)
		);

	}

	add_action('blaze_edge_options_map', 'blaze_edge_fullscreen_menu_options_map', 16);

}