<?php

if ( ! function_exists('blaze_edge_page_options_map') ) {

    function blaze_edge_page_options_map() {

        blaze_edge_add_admin_page(
            array(
                'slug'  => '_page_page',
                'title' => esc_html__('Page', 'blaze'),
                'icon'  => 'fa fa-file-o'
            )
        );

        $custom_sidebars = blaze_edge_get_custom_sidebars();

        $panel_sidebar = blaze_edge_add_admin_panel(
            array(
                'page'  => '_page_page',
                'name'  => 'panel_sidebar',
                'title' => esc_html__('Design Style', 'blaze')
            )
        );

        blaze_edge_add_admin_field(array(
            'name'        => 'page_sidebar_layout',
            'type'        => 'select',
            'label'       => esc_html__('Sidebar Layout', 'blaze'),
            'description' => esc_html__('Choose a sidebar layout for pages', 'blaze'),
            'default_value' => 'default',
            'parent'      => $panel_sidebar,
            'options'     => array(
                'default'			=> esc_html__('No Sidebar', 'blaze'),
                'sidebar-33-right'	=> esc_html__('Sidebar 1/3 Right', 'blaze'),
                'sidebar-25-right' 	=> esc_html__('Sidebar 1/4 Right', 'blaze'),
                'sidebar-33-left' 	=> esc_html__('Sidebar 1/3 Left', 'blaze'),
                'sidebar-25-left' 	=> esc_html__('Sidebar 1/4 Left', 'blaze')
            )
        ));


        if(count($custom_sidebars) > 0) {
            blaze_edge_add_admin_field(array(
                'name' => 'page_custom_sidebar',
                'type' => 'selectblank',
                'label' => esc_html__('Sidebar to Display', 'blaze'),
                'description' => esc_html__('Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'blaze'),
                'parent' => $panel_sidebar,
                'options' => $custom_sidebars
            ));
        }
    }

    add_action( 'blaze_edge_options_map', 'blaze_edge_page_options_map', 8);

}