<?php
if(!function_exists('blaze_edge_map_slider_meta_fields')) {

    function blaze_edge_map_slider_meta_fields() {

		//Slider

		$slider_meta_box = blaze_edge_create_meta_box(
			array(
				'scope' => array('slides'),
				'title' => esc_html__('Slide Background', 'blaze'),
				'name' => 'slides_type'
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_slide_background_type',
				'type'          => 'select',
				'default_value' => 'image',
				'label'         => esc_html__('Slide Background Type', 'blaze'),
				'description'   => esc_html__('Do you want to upload an image or video?', 'blaze'),
				'parent'        => $slider_meta_box,
				'options'       => array(
					"image" => esc_html__("Image", 'blaze'),
					"video" => esc_html__("Video", 'blaze')
				),
				'args' => array(
					"dependence" => true,
					"hide" => array(
						"image" => "#edgtf_edgtf_slides_video_settings",
						"video" => "#edgtf_edgtf_slides_image_settings"
					),
					"show" => array(
						"image" => "#edgtf_edgtf_slides_image_settings",
						"video" => "#edgtf_edgtf_slides_video_settings"
					)
				)
			)
		);


		//Slide Image

		$image_meta_container = blaze_edge_add_admin_container(
			array(
				'name' => 'edgtf_slides_image_settings',
				'parent' => $slider_meta_box,
				'hidden_property' => 'edgtf_slide_background_type',
				'hidden_values' => array('video')
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_image',
				'type'        => 'image',
				'label'       => esc_html__('Slide Image', 'blaze'),
				'description' => esc_html__('Choose background image', 'blaze'),
				'parent'      => $image_meta_container
			)
		);
		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_image_tablet',
				'type'        => 'image',
				'label'       => esc_html__('Slide Image on Width Under 768px', 'blaze'),
				'description' => esc_html__('Choose background image', 'blaze'),
				'parent'      => $image_meta_container
			)
		);
		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_image_phone',
				'type'        => 'image',
				'label'       => esc_html__('Slide Image on Width Under 600px', 'blaze'),
				'description' => esc_html__('Choose background image', 'blaze'),
				'parent'      => $image_meta_container
			)
		);
		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_overlay_image',
				'type'        => 'image',
				'label'       => esc_html__('Overlay Image', 'blaze'),
				'description' => esc_html__('Choose overlay image (pattern) for background image', 'blaze'),
				'parent'      => $image_meta_container
			)
		);


		//Slide Video

		$video_meta_container = blaze_edge_add_admin_container(
			array(
				'name' => 'edgtf_slides_video_settings',
				'parent' => $slider_meta_box,
				'hidden_property' => 'edgtf_slide_background_type',
				'hidden_values' => array('image')
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_video_webm',
				'type'        => 'text',
				'label'       => esc_html__('Video - webm', 'blaze'),
				'description' => esc_html__('Path to the webm file that you have previously uploaded in Media Section', 'blaze'),
				'parent'      => $video_meta_container
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_video_mp4',
				'type'        => 'text',
				'label'       => esc_html__('Video - mp4', 'blaze'),
				'description' => esc_html__('Path to the mp4 file that you have previously uploaded in Media Section', 'blaze'),
				'parent'      => $video_meta_container
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_video_ogv',
				'type'        => 'text',
				'label'       => esc_html__('Video - ogv', 'blaze'),
				'description' => esc_html__('Path to the ogv file that you have previously uploaded in Media Section', 'blaze'),
				'parent'      => $video_meta_container
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_video_image',
				'type'        => 'image',
				'label'       => esc_html__('Video Preview Image', 'blaze'),
				'description' => esc_html__('Choose background image that will be visible until video is loaded. This image will be shown on touch devices too.', 'blaze'),
				'parent'      => $video_meta_container
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_slide_video_overlay',
				'type' => 'yesempty',
				'default_value' => '',
				'label' => esc_html__('Video Overlay Image', 'blaze'),
				'description' => esc_html__('Do you want to have a overlay image on video?', 'blaze'),
				'parent' => $video_meta_container,
				'args' => array(
					"dependence" => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#edgtf_edgtf_slide_video_overlay_container"
				)
			)
		);

		$slide_video_overlay_container = blaze_edge_add_admin_container(array(
			'name' => 'edgtf_slide_video_overlay_container',
			'parent' => $video_meta_container,
			'hidden_property' => 'edgtf_slide_video_overlay',
			'hidden_values' => array('','no')
		));

		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_video_overlay_image',
				'type'        => 'image',
				'label'       => esc_html__('Overlay Image', 'blaze'),
				'description' => esc_html__('Choose overlay image (pattern) for background video.', 'blaze'),
				'parent'      => $slide_video_overlay_container
			)
		);


		//Slide Elements

		$elements_meta_box = blaze_edge_create_meta_box(
			array(
				'scope' => array('slides'),
				'title' => esc_html__('Slide Elements', 'blaze'),
				'name' => 'edgtf_slides_elements'
			)
		);

		blaze_edge_add_admin_section_title(
			array(
				'parent' => $elements_meta_box,
				'name' => 'edgtf_slides_elements_frame',
				'title' => esc_html__('Elements Holder Frame', 'blaze')
			)
		);

		blaze_edge_add_slide_holder_frame_scheme(
			array(
				'parent' => $elements_meta_box
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_holder_elements_alignment',
				'type'        => 'select',
				'label'       => esc_html__('Elements Alignment', 'blaze'),
				'description' => esc_html__('How elements are aligned with respect to the Holder Frame', 'blaze'),
				'parent'      => $elements_meta_box,
				'default_value' => 'center',
				'options' => array(
					"center" => esc_html__("Center", 'blaze'),
					"left" => esc_html__("Left", 'blaze'),
					"right" => esc_html__("Right", 'blaze'),
					"custom" => esc_html__("Custom", 'blaze')
				),
				'args'        => array(
					"dependence" => true,
					"hide" => array(
						"center" => "#edgtf_edgtf_slide_holder_frame_height",
						"left" => "#edgtf_edgtf_slide_holder_frame_height",
						"right" => "#edgtf_edgtf_slide_holder_frame_height",
						"custom" => ""
					),
					"show" => array(
						"center" => "",
						"left" => "",
						"right" => "",
						"custom" => "#edgtf_edgtf_slide_holder_frame_height"
					)
				)
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_holder_frame_in_grid',
				'type'        => 'select',
				'label'       => esc_html__('Holder Frame in Grid?', 'blaze'),
				'description' => esc_html__('Whether to keep the holder frame width the same as that of the grid.', 'blaze'),
				'parent'      => $elements_meta_box,
				'default_value' => 'no',
				'options' => array(
					"yes" => esc_html__("Yes", 'blaze'),
					"no" => esc_html__("No", 'blaze')
				),
				'args'        => array(
					"dependence" => true,
					"hide" => array(
						"yes" => "#edgtf_edgtf_slide_holder_frame_width, #edgtf_edgtf_holder_frame_responsive_container",
						"no" => ""
					),
					"show" => array(
						"yes" => "",
						"no" => "#edgtf_edgtf_slide_holder_frame_width, #edgtf_edgtf_holder_frame_responsive_container"
					)
				)
			)
		);

		$holder_frame = blaze_edge_add_admin_group(array(
			'title' => esc_html__('Holder Frame Properties', 'blaze'),
			'description' => esc_html__('The frame is always positioned centrally on the slide. All elements are positioned and sized relatively to the holder frame. Refer to the scheme above.', 'blaze'),
			'name' => 'edgtf_holder_frame',
			'parent' => $elements_meta_box
		));

		$row1 = blaze_edge_add_admin_row(array(
			'name' => 'row1',
			'parent' => $holder_frame
		));

		$holder_frame_width = blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_holder_frame_width',
				'type'        => 'textsimple',
				'label'       => esc_html__('Relative width (C/A*100)', 'blaze'),
				'parent'      => $row1,
				'hidden_property' => 'edgtf_slide_holder_frame_in_grid',
				'hidden_values' => array('yes')
			)
		);

		$holder_frame_height = blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_holder_frame_height',
				'type'        => 'textsimple',
				'label'       => esc_html__('Height to width ratio (D/C*100)', 'blaze'),
				'parent'      => $row1,
				'hidden_property' => 'edgtf_slide_holder_elements_alignment',
				'hidden_values' => array('center', 'left', 'right')
			)
		);

		$holder_frame_responsive_container = blaze_edge_add_admin_container(array(
			'name' => 'edgtf_holder_frame_responsive_container',
			'parent' => $elements_meta_box,
			'hidden_property' => 'edgtf_slide_holder_frame_in_grid',
			'hidden_values' => array('yes')
		));

		$holder_frame_responsive = blaze_edge_add_admin_group(array(
			'title' => esc_html__('Responsive Relative Width', 'blaze'),
			'description' => esc_html__('Enter different relative widths of the holder frame for each responsive stage. Leave blank to have the frame width scale proportionally to the screen size.', 'blaze'),
			'name' => 'edgtf_holder_frame_responsive',
			'parent' => $holder_frame_responsive_container
		));

		$screen_widths_holder_frame = array(
			// These values must match those in edgt.layout.inc, slider.php and shortcodes.js
			"mobile" => 600,
			"tabletp" => 800,
			"tabletl" => 1024,
			"laptop" => 1440
		);

		$row2 = blaze_edge_add_admin_row(array(
			'name' => 'row2',
			'parent' => $holder_frame_responsive
		));

		$holder_frame_width = blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_holder_frame_width_mobile',
				'type'        => 'textsimple',
                'label'       => esc_html__('Mobile', 'blaze') . '(' . esc_html__('up to', 'blaze') . $screen_widths_holder_frame["mobile"].'px)',
				'parent'      => $row2
			)
		);

		$holder_frame_height = blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_holder_frame_width_tablet_p',
				'type'        => 'textsimple',
                'label'       => esc_html__('Tablet - Portrait', 'blaze') . ' ('.($screen_widths_holder_frame["mobile"]+1).'px - '.$screen_widths_holder_frame["tabletp"].'px)',
				'parent'      => $row2
			)
		);

		$holder_frame_height = blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_holder_frame_width_tablet_l',
				'type'        => 'textsimple',
                'label'       => esc_html__('Tablet - Landscape', 'blaze') . ' ('.($screen_widths_holder_frame["tabletp"]+1).'px - '.$screen_widths_holder_frame["tabletl"].'px)',
				'parent'      => $row2
			)
		);

		$row3 = blaze_edge_add_admin_row(array(
			'name' => 'row3',
			'parent' => $holder_frame_responsive
		));

		$holder_frame_width = blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_holder_frame_width_laptop',
				'type'        => 'textsimple',
                'label'       => esc_html__('Laptop', 'blaze') . '('.($screen_widths_holder_frame["tabletl"]+1).'px - '.$screen_widths_holder_frame["laptop"].'px)',
				'parent'      => $row3
			)
		);

		$holder_frame_height = blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_slide_holder_frame_width_desktop',
				'type'        => 'textsimple',
                'label'       => esc_html__('Desktop', 'blaze') . '(' . esc_html__('above', 'blaze') . $screen_widths_holder_frame["laptop"].'px)',
				'parent'      => $row3
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'parent' => $elements_meta_box,
				'type' => 'text',
				'name' => 'edgtf_slide_elements_default_width',
				'label' => esc_html__('Default Screen Width in px (A)', 'blaze'),
				'description' => esc_html__('All elements marked as responsive scale at the ratio of the actual screen width to this screen width. Default is 1920px.', 'blaze')
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'parent' => $elements_meta_box,
				'type' => 'select',
				'name' => 'edgtf_slide_elements_default_animation',
				'default_value' => 'none',
				'label' => esc_html__('Default Elements Animation', 'blaze'),
				'description' => esc_html__('This animation will be applied to all elements except those with their own animation settings.', 'blaze'),
				'options' => array(
					"none" => esc_html__("No Animation", 'blaze'),
					"flip" => esc_html__("Flip", 'blaze'),
					"spin" => esc_html__("Spin", 'blaze'),
					"fade" => esc_html__("Fade In", 'blaze'),
					"from_bottom" => esc_html__("Fly In From Bottom", 'blaze'),
					"from_top" => esc_html__("Fly In From Top", 'blaze'),
					"from_left" => esc_html__("Fly In From Left", 'blaze'),
					"from_right" => esc_html__("Fly In From Right", 'blaze')
				)
			)
		);

		blaze_edge_add_admin_section_title(
			array(
				'parent' => $elements_meta_box,
				'name' => 'edgtf_slides_elements_list',
				'title' => esc_html__('Elements', 'blaze')
			)
		);

		$slide_elements = blaze_edge_add_slide_elements_framework(
			array(
				'parent' => $elements_meta_box,
				'name' => 'edgtf_slides_elements_holder'
			)
		);

		//Slide Behaviour

		$behaviours_meta_box = blaze_edge_create_meta_box(
			array(
				'scope' => array('slides'),
				'title' => esc_html__('Slide Behaviours', 'blaze'),
				'name' => 'edgtf_slides_behaviour_settings'
			)
		);

		blaze_edge_add_admin_section_title(
			array(
				'parent' => $behaviours_meta_box,
				'name' => 'edgtf_header_styling_title',
				'title' => esc_html__('Header', 'blaze')
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'parent' => $behaviours_meta_box,
				'type' => 'selectblank',
				'name' => 'edgtf_slide_header_style',
				'default_value' => '',
				'label' => esc_html__('Header Style', 'blaze'),
				'description' => esc_html__('Header style will be applied when this slide is in focus', 'blaze'),
				'options' => array(
					"light" => esc_html__("Light", 'blaze'),
					"dark" => esc_html__("Dark", 'blaze')
				)
			)
		);

		blaze_edge_add_admin_section_title(
			array(
				'parent' => $behaviours_meta_box,
				'name' => 'edgtf_image_animation_title',
				'title' => esc_html__('Slide Image Animation', 'blaze')
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_enable_image_animation',
				'type' => 'yesno',
				'default_value' => 'no',
				'label' => esc_html__('Enable Image Animation', 'blaze'),
				'description' => esc_html__('Enabling this option will turn on a motion animation on the slide image', 'blaze'),
				'parent' => $behaviours_meta_box,
				'args' => array(
					"dependence" => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#edgtf_edgtf_enable_image_animation_container"
				)
			)
		);

		$enable_image_animation_container = blaze_edge_add_admin_container(array(
			'name' => 'edgtf_enable_image_animation_container',
			'parent' => $behaviours_meta_box,
			'hidden_property' => 'edgtf_enable_image_animation',
			'hidden_value' => 'no'
		));

		blaze_edge_create_meta_box_field(
			array(
				'parent' => $enable_image_animation_container,
				'type' => 'select',
				'name' => 'edgtf_enable_image_animation_type',
				'default_value' => 'zoom_center',
				'label' => esc_html__('Animation Type', 'blaze'),
				'options' => array(
					"zoom_center" => esc_html__("Zoom In Center", 'blaze'),
					"zoom_top_left" => esc_html__("Zoom In to Top Left", 'blaze'),
					"zoom_top_right" => esc_html__("Zoom In to Top Right", 'blaze'),
					"zoom_bottom_left" => esc_html__("Zoom In to Bottom Left", 'blaze'),
					"zoom_bottom_right" => esc_html__("Zoom In to Bottom Right", 'blaze')
				)
			)
		);
	}

    add_action('blaze_edge_meta_boxes_map', 'blaze_edge_map_slider_meta_fields');
}