<?php
if(!function_exists('blaze_edge_map_post_format_video_meta_fields')) {

    function blaze_edge_map_post_format_video_meta_fields() {

		/*** Video Post Format ***/

		$video_post_format_meta_box = blaze_edge_create_meta_box(
			array(
				'scope' =>	array('post'),
				'title' => 	esc_html__('Video Post Format', 'blaze'),
				'name' 	=> 'post_format_video_meta'
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_video_type_meta',
				'type'        => 'select',
				'label'       => esc_html__('Video Type', 'blaze'),
				'description' => esc_html__('Choose video type', 'blaze'),
				'parent'      => $video_post_format_meta_box,
				'default_value' => 'youtube',
				'options'     => array(
					'youtube' => esc_html__('Youtube', 'blaze'),
					'vimeo' => esc_html__('Vimeo', 'blaze'),
					'self' => esc_html__('Self Hosted', 'blaze')
				),
				'args' => array(
				'dependence' => true,
				'hide' => array(
					'youtube' => '#edgtf_edgtf_video_self_hosted_container',
					'vimeo' => '#edgtf_edgtf_video_self_hosted_container',
					'self' => '#edgtf_edgtf_video_embedded_container'
				),
				'show' => array(
					'youtube' => '#edgtf_edgtf_video_embedded_container',
					'vimeo' => '#edgtf_edgtf_video_embedded_container',
					'self' => '#edgtf_edgtf_video_self_hosted_container')
			)
			)
		);

		$edgtf_video_embedded_container = blaze_edge_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name' => 'edgtf_video_embedded_container',
				'hidden_property' => 'edgtf_video_type_meta',
				'hidden_value' => 'self'
			)
		);

		$edgtf_video_self_hosted_container = blaze_edge_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name' => 'edgtf_video_self_hosted_container',
				'hidden_property' => 'edgtf_video_type_meta',
				'hidden_values' => array('youtube', 'vimeo')
			)
		);



		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_video_id_meta',
				'type'        => 'text',
				'label'       => esc_html__('Video ID', 'blaze'),
				'description' => esc_html__('Enter Video ID', 'blaze'),
				'parent'      => $edgtf_video_embedded_container,

			)
		);


		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__('Video Image', 'blaze'),
				'description' => esc_html__('Upload video image', 'blaze'),
				'parent'      => $edgtf_video_self_hosted_container,

			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_video_webm_link_meta',
				'type'        => 'text',
				'label'       => esc_html__('Video WEBM', 'blaze'),
				'description' => esc_html__('Enter video URL for WEBM format', 'blaze'),
				'parent'      => $edgtf_video_self_hosted_container,

			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_video_mp4_link_meta',
				'type'        => 'text',
				'label'       => esc_html__('Video MP4', 'blaze'),
				'description' => esc_html__('Enter video URL for MP4 format', 'blaze'),
				'parent'      => $edgtf_video_self_hosted_container,

			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_video_ogv_link_meta',
				'type'        => 'text',
				'label'       => esc_html__('Video OGV', 'blaze'),
				'description' => esc_html__('Enter video URL for OGV format', 'blaze'),
				'parent'      => $edgtf_video_self_hosted_container,

			)
		);
	}

    add_action('blaze_edge_meta_boxes_map', 'blaze_edge_map_post_format_video_meta_fields');
}