<?php
if(!function_exists('blaze_edge_map_portfolio_meta_fields')) {

    function blaze_edge_map_portfolio_meta_fields() {
    	global $blaze_edge_Framework;

		$edgt_pages = array();
		$pages = get_pages(); 
		foreach($pages as $page) {
			$edgt_pages[$page->ID] = $page->post_title;
		}

		//Portfolio Images

		$edgtPortfolioImages = new BlazeEdgeMetaBox("portfolio-item", esc_html__("Portfolio Images (multiple upload)", 'blaze'), '', '', 'portfolio_images');
		$blaze_edge_Framework->edgtMetaBoxes->addMetaBox("portfolio_images",$edgtPortfolioImages);

			$edgt_portfolio_image_gallery = new BlazeEdgeMultipleImages("edgt_portfolio-image-gallery",esc_html__("Portfolio Images", 'blaze'),esc_html__("Choose your portfolio images", 'blaze'));
			$edgtPortfolioImages->addChild("edgt_portfolio-image-gallery",$edgt_portfolio_image_gallery);

		//Portfolio Images/Videos 2

		$edgtPortfolioImagesVideos2 = new BlazeEdgeMetaBox("portfolio-item", esc_html__("Portfolio Images/Videos (single upload)", 'blaze'));
		$blaze_edge_Framework->edgtMetaBoxes->addMetaBox("portfolio_images_videos2",$edgtPortfolioImagesVideos2);

			$edgt_portfolio_images_videos2 = new BlazeEdgeImagesVideosFramework(esc_html__("Portfolio Images/Videos 2", 'blaze'),esc_html__("ThisIsDescription", 'blaze'));
			$edgtPortfolioImagesVideos2->addChild("edgt_portfolio_images_videos2",$edgt_portfolio_images_videos2);

		//Portfolio Additional Sidebar Items

		$edgtAdditionalSidebarItems = blaze_edge_create_meta_box(
		    array(
		        'scope' => array('portfolio-item'),
		        'title' => esc_html__('Additional Portfolio Sidebar Items', 'blaze'),
		        'name' => 'portfolio_properties'
		    )
		);

			$edgt_portfolio_properties = blaze_edge_add_options_framework(
			    array(
			        'label' => esc_html__('Portfolio Properties', 'blaze'),
			        'name' => 'edgt_portfolio_properties',
			        'parent' => $edgtAdditionalSidebarItems
			    )
			);
		}

    add_action('blaze_edge_meta_boxes_map', 'blaze_edge_map_portfolio_meta_fields');
}