<?php

if(!function_exists('blaze_edge_map_portfolio_settings')) {
    function blaze_edge_map_portfolio_settings() {
        $meta_box = blaze_edge_create_meta_box(array(
            'scope' => 'portfolio-item',
            'title' => esc_html__('Portfolio Settings', 'blaze'),
            'name'  => 'portfolio_settings_meta_box'
        ));

        blaze_edge_create_meta_box_field(array(
            'name'        => 'edgtf_portfolio_single_template_meta',
            'type'        => 'select',
            'label'       => esc_html__('Portfolio Type', 'blaze'),
            'description' => esc_html__('Choose a default type for Single Project pages', 'blaze'),
            'parent'      => $meta_box,
            'options'     => array(
                ''                   => esc_html__('Default', 'blaze'),
                'small-images'       => esc_html__('Portfolio small images left', 'blaze'),
                'small-images-right' => esc_html__('Portfolio small images right', 'blaze'),
                'small-slider'       => esc_html__('Portfolio small slider left', 'blaze'),
                'small-slider-right' => esc_html__('Portfolio small slider right', 'blaze'),
                'big-images'         => esc_html__('Portfolio big images', 'blaze'),
                'wide-images'        => esc_html__('Portfolio wide images left', 'blaze'),
                'wide-images-right'  => esc_html__('Portfolio wide images right', 'blaze'),
                'big-slider'         => esc_html__('Portfolio big slider', 'blaze'),
                'wide-slider'        => esc_html__('Portfolio wide slider', 'blaze'),
                'gallery'            => esc_html__('Portfolio gallery', 'blaze'),
                'small-masonry'      => esc_html__('Portfolio small masonry', 'blaze'),
                'big-masonry'        => esc_html__('Portfolio big masonry', 'blaze'),
                'split-screen'       => esc_html__('Portfolio split screen', 'blaze'),
                'full-screen-slider' => esc_html__('Portfolio full screen slider', 'blaze'),
                'custom'             => esc_html__('Portfolio custom', 'blaze'),
                'full-width-custom'  => esc_html__('Portfolio full width custom', 'blaze'),
            )
        ));

        $all_pages = array();
        $pages     = get_pages();
        foreach($pages as $page) {
            $all_pages[$page->ID] = $page->post_title;
        }

        blaze_edge_create_meta_box_field(array(
            'name'        => 'portfolio_single_back_to_link',
            'type'        => 'select',
            'label'       => esc_html__('"Back To" Link', 'blaze'),
            'description' => esc_html__('Choose "Back To" page to link from portfolio Single Project page', 'blaze'),
            'parent'      => $meta_box,
            'options'     => $all_pages
        ));

        blaze_edge_create_meta_box_field(array(
            'name'        => 'portfolio_external_link',
            'type'        => 'text',
            'label'       => esc_html__('Portfolio External Link', 'blaze'),
            'description' => esc_html__('Enter URL to link from Portfolio List page', 'blaze'),
            'parent'      => $meta_box,
            'args'        => array(
                'col_width' => 3
            )
        ));

        blaze_edge_create_meta_box_field(array(
            'name'        => 'portfolio_masonry_dimenisions',
            'type'        => 'select',
            'label'       => esc_html__('Dimensions for Masonry', 'blaze'),
            'description' => esc_html__('Choose image layout when it appears in Masonry type portfolio lists', 'blaze'),
            'parent'      => $meta_box,
            'options'     => array(
                'default'            => esc_html__('Default', 'blaze'),
                'large_width'        => esc_html__('Large width', 'blaze'),
                'large_height'       => esc_html__('Large height', 'blaze'),
                'large_width_height' => esc_html__('Large width/height', 'blaze')
            )
        ));
    }

    add_action('blaze_edge_meta_boxes_map', 'blaze_edge_map_portfolio_settings');
}