<?php
if(!function_exists('blaze_edge_map_general_meta_fields')) {

    function blaze_edge_map_general_meta_fields() {

		$general_meta_box = blaze_edge_create_meta_box(
		    array(
		        'scope' => array('page', 'portfolio-item', 'post'),
		        'title' => esc_html__('General', 'blaze'),
		        'name' => 'general_meta'
		    )
		);

		    blaze_edge_create_meta_box_field(
		        array(
		            'name' => 'edgtf_page_background_color_meta',
		            'type' => 'color',
		            'default_value' => '',
		            'label' => esc_html__('Page Background Color', 'blaze'),
		            'description' => esc_html__('Choose background color for page content', 'blaze'),
		            'parent' => $general_meta_box
		        )
		    );
			
			blaze_edge_create_meta_box_field(
				array(
					'name' => 'edgtf_page_padding_meta',
					'type' => 'text',
					'default_value' => '',
					'label' => esc_html__('Page Padding', 'blaze'),
					'description' => esc_html__('Insert padding in format 10px 10px 10px 10px', 'blaze'),
					'parent' => $general_meta_box
				)
			);

		    blaze_edge_create_meta_box_field(
		        array(
		            'name' => 'edgtf_page_slider_meta',
		            'type' => 'text',
		            'default_value' => '',
		            'label' => esc_html__('Slider Shortcode', 'blaze'),
		            'description' => esc_html__('Paste your slider shortcode here', 'blaze'),
		            'parent' => $general_meta_box
		        )
		    );

			$passepartout_option      = blaze_edge_options()->getOptionValue('passepartout');
			$passepartout_default_dependency = array(
				'' => '#edgtf_passepartout_container'
			);

			$passepartout_show_array = array(
				'yes' => '#edgtf_passepartout_container'
			);

			$passepartout_hide_array = array(
				'no' => '#edgtf_passepartout_container'
			);

			if($passepartout_option === 'yes') {
				$passepartout_show_array = array_merge($passepartout_show_array, $passepartout_default_dependency);
				$temp_passepartout_no = array(
					'hidden_value' => 'no'
				);
			} else {
				$passepartout_hide_array = array_merge($passepartout_hide_array, $passepartout_default_dependency);
				$temp_passepartout_no = array(
					'hidden_values'   => array('','no')
				);
			}

			blaze_edge_create_meta_box_field(
				array(
					'name'          => 'edgtf_passepartout_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__('Passepartout', 'blaze'),
					'description'   => esc_html__('Enabling this option will display passepartout around site content', 'blaze'),
					'parent'        => $general_meta_box,
					'options'     => array(
						''		=> esc_html__('Default', 'blaze'),
						'yes'	=> esc_html__('Yes', 'blaze'),
						'no'	=> esc_html__('No', 'blaze')
					),
					'args' => array(
						"dependence" => true,
						'show'       => $passepartout_show_array,
						'hide'       => $passepartout_hide_array
					)
				)
			);

			$passepartout_container = blaze_edge_add_admin_container(
				array_merge(
					array(
						'parent'            => $general_meta_box,
						'name'              => 'passepartout_container',
						'hidden_property'   => 'edgtf_passepartout_meta'
					),
					$temp_passepartout_no
				)
			);
			blaze_edge_create_meta_box_field(
				array(
					'name'          => 'edgtf_passepartout_color_meta',
					'type'          => 'color',
					'label'         => esc_html__('Passepartout Color', 'blaze'),
					'description'   => esc_html__('Choose Passepartout color.', 'blaze'),
					'parent'        => $passepartout_container
				)
			);
			$boxed_option      = blaze_edge_options()->getOptionValue('boxed');
			$boxed_default_dependency = array(
				'' => '#edgtf_boxed_container'
			);

			$boxed_show_array = array(
				'yes' => '#edgtf_boxed_container'
			);

			$boxed_hide_array = array(
				'no' => '#edgtf_boxed_container'
			);

			if($boxed_option === 'yes') {
				$boxed_show_array = array_merge($boxed_show_array, $boxed_default_dependency);
				$temp_boxed_no = array(
					'hidden_value' => 'no'
				);
			} else {
				$boxed_hide_array = array_merge($boxed_hide_array, $boxed_default_dependency);
				$temp_boxed_no = array(
					'hidden_values'   => array('','no')
				);
			}

			blaze_edge_create_meta_box_field(
				array(
					'name'          => 'edgtf_boxed_meta',
					'type'          => 'select',
					'label'         => esc_html__('Boxed Layout', 'blaze'),
					'description'   => '',
					'parent'        => $general_meta_box,
					'default_value' => '',
					'options'     => array(
						''		=> esc_html__('Default', 'blaze'),
						'yes'	=> esc_html__('Yes', 'blaze'),
						'no'	=> esc_html__('No', 'blaze')
					),
					'args' => array(
						"dependence" => true,
						'show'       => $boxed_show_array,
						'hide'       => $boxed_hide_array
					)
				)
			);

			$boxed_container = blaze_edge_add_admin_container_no_style(
				array_merge(
					array(
						'parent'            => $general_meta_box,
						'name'              => 'boxed_container',
						'hidden_property'   => 'edgtf_boxed_meta'
					),
					$temp_boxed_no
				)
			);

			blaze_edge_create_meta_box_field(
				array(
					'name'          => 'edgtf_page_background_color_in_box_meta',
					'type'          => 'color',
					'label'         => esc_html__('Page Background Color', 'blaze'),
					'description'   => esc_html__('Choose the page background color outside box.', 'blaze'),
					'parent'        => $boxed_container
				)
			);

			blaze_edge_create_meta_box_field(
				array(
					'name'          => 'edgtf_boxed_background_image_meta',
					'type'          => 'image',
					'label'         => esc_html__('Background Image', 'blaze'),
					'description'   => esc_html__('Choose an image to be displayed in background', 'blaze'),
					'parent'        => $boxed_container
				)
			);

			blaze_edge_create_meta_box_field(
				array(
					'name'          => 'edgtf_boxed_background_image_repeating_meta',
					'type'          => 'select',
					'default_value' => 'no',
					'label'         => esc_html__('Use Background Image as Pattern', 'blaze'),
					'description'   => esc_html__('Set this option to "yes" to use the background image as repeating pattern', 'blaze'),
					'parent'        => $boxed_container,
					'options'       => array(
						'no'	=>	esc_html__('No', 'blaze'),
						'yes'	=>	esc_html__('Yes', 'blaze')

					)
				)
			);

			blaze_edge_create_meta_box_field(
				array(
					'name'          => 'edgtf_boxed_background_image_attachment_meta',
					'type'          => 'select',
					'default_value' => 'fixed',
					'label'         => esc_html__('Background Image Behaviour', 'blaze'),
					'description'   => esc_html__('Choose background image behaviour', 'blaze'),
					'parent'        => $boxed_container,
					'options'       => array(
						'fixed'     => esc_html__('Fixed', 'blaze'),
						'scroll'    => esc_html__('Scroll', 'blaze')
					)
				)
			);
		}

    add_action('blaze_edge_meta_boxes_map', 'blaze_edge_map_general_meta_fields');
}