<?php
if ( post_password_required() ) {
	return;
}

if ( comments_open() || get_comments_number()) : ?>
	<div class="edgtf-comment-holder clearfix" id="comments">
		<div class="edgtf-comment-number">
			<div class="edgtf-comment-number-inner">
				<h4><?php comments_number( esc_html__('No Comments','blaze'), ' 1'.esc_html__(' Comment','blaze'), ' %'.esc_html__(' Comments ','blaze')); ?></h4>
			</div>
		</div>
		<div class="edgtf-comments">

			<?php if ( have_comments() ) : ?>
				<ul class="edgtf-comment-list">
					<?php wp_list_comments(array( 'callback' => 'blaze_edge_comment')); ?>
				</ul>
			<?php endif; ?>

			<?php if( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' )) : ?>
				<p><?php esc_html_e('Sorry, the comment form is closed at this time.', 'blaze'); ?></p>
			<?php endif; ?>

		</div>
	</div>
	<?php
		$commenter = wp_get_current_commenter();
		$req = get_option( 'require_name_email' );
		$aria_req = ( $req ? " aria-required='true'" : '' );
	    $consent  = empty( $commenter['comment_author_email'] ) ? '' : ' checked="checked"';

		$args = array(
			'id_form' => 'commentform',
			'id_submit' => 'submit_comment',
			'title_reply'=> esc_html__( 'Leave a comment','blaze' ),
			'title_reply_to' => esc_html__( 'Post a Reply to %s','blaze' ),
			'cancel_reply_link' => esc_html__( 'Cancel Reply','blaze' ),
			'label_submit' => esc_html__( 'Submit','blaze' ),
			'comment_field' => '<textarea id="comment" placeholder="'.esc_attr__( 'Write your comment...','blaze' ).'" name="comment" cols="45" rows="8" aria-required="true"></textarea>',
			'comment_notes_before' => '',
			'comment_notes_after' => '',
			'fields' => apply_filters( 'comment_form_default_fields', array(
				'author' => '<div class="clearfix"><div class="edgtf-column"><input id="author" name="author" placeholder="'. esc_attr__( 'Full Name*','blaze' ) .'" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '"' . $aria_req . ' /></div>',
				'email' => '<div class="edgtf-column"><input id="email" name="email" placeholder="'. esc_attr__( 'Email Address*','blaze' ) .'" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '"' . $aria_req . ' /></div>',
				'url' => '<div class="edgtf-column"><input id="url" name="url" placeholder="'. esc_attr__( 'Website','blaze' ) .'" type="text" value="' . esc_attr(  $commenter['comment_author_url'] ) . '"' . $aria_req . ' /></div></div>',
				'cookies' => '<p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes" ' . $consent . ' />' .
					'<label for="wp-comment-cookies-consent">' . esc_html__( 'Save my name, email, and website in this browser for the next time I comment.', 'blaze' ) . '</label></p>'
			) )
			);

		if(is_user_logged_in()){
			$args['class_form'] = 'edgtf-comment-registered-user';
			$args['title_reply_before'] = '<h3 id="reply-title" class="comment-reply-title edgtf-comment-reply-title-registered">';
		}
	?>
	<?php if(get_comment_pages_count() > 1) : ?>
		<div class="edgtf-comment-pager">
			<p><?php paginate_comments_links(); ?></p>
		</div>
	<?php endif; ?>
	<div class="edgtf-comment-form">
		<?php comment_form($args); ?>
	</div>
<?php endif; ?>
							


