<?php
if(!function_exists('blaze_edge_design_styles')) {
    /**
     * Generates general custom styles
     */
    function blaze_edge_design_styles() {

        $preload_background_styles = array();

        if(blaze_edge_options()->getOptionValue('preload_pattern_image') !== ""){
            $preload_background_styles['background-image'] = 'url('.blaze_edge_options()->getOptionValue('preload_pattern_image').') !important';
        }else{
            $preload_background_styles['background-image'] = 'url('.esc_url(EDGE_ASSETS_ROOT."/img/preload_pattern.png").') !important';
        }

        echo blaze_edge_dynamic_css('.edgtf-preload-background', $preload_background_styles);

		if (blaze_edge_options()->getOptionValue('google_fonts')){
			$font_family = blaze_edge_options()->getOptionValue('google_fonts');
			if(blaze_edge_is_font_option_valid($font_family)) {
				echo blaze_edge_dynamic_css('body', array('font-family' => blaze_edge_get_font_option_val($font_family)));
			}
		}

        if(blaze_edge_options()->getOptionValue('first_color') !== "") {
            $color_selector = array(
            	'a',
				'h1 a:hover',
				'h2 a:hover',
				'h3 a:hover',
				'h4 a:hover',
				'h5 a:hover',
				'h6 a:hover',
				'p a',
				'.edgtf-comment-holder .edgtf-comment-text .comment-edit-link',
				'.edgtf-comment-holder .edgtf-comment-text .comment-reply-link',
				'.edgtf-comment-holder .edgtf-comment-text .replay',
				'#commentform .edgtf-btn',
				'#submit_comment',
				'.post-password-form input[type=submit]',
				'input.wpcf7-form-control.wpcf7-submit',
				'.edgtf-pagination-holder .edgtf-pagination li a:hover',
				'.edgtf-pagination-holder .edgtf-pagination li.active span',
				'body:not(.edgtf-menu-item-first-level-bg-color) .edgtf-main-menu>ul>li:hover>a',
				'.edgtf-header-vertical .edgtf-vertical-menu ul li a:hover',
				'.edgtf-mobile-header .edgtf-mobile-nav a:hover',
				'.edgtf-mobile-header .edgtf-mobile-nav h4:hover',
				'.edgtf-mobile-header .edgtf-mobile-menu-opener a:hover',
				'.edgtf-page-header .edgtf-sticky-header .edgtf-shopping-cart-outer .edgtf-shopping-cart-header .edgtf-cart-amount',
				'.edgtf-ordered-list ol>li:before',
				'.edgtf-unordered-list ul>li:before',
				'.edgtf-tabs .edgtf-tabs-nav li.ui-state-active a',
				'.edgtf-tabs .edgtf-tabs-nav li.ui-state-hover a',
				'.edgtf-accordion-holder .edgtf-title-holder',
				'.edgtf-blog-list-holder .edgtf-item-info-section .edgtf-info-btm-left>div a',
				'.edgtf-blog-list-holder .edgtf-item-info-section div.edgtf-post-info-author>a',
				'.edgtf-blog-list-holder .edgtf-item-info-section div.edgtf-post-info-category>a',
				'.edgtf-blog-slider .edgtf-item-info-section .edgtf-info-btm-left>div a',
				'.edgtf-blog-slider .edgtf-item-info-section div.edgtf-post-info-author>a',
				'.edgtf-blog-slider .edgtf-item-info-section div.edgtf-post-info-category>a',
				'.edgtf-dropcaps',
				'.edgtf-portfolio-list-holder article .edgtf-ptf-category-holder',
				'.edgtf-portfolio-list-holder-outer.edgtf-ptf-hover-trim article .edgtf-ptf-category-holder',
				'#edgtf-interactive-text .edgtf-interactive-text-inner .edgtf-interactive-text-content-holder .edgtf-interactive-text-content-line .edgtf-interactive-text-item-content .edgtf-interactive-text-item-wrap .edgtf-iti-title',
				'.widget ul li a',
				'.widget a',
				'.widget.widget_recent_entries ul a',
				'.widget .tagcloud a:hover',
				'.widget.widget_calendar #next a',
				'.widget.widget_calendar #prev a',
				'.edgtf-sidebar .widget.widget_archive li:hover',
				'.wpb_widgetised_column .widget.widget_archive li:hover',
				'.woocommerce-pagination .page-numbers.current',
				'.woocommerce-pagination .page-numbers:hover',
				'.edgtf-single-product-wrapper-top .out-of-stock',
				'.summary .group_table td.label a',
				'.edgtf-woocommerce-page .edgtf-quantity-buttons .edgtf-quantity-minus:hover',
				'.edgtf-woocommerce-page .edgtf-quantity-buttons .edgtf-quantity-plus:hover',
				'.woocommerce-account .woocommerce-MyAccount-navigation .woocommerce-MyAccount-navigation-link.is-active a',
				'.woocommerce-account .woocommerce-MyAccount-navigation .woocommerce-MyAccount-navigation-link:hover a',
				'.edgtf-shopping-cart-dropdown ul li a:hover',
				'.edgtf-shopping-cart-dropdown .edgtf-item-info-holder .edgtf-item-left:hover',
				'.widget_price_filter .price_slider_amount .button',
            );

            $color_important_selector = array(
				'.edgtf-call-to-action .edgtf-call-to-action-cell>.edgtf-btn.edgtf-btn-outline:hover',
				'.edgtf-btn.edgtf-btn-outline-white:not(.edgtf-btn-custom-hover-color):hover',
            );

            $background_color_selector = array(
				'.edgtf-st-loader .pulse',
				'.edgtf-st-loader .double_pulse .double-bounce1',
				'.edgtf-st-loader .double_pulse .double-bounce2',
				'.edgtf-st-loader .cube',
				'.edgtf-st-loader .rotating_cubes .cube1',
				'.edgtf-st-loader .rotating_cubes .cube2',
				'.edgtf-st-loader .stripes>div',
				'.edgtf-st-loader .wave>div',
				'.edgtf-st-loader .two_rotating_circles .dot1',
				'.edgtf-st-loader .two_rotating_circles .dot2',
				'.edgtf-st-loader .five_rotating_circles .container1>div',
				'.edgtf-st-loader .five_rotating_circles .container2>div',
				'.edgtf-st-loader .five_rotating_circles .container3>div',
				'.edgtf-st-loader .atom .ball-1:before',
				'.edgtf-st-loader .atom .ball-2:before',
				'.edgtf-st-loader .atom .ball-3:before',
				'.edgtf-st-loader .atom .ball-4:before',
				'.edgtf-st-loader .clock .ball:before',
				'.edgtf-st-loader .mitosis .ball',
				'.edgtf-st-loader .lines .line1',
				'.edgtf-st-loader .lines .line2',
				'.edgtf-st-loader .lines .line3',
				'.edgtf-st-loader .lines .line4',
				'.edgtf-st-loader .fussion .ball',
				'.edgtf-st-loader .fussion .ball-1',
				'.edgtf-st-loader .fussion .ball-2',
				'.edgtf-st-loader .fussion .ball-3',
				'.edgtf-st-loader .fussion .ball-4',
				'.edgtf-st-loader .wave_circles .ball',
				'.edgtf-st-loader .pulse_circles .ball',
				'#commentform .edgtf-btn:hover',
				'#submit_comment:hover',
				'.post-password-form input[type=submit]:hover',
				'input.wpcf7-form-control.wpcf7-submit:hover',
				'.flex-control-paging.flex-control-nav li a .flex-active',
				'.flex-control-paging.flex-control-nav li a:hover',
				'.edgtf-main-menu>ul>li>a:hover span.edgtf-item-inner .edgtf-item-text:after',
				'.edgtf-main-menu>ul>li.edgtf-active-item>a span.edgtf-item-inner .edgtf-item-text:after',
				'.edgtf-header-vertical .edgtf-vertical-menu>ul>li.edgtf-active-item>a .edgtf-item-text:after',
				'.edgtf-header-vertical .edgtf-vertical-menu>ul>li>a:hover .edgtf-item-text:after',
				'.edgtf-header-vertical .edgtf-vertical-menu>ul>li>a:before',
				'.edgtf-header-vertical .edgtf-vertical-menu>ul>li>a:after',
				'.edgtf-progress-bar .edgtf-progress-content-outer .edgtf-progress-content',
				'.edgtf-pie-chart-doughnut-holder .edgtf-pie-legend ul li .edgtf-pie-color-holder',
				'.edgtf-pie-chart-pie-holder .edgtf-pie-legend ul li .edgtf-pie-color-holder',
				'.edgtf-tabs .edgtf-tabs-nav li.ui-state-active:after',
				'.edgtf-tabs .edgtf-tabs-nav li.ui-state-hover:after',
				'.edgtf-accordion-holder .edgtf-title-holder.ui-state-active',
				'.edgtf-accordion-holder .edgtf-title-holder.ui-state-hover',
				'.edgtf-btn.edgtf-btn-solid',
				'.edgtf-dropcaps.edgtf-circle',
				'.edgtf-dropcaps.edgtf-square',
				'.edgtf-portfolio-filter-holder .edgtf-portfolio-filter-holder-inner ul li span:hover:after',
				'.edgtf-portfolio-filter-holder .edgtf-portfolio-filter-holder-inner ul li.current span:after',
				'.edgtf-shop-gallery .edgtf-product-badge',
				'.edgtf-woocommerce-page .product .edgtf-product-badge',
				'.woocommerce .product .edgtf-product-badge',
				'.edgtf-woocommerce-page .added_to_cart',
				'.woocommerce .added_to_cart',
				'.woocommerce-account input[type=submit]',
				'.woocommerce-checkout input[type=submit]',
				'.edgtf-shopping-cart-outer .edgtf-cart-amount',
				'.woocommerce.widget button',
				'.woocommerce.widget input[type=submit]',
				'.widget_price_filter .ui-slider-horizontal .ui-slider-range',
				'.widget_price_filter .ui-slider .ui-slider-handle',
			);

            $background_color_important_selector = array(
				'.edgtf-btn.edgtf-btn-outline:not(.edgtf-btn-custom-hover-bg):hover',
            );

            $border_color_selector = array(
				'.edgtf-st-loader .pulse_circles .ball',
				'#commentform .edgtf-btn',
				'#submit_comment',
				'.post-password-form input[type=submit]',
				'input.wpcf7-form-control.wpcf7-submit',
				'.edgtf-page-not-found .edgtf-search-wrapper input[type=text]',
				'.edgtf-tabs.edgtf-tab-boxed .edgtf-tabs-nav li a',
				'.edgtf-accordion-holder .edgtf-title-holder',
				'.edgtf-btn.edgtf-btn-solid',
				'.edgtf-btn.edgtf-btn-outline',
				'.widget .edgtf-search-wrapper input[type=text]',
				'.widget .tagcloud a:hover',
				'.edgtf-comment-holder',
				'.edgtf-tabs.edgtf-tab-boxed.edgtf-horizontal-tab .edgtf-tab-container',
				'.edgtf-tabs.edgtf-tab-boxed.edgtf-vertical-tab .edgtf-tabs-nav li a',
				'.edgtf-tabs.edgtf-tab-boxed.edgtf-vertical-tab .edgtf-tab-container',
				'.edgtf-woocommerce-page .added_to_cart',
				'.woocommerce .added_to_cart',
				'.woocommerce.widget button',
				'.woocommerce.widget input[type=submit]',
				'.widget_price_filter .price_slider_amount .button:hover',
			);

			$border_color_important_selector = array(
				'.edgtf-btn.edgtf-btn-outline:not(.edgtf-btn-custom-border-hover):hover',
			);

			$border_bottom_color_selector = array(
			);

            echo blaze_edge_dynamic_css($color_selector, array('color' => blaze_edge_options()->getOptionValue('first_color')));
            echo blaze_edge_dynamic_css($color_important_selector, array('color' => blaze_edge_options()->getOptionValue('first_color').'!important'));
            echo blaze_edge_dynamic_css('::selection', array('background' => blaze_edge_options()->getOptionValue('first_color')));
            echo blaze_edge_dynamic_css('::-moz-selection', array('background' => blaze_edge_options()->getOptionValue('first_color')));
            echo blaze_edge_dynamic_css($background_color_selector, array('background-color' => blaze_edge_options()->getOptionValue('first_color')));
            echo blaze_edge_dynamic_css($background_color_important_selector, array('background-color' => blaze_edge_options()->getOptionValue('first_color').'!important'));
            echo blaze_edge_dynamic_css($border_color_selector, array('border-color' => blaze_edge_options()->getOptionValue('first_color')));
            echo blaze_edge_dynamic_css($border_color_important_selector, array('border-color' => blaze_edge_options()->getOptionValue('first_color').'!important'));
            echo blaze_edge_dynamic_css($border_bottom_color_selector, array('border-bottom-color' => blaze_edge_options()->getOptionValue('first_color')));
        }

		if (blaze_edge_options()->getOptionValue('page_background_color')) {
			$background_color_selector = array(
				'.edgtf-wrapper-inner',
				'.edgtf-full-width',
				'.edgtf-content',
				'.edgtf-content-inner > .edgtf-container'
			);
			echo blaze_edge_dynamic_css($background_color_selector, array('background-color' => blaze_edge_options()->getOptionValue('page_background_color')));
		}

		if (blaze_edge_options()->getOptionValue('selection_color')) {
			echo blaze_edge_dynamic_css('::selection', array('background' => blaze_edge_options()->getOptionValue('selection_color')));
			echo blaze_edge_dynamic_css('::-moz-selection', array('background' => blaze_edge_options()->getOptionValue('selection_color')));
		}

		$boxed_background_style = array();
		if (blaze_edge_options()->getOptionValue('page_background_color_in_box')) {
			$boxed_background_style['background-color'] = blaze_edge_options()->getOptionValue('page_background_color_in_box');
		}

		if (blaze_edge_options()->getOptionValue('boxed_background_image')) {
			$boxed_background_style['background-image'] = 'url('.esc_url(blaze_edge_options()->getOptionValue('boxed_background_image')).')';
			if(blaze_edge_options()->getOptionValue('boxed_background_image_repeating') == 'yes') {
				$boxed_background_style['background-position'] = '0px 0px';
				$boxed_background_style['background-repeat'] = 'repeat';
			} else {
				$boxed_background_style['background-position'] = 'center 0px';
				$boxed_background_style['background-repeat'] = 'repeat';
			}
		}


		if (blaze_edge_options()->getOptionValue('boxed_background_image_attachment')) {
			$boxed_background_style['background-attachment'] = (blaze_edge_options()->getOptionValue('boxed_background_image_attachment'));
		}

		echo blaze_edge_dynamic_css('.edgtf-boxed .edgtf-wrapper', $boxed_background_style);
    }

    add_action('blaze_edge_style_dynamic', 'blaze_edge_design_styles');
}

if (!function_exists('blaze_edge_h1_styles')) {

    function blaze_edge_h1_styles() {

        $h1_styles = array();

        if(blaze_edge_options()->getOptionValue('h1_color') !== '') {
            $h1_styles['color'] = blaze_edge_options()->getOptionValue('h1_color');
        }
        if(blaze_edge_options()->getOptionValue('h1_google_fonts') !== '-1') {
            $h1_styles['font-family'] = blaze_edge_get_formatted_font_family(blaze_edge_options()->getOptionValue('h1_google_fonts'));
        }
        if(blaze_edge_options()->getOptionValue('h1_fontsize') !== '') {
            $h1_styles['font-size'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h1_fontsize')).'px';
        }
        if(blaze_edge_options()->getOptionValue('h1_lineheight') !== '') {
            $h1_styles['line-height'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h1_lineheight')).'px';
        }
        if(blaze_edge_options()->getOptionValue('h1_texttransform') !== '') {
            $h1_styles['text-transform'] = blaze_edge_options()->getOptionValue('h1_texttransform');
        }
        if(blaze_edge_options()->getOptionValue('h1_fontstyle') !== '') {
            $h1_styles['font-style'] = blaze_edge_options()->getOptionValue('h1_fontstyle');
        }
        if(blaze_edge_options()->getOptionValue('h1_fontweight') !== '') {
            $h1_styles['font-weight'] = blaze_edge_options()->getOptionValue('h1_fontweight');
        }
        if(blaze_edge_options()->getOptionValue('h1_letterspacing') !== '') {
            $h1_styles['letter-spacing'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h1_letterspacing')).'px';
        }

        $h1_selector = array(
            'h1'
        );

        if (!empty($h1_styles)) {
            echo blaze_edge_dynamic_css($h1_selector, $h1_styles);
        }
    }

    add_action('blaze_edge_style_dynamic', 'blaze_edge_h1_styles');
}

if (!function_exists('blaze_edge_h2_styles')) {

    function blaze_edge_h2_styles() {

        $h2_styles = array();

        if(blaze_edge_options()->getOptionValue('h2_color') !== '') {
            $h2_styles['color'] = blaze_edge_options()->getOptionValue('h2_color');
        }
        if(blaze_edge_options()->getOptionValue('h2_google_fonts') !== '-1') {
            $h2_styles['font-family'] = blaze_edge_get_formatted_font_family(blaze_edge_options()->getOptionValue('h2_google_fonts'));
        }
        if(blaze_edge_options()->getOptionValue('h2_fontsize') !== '') {
            $h2_styles['font-size'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h2_fontsize')).'px';
        }
        if(blaze_edge_options()->getOptionValue('h2_lineheight') !== '') {
            $h2_styles['line-height'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h2_lineheight')).'px';
        }
        if(blaze_edge_options()->getOptionValue('h2_texttransform') !== '') {
            $h2_styles['text-transform'] = blaze_edge_options()->getOptionValue('h2_texttransform');
        }
        if(blaze_edge_options()->getOptionValue('h2_fontstyle') !== '') {
            $h2_styles['font-style'] = blaze_edge_options()->getOptionValue('h2_fontstyle');
        }
        if(blaze_edge_options()->getOptionValue('h2_fontweight') !== '') {
            $h2_styles['font-weight'] = blaze_edge_options()->getOptionValue('h2_fontweight');
        }
        if(blaze_edge_options()->getOptionValue('h2_letterspacing') !== '') {
            $h2_styles['letter-spacing'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h2_letterspacing')).'px';
        }

        $h2_selector = array(
            'h2'
        );

        if (!empty($h2_styles)) {
            echo blaze_edge_dynamic_css($h2_selector, $h2_styles);
        }
    }

    add_action('blaze_edge_style_dynamic', 'blaze_edge_h2_styles');
}

if (!function_exists('blaze_edge_h3_styles')) {

    function blaze_edge_h3_styles() {

        $h3_styles = array();

        if(blaze_edge_options()->getOptionValue('h3_color') !== '') {
            $h3_styles['color'] = blaze_edge_options()->getOptionValue('h3_color');
        }
        if(blaze_edge_options()->getOptionValue('h3_google_fonts') !== '-1') {
            $h3_styles['font-family'] = blaze_edge_get_formatted_font_family(blaze_edge_options()->getOptionValue('h3_google_fonts'));
        }
        if(blaze_edge_options()->getOptionValue('h3_fontsize') !== '') {
            $h3_styles['font-size'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h3_fontsize')).'px';
        }
        if(blaze_edge_options()->getOptionValue('h3_lineheight') !== '') {
            $h3_styles['line-height'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h3_lineheight')).'px';
        }
        if(blaze_edge_options()->getOptionValue('h3_texttransform') !== '') {
            $h3_styles['text-transform'] = blaze_edge_options()->getOptionValue('h3_texttransform');
        }
        if(blaze_edge_options()->getOptionValue('h3_fontstyle') !== '') {
            $h3_styles['font-style'] = blaze_edge_options()->getOptionValue('h3_fontstyle');
        }
        if(blaze_edge_options()->getOptionValue('h3_fontweight') !== '') {
            $h3_styles['font-weight'] = blaze_edge_options()->getOptionValue('h3_fontweight');
        }
        if(blaze_edge_options()->getOptionValue('h3_letterspacing') !== '') {
            $h3_styles['letter-spacing'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h3_letterspacing')).'px';
        }

        $h3_selector = array(
            'h3'
        );

        if (!empty($h3_styles)) {
            echo blaze_edge_dynamic_css($h3_selector, $h3_styles);
        }
    }

    add_action('blaze_edge_style_dynamic', 'blaze_edge_h3_styles');
}

if (!function_exists('blaze_edge_h4_styles')) {

    function blaze_edge_h4_styles() {

        $h4_styles = array();

        if(blaze_edge_options()->getOptionValue('h4_color') !== '') {
            $h4_styles['color'] = blaze_edge_options()->getOptionValue('h4_color');
        }
        if(blaze_edge_options()->getOptionValue('h4_google_fonts') !== '-1') {
            $h4_styles['font-family'] = blaze_edge_get_formatted_font_family(blaze_edge_options()->getOptionValue('h4_google_fonts'));
        }
        if(blaze_edge_options()->getOptionValue('h4_fontsize') !== '') {
            $h4_styles['font-size'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h4_fontsize')).'px';
        }
        if(blaze_edge_options()->getOptionValue('h4_lineheight') !== '') {
            $h4_styles['line-height'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h4_lineheight')).'px';
        }
        if(blaze_edge_options()->getOptionValue('h4_texttransform') !== '') {
            $h4_styles['text-transform'] = blaze_edge_options()->getOptionValue('h4_texttransform');
        }
        if(blaze_edge_options()->getOptionValue('h4_fontstyle') !== '') {
            $h4_styles['font-style'] = blaze_edge_options()->getOptionValue('h4_fontstyle');
        }
        if(blaze_edge_options()->getOptionValue('h4_fontweight') !== '') {
            $h4_styles['font-weight'] = blaze_edge_options()->getOptionValue('h4_fontweight');
        }
        if(blaze_edge_options()->getOptionValue('h4_letterspacing') !== '') {
            $h4_styles['letter-spacing'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h4_letterspacing')).'px';
        }

        $h4_selector = array(
            'h4'
        );

        if (!empty($h4_styles)) {
            echo blaze_edge_dynamic_css($h4_selector, $h4_styles);
        }
    }

    add_action('blaze_edge_style_dynamic', 'blaze_edge_h4_styles');
}

if (!function_exists('blaze_edge_h5_styles')) {

    function blaze_edge_h5_styles() {

        $h5_styles = array();

        if(blaze_edge_options()->getOptionValue('h5_color') !== '') {
            $h5_styles['color'] = blaze_edge_options()->getOptionValue('h5_color');
        }
        if(blaze_edge_options()->getOptionValue('h5_google_fonts') !== '-1') {
            $h5_styles['font-family'] = blaze_edge_get_formatted_font_family(blaze_edge_options()->getOptionValue('h5_google_fonts'));
        }
        if(blaze_edge_options()->getOptionValue('h5_fontsize') !== '') {
            $h5_styles['font-size'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h5_fontsize')).'px';
        }
        if(blaze_edge_options()->getOptionValue('h5_lineheight') !== '') {
            $h5_styles['line-height'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h5_lineheight')).'px';
        }
        if(blaze_edge_options()->getOptionValue('h5_texttransform') !== '') {
            $h5_styles['text-transform'] = blaze_edge_options()->getOptionValue('h5_texttransform');
        }
        if(blaze_edge_options()->getOptionValue('h5_fontstyle') !== '') {
            $h5_styles['font-style'] = blaze_edge_options()->getOptionValue('h5_fontstyle');
        }
        if(blaze_edge_options()->getOptionValue('h5_fontweight') !== '') {
            $h5_styles['font-weight'] = blaze_edge_options()->getOptionValue('h5_fontweight');
        }
        if(blaze_edge_options()->getOptionValue('h5_letterspacing') !== '') {
            $h5_styles['letter-spacing'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h5_letterspacing')).'px';
        }

        $h5_selector = array(
            'h5'
        );

        if (!empty($h5_styles)) {
            echo blaze_edge_dynamic_css($h5_selector, $h5_styles);
        }
    }

    add_action('blaze_edge_style_dynamic', 'blaze_edge_h5_styles');
}

if (!function_exists('blaze_edge_h6_styles')) {

    function blaze_edge_h6_styles() {

        $h6_styles = array();

        if(blaze_edge_options()->getOptionValue('h6_color') !== '') {
            $h6_styles['color'] = blaze_edge_options()->getOptionValue('h6_color');
        }
        if(blaze_edge_options()->getOptionValue('h6_google_fonts') !== '-1') {
            $h6_styles['font-family'] = blaze_edge_get_formatted_font_family(blaze_edge_options()->getOptionValue('h6_google_fonts'));
        }
        if(blaze_edge_options()->getOptionValue('h6_fontsize') !== '') {
            $h6_styles['font-size'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h6_fontsize')).'px';
        }
        if(blaze_edge_options()->getOptionValue('h6_lineheight') !== '') {
            $h6_styles['line-height'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h6_lineheight')).'px';
        }
        if(blaze_edge_options()->getOptionValue('h6_texttransform') !== '') {
            $h6_styles['text-transform'] = blaze_edge_options()->getOptionValue('h6_texttransform');
        }
        if(blaze_edge_options()->getOptionValue('h6_fontstyle') !== '') {
            $h6_styles['font-style'] = blaze_edge_options()->getOptionValue('h6_fontstyle');
        }
        if(blaze_edge_options()->getOptionValue('h6_fontweight') !== '') {
            $h6_styles['font-weight'] = blaze_edge_options()->getOptionValue('h6_fontweight');
        }
        if(blaze_edge_options()->getOptionValue('h6_letterspacing') !== '') {
            $h6_styles['letter-spacing'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('h6_letterspacing')).'px';
        }

        $h6_selector = array(
            'h6'
        );

        if (!empty($h6_styles)) {
            echo blaze_edge_dynamic_css($h6_selector, $h6_styles);
        }
    }

    add_action('blaze_edge_style_dynamic', 'blaze_edge_h6_styles');
}

if (!function_exists('blaze_edge_text_styles')) {

    function blaze_edge_text_styles() {

        $text_styles = array();

        if(blaze_edge_options()->getOptionValue('text_color') !== '') {
            $text_styles['color'] = blaze_edge_options()->getOptionValue('text_color');
        }
        if(blaze_edge_options()->getOptionValue('text_google_fonts') !== '-1') {
            $text_styles['font-family'] = blaze_edge_get_formatted_font_family(blaze_edge_options()->getOptionValue('text_google_fonts'));
        }
        if(blaze_edge_options()->getOptionValue('text_fontsize') !== '') {
            $text_styles['font-size'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('text_fontsize')).'px';
        }
        if(blaze_edge_options()->getOptionValue('text_lineheight') !== '') {
            $text_styles['line-height'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('text_lineheight')).'px';
        }
        if(blaze_edge_options()->getOptionValue('text_texttransform') !== '') {
            $text_styles['text-transform'] = blaze_edge_options()->getOptionValue('text_texttransform');
        }
        if(blaze_edge_options()->getOptionValue('text_fontstyle') !== '') {
            $text_styles['font-style'] = blaze_edge_options()->getOptionValue('text_fontstyle');
        }
        if(blaze_edge_options()->getOptionValue('text_fontweight') !== '') {
            $text_styles['font-weight'] = blaze_edge_options()->getOptionValue('text_fontweight');
        }
        if(blaze_edge_options()->getOptionValue('text_letterspacing') !== '') {
            $text_styles['letter-spacing'] = blaze_edge_filter_px(blaze_edge_options()->getOptionValue('text_letterspacing')).'px';
        }

        $text_selector = array(
            'p'
        );

        if (!empty($text_styles)) {
            echo blaze_edge_dynamic_css($text_selector, $text_styles);
        }
    }

    add_action('blaze_edge_style_dynamic', 'blaze_edge_text_styles');
}

if (!function_exists('blaze_edge_link_styles')) {

    function blaze_edge_link_styles() {

        $link_styles = array();

        if(blaze_edge_options()->getOptionValue('link_color') !== '') {
            $link_styles['color'] = blaze_edge_options()->getOptionValue('link_color');
        }
        if(blaze_edge_options()->getOptionValue('link_fontstyle') !== '') {
            $link_styles['font-style'] = blaze_edge_options()->getOptionValue('link_fontstyle');
        }
        if(blaze_edge_options()->getOptionValue('link_fontweight') !== '') {
            $link_styles['font-weight'] = blaze_edge_options()->getOptionValue('link_fontweight');
        }
        if(blaze_edge_options()->getOptionValue('link_fontdecoration') !== '') {
            $link_styles['text-decoration'] = blaze_edge_options()->getOptionValue('link_fontdecoration');
        }

        $link_selector = array(
            'a',
            'p a'
        );

        if (!empty($link_styles)) {
            echo blaze_edge_dynamic_css($link_selector, $link_styles);
        }
    }

    add_action('blaze_edge_style_dynamic', 'blaze_edge_link_styles');
}

if (!function_exists('blaze_edge_link_hover_styles')) {

    function blaze_edge_link_hover_styles() {

        $link_hover_styles = array();

        if(blaze_edge_options()->getOptionValue('link_hovercolor') !== '') {
            $link_hover_styles['color'] = blaze_edge_options()->getOptionValue('link_hovercolor');
        }
        if(blaze_edge_options()->getOptionValue('link_hover_fontdecoration') !== '') {
            $link_hover_styles['text-decoration'] = blaze_edge_options()->getOptionValue('link_hover_fontdecoration');
        }

        $link_hover_selector = array(
            'a:hover',
            'p a:hover'
        );

        if (!empty($link_hover_styles)) {
            echo blaze_edge_dynamic_css($link_hover_selector, $link_hover_styles);
        }

        $link_heading_hover_styles = array();

        if(blaze_edge_options()->getOptionValue('link_hovercolor') !== '') {
            $link_heading_hover_styles['color'] = blaze_edge_options()->getOptionValue('link_hovercolor');
        }

        $link_heading_hover_selector = array(
            'h1 a:hover',
            'h2 a:hover',
            'h3 a:hover',
            'h4 a:hover',
            'h5 a:hover',
            'h6 a:hover'
        );

        if (!empty($link_heading_hover_styles)) {
            echo blaze_edge_dynamic_css($link_heading_hover_selector, $link_heading_hover_styles);
        }
    }

    add_action('blaze_edge_style_dynamic', 'blaze_edge_link_hover_styles');
}

if (!function_exists('blaze_edge_smooth_page_transition_styles')) {

    function blaze_edge_smooth_page_transition_styles() {
        
        $loader_style = array();

        if(blaze_edge_options()->getOptionValue('smooth_pt_bgnd_color') !== '') {
            $loader_style['background-color'] = blaze_edge_options()->getOptionValue('smooth_pt_bgnd_color');
        }

        $loader_selector = array('.edgtf-loader-fade-in, .edgtf-loader-fade-out');

        if (!empty($loader_style)) {
            echo blaze_edge_dynamic_css($loader_selector, $loader_style);
        }

        $spinner_style = array();

        if(blaze_edge_options()->getOptionValue('smooth_pt_spinner_color') !== '') {
            $spinner_style['background-color'] = blaze_edge_options()->getOptionValue('smooth_pt_spinner_color');
        }

        $spinner_selectors = array(
            '.edgtf-st-loader .pulse',
            '.edgtf-st-loader .double_pulse .double-bounce1',
            '.edgtf-st-loader .double_pulse .double-bounce2',
            '.edgtf-st-loader .cube',
            '.edgtf-st-loader .rotating_cubes .cube1',
            '.edgtf-st-loader .rotating_cubes .cube2',
            '.edgtf-st-loader .stripes > div',
            '.edgtf-st-loader .wave > div',
            '.edgtf-st-loader .two_rotating_circles .dot1',
            '.edgtf-st-loader .two_rotating_circles .dot2',
            '.edgtf-st-loader .five_rotating_circles .container1 > div',
            '.edgtf-st-loader .five_rotating_circles .container2 > div',
            '.edgtf-st-loader .five_rotating_circles .container3 > div',
            '.edgtf-st-loader .atom .ball-1:before',
            '.edgtf-st-loader .atom .ball-2:before',
            '.edgtf-st-loader .atom .ball-3:before',
            '.edgtf-st-loader .atom .ball-4:before',
            '.edgtf-st-loader .clock .ball:before',
            '.edgtf-st-loader .mitosis .ball',
            '.edgtf-st-loader .lines .line1',
            '.edgtf-st-loader .lines .line2',
            '.edgtf-st-loader .lines .line3',
            '.edgtf-st-loader .lines .line4',
            '.edgtf-st-loader .fussion .ball',
            '.edgtf-st-loader .fussion .ball-1',
            '.edgtf-st-loader .fussion .ball-2',
            '.edgtf-st-loader .fussion .ball-3',
            '.edgtf-st-loader .fussion .ball-4',
            '.edgtf-st-loader .wave_circles .ball',
            '.edgtf-st-loader .pulse_circles .ball',
            '.edgtf-blaze-spinner .edgtf-blaze-spinner-inner .edgtf-blaze-spinner-dot'
        );

        if (!empty($spinner_style)) {
            echo blaze_edge_dynamic_css($spinner_selectors, $spinner_style);
        }

        if((blaze_edge_options()->getOptionValue('smooth_pt_spinner_color')) !== '' && (blaze_edge_options()->getOptionValue('smooth_pt_spinner_type') == 'blaze')) {
            $border_spinner_style['border-color'] = blaze_edge_options()->getOptionValue('smooth_pt_spinner_color');
        }

        $border_spinner_selector = array(
            '.edgtf-blaze-spinner .edgtf-blaze-spinner-outer',
        );

        if (!empty($border_spinner_style)) {
            echo blaze_edge_dynamic_css($border_spinner_selector, $border_spinner_style);
        }
    }

    add_action('blaze_edge_style_dynamic', 'blaze_edge_smooth_page_transition_styles');
}

if (!function_exists('blaze_edge_404_styles')) {

    function blaze_edge_404_styles() {

        $image404_style = array();

        if(blaze_edge_options()->getOptionValue('404_image') !== '') {
            $image404_style['background-image'] = "url(".blaze_edge_options()->getOptionValue('404_image').")";
        }

        $image404_selector = array('.error404 .edgtf-content .edgtf-container');

        if (!empty($image404_style)) {
            echo blaze_edge_dynamic_css($image404_selector, $image404_style);
        }
    }

    add_action('blaze_edge_style_dynamic', 'blaze_edge_404_styles');
}