<?php

if(!function_exists('blaze_edge_register_sidebars')) {
    /**
     * Function that registers theme's sidebars
     */
    function blaze_edge_register_sidebars() {

        register_sidebar(array(
            'name' => esc_html__('Sidebar','blaze'),
            'id' => 'sidebar',
            'description' =>  esc_html__('Default Sidebar','blaze'),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h4 class="edgtf-widget-title">',
            'after_title' => '</h4>'
        ));

    }

    add_action('widgets_init', 'blaze_edge_register_sidebars');
}

if(!function_exists('blaze_edge_add_support_custom_sidebar')) {
    /**
     * Function that adds theme support for custom sidebars. It also creates BlazeEdgeSidebar object
     */
    function blaze_edge_add_support_custom_sidebar() {
        add_theme_support('BlazeEdgeSidebar');
        if (get_theme_support('BlazeEdgeSidebar')) new BlazeEdgeSidebar();
    }

    add_action('after_setup_theme', 'blaze_edge_add_support_custom_sidebar');
}
