<?php

/**
 * Widget that adds separator boxes type
 *
 * Class Separator_Widget
 */
class BlazeEdgeSeparatorWidget extends BlazeEdgeWidget {
    /**
     * Set basic widget options and call parent class construct
     */
    public function __construct() {
        parent::__construct(
            'edgt_separator_widget', // Base ID
            esc_html__('Edge Separator Widget', 'blaze') // Name
        );

        $this->setParams();
    }

    /**
     * Sets widget options
     */
    protected function setParams() {
        $this->params = array(
            array(
                'type' => 'dropdown',
                'title' => esc_html__('Type', 'blaze'),
                'name' => 'type',
                'options' => array(
                    'normal' => esc_html__('Normal', 'blaze'),
                    'full-width' => esc_html__('Full Width', 'blaze')
                )
            ),
            array(
                'type' => 'dropdown',
                'title' => esc_html__('Separator Inline', 'blaze'),
                'name' => 'separator_inline',
                'options' => array(
                    'no' => esc_html__('No', 'blaze'),
                    'yes' => esc_html__('Yes', 'blaze')
                )
            ),
            array(
                'type' => 'dropdown',
                'title' => esc_html__('Position', 'blaze'),
                'name' => 'position',
                'options' => array(
                    'center' => esc_html__('Center', 'blaze'),
                    'left' => esc_html__('Left', 'blaze'),
                    'right' => esc_html__('Right', 'blaze')
                ),
                'description' => esc_html__('This option works on Normal - not inline types of separator','blaze')
            ),
            array(
                'type' => 'dropdown',
                'title' => esc_html__('Style', 'blaze'),
                'name' => 'border_style',
                'options' => array(
                    'solid' => esc_html__('Solid', 'blaze'),
                    'dashed' => esc_html__('Dashed', 'blaze'),
                    'dotted' => esc_html__('Dotted', 'blaze')
                )
            ),
            array(
                'type' => 'textfield',
                'title' => esc_html__('Color', 'blaze'),
                'name' => 'color'
            ),
            array(
                'type' => 'textfield',
                'title' => esc_html__('Width', 'blaze'),
                'name' => 'width',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'title' => esc_html__('Thickness (px)', 'blaze'),
                'name' => 'thickness',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'title' => esc_html__('Top Margin', 'blaze'),
                'name' => 'top_margin',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'title' => esc_html__('Bottom Margin', 'blaze'),
                'name' => 'bottom_margin',
                'description' => ''
            )
        );
    }

    /**
     * Generates widget's HTML
     *
     * @param array $args args from widget area
     * @param array $instance widget's options
     */
    public function widget($args, $instance) {

        extract($args);

        //prepare variables
        $params = '';

        //is instance empty?
        if(is_array($instance) && count($instance)) {
            //generate shortcode params
            foreach($instance as $key => $value) {
                $params .= " $key='$value' ";
            }
        }

        echo '<div class="widget edgtf-separator-widget">';

        //finally call the shortcode
        echo do_shortcode("[edgtf_separator $params]"); // XSS OK

        echo '</div>'; //close div.edgtf-separator-widget
    }
}