<?php

if ( ! function_exists('blaze_edge_portfolio_options_map') ) {

	function blaze_edge_portfolio_options_map() {

		blaze_edge_add_admin_page(array(
			'slug'  => '_portfolio',
			'title' => esc_html__('Portfolio','blaze'),
			'icon'  => 'fa fa-camera-retro'
		));

		$panel = blaze_edge_add_admin_panel(array(
			'title' => esc_html__('Portfolio Single','blaze'),
			'name'  => 'panel_portfolio_single',
			'page'  => '_portfolio'
		));

		blaze_edge_add_admin_field(array(
			'name'        => 'portfolio_single_template',
			'type'        => 'select',
			'label'       => esc_html__('Portfolio Type','blaze'),
			'default_value'	=> 'small-images',
			'description' => esc_html__('Choose a default type for Single Project pages','blaze'),
			'parent'      => $panel,
			'options'     => array(
				'small-images' => esc_html__('Portfolio small images left','blaze'),
				'small-images-right' => esc_html__('Portfolio small images right','blaze'),
				'small-slider' => esc_html__('Portfolio small slider left','blaze'),
				'small-slider-right' => esc_html__('Portfolio small slider right','blaze'),
				'big-images' => esc_html__('Portfolio big images','blaze'),
				'wide-images' => esc_html__('Portfolio wide images left','blaze'),
                'wide-images-right' => esc_html__('Portfolio wide images right','blaze'),
				'big-slider' => esc_html__('Portfolio big slider','blaze'),
                'wide-slider' => esc_html__('Portfolio wide slider','blaze'),
				'small-masonry' => esc_html__('Portfolio small masonry','blaze'),
				'big-masonry' => esc_html__('Portfolio big masonry','blaze'),
				'gallery' => esc_html__('Portfolio gallery','blaze'),
                'split-screen' => esc_html__('Portfolio split screen','blaze'),
                'full-screen-slider' => esc_html__('Portfolio full screen slider','blaze'),
				'custom' => esc_html__('Portfolio custom','blaze'),
				'full-width-custom' => esc_html__('Portfolio full width custom','blaze'),
			)
		));

		blaze_edge_add_admin_field(array(
			'name'          => 'portfolio_single_lightbox_images',
			'type'          => 'yesno',
			'label'         => esc_html__('Lightbox for Images','blaze'),
			'description'   => esc_html__('Enabling this option will turn on lightbox functionality for projects with images.','blaze'),
			'parent'        => $panel,
			'default_value' => 'yes'
		));

		blaze_edge_add_admin_field(array(
			'name'          => 'portfolio_single_lightbox_videos',
			'type'          => 'yesno',
			'label'         => esc_html__('Lightbox for Videos','blaze'),
			'description'   => esc_html__('Enabling this option will turn on lightbox functionality for YouTube/Vimeo projects.','blaze'),
			'parent'        => $panel,
			'default_value' => 'no'
		));

		blaze_edge_add_admin_field(array(
			'name'          => 'portfolio_single_hide_categories',
			'type'          => 'yesno',
			'label'         => esc_html__('Hide Categories','blaze'),
			'description'   => esc_html__('Enabling this option will disable category meta description on Single Projects.','blaze'),
			'parent'        => $panel,
			'default_value' => 'no'
		));

		blaze_edge_add_admin_field(array(
			'name'          => 'portfolio_single_hide_date',
			'type'          => 'yesno',
			'label'         => esc_html__('Hide Date','blaze'),
			'description'   => esc_html__('Enabling this option will disable date meta on Single Projects.','blaze'),
			'parent'        => $panel,
			'default_value' => 'no'
		));

		blaze_edge_add_admin_field(array(
			'name'          => 'portfolio_single_show_related',
			'type'          => 'yesno',
			'label'         => esc_html__('Show Related Projects','blaze'),
			'description'   => esc_html__('Enabling this option will show related projects on your page.','blaze'),
			'parent'        => $panel,
			'default_value' => 'yes'
		));

		blaze_edge_add_admin_field(array(
			'name'          => 'portfolio_single_sticky_sidebar',
			'type'          => 'yesno',
			'label'         => esc_html__('Sticky Side Text','blaze'),
			'description'   => esc_html__('Enabling this option will make side text sticky on Single Project pages','blaze'),
			'parent'        => $panel,
			'default_value' => 'yes'
		));
		blaze_edge_add_admin_field(array(
			'name'          => 'portfolio_single_comments',
			'type'          => 'yesno',
			'label'         => esc_html__('Show Comments','blaze'),
			'description'   => esc_html__('Enabling this option will show comments on your portfolio.','blaze'),
			'parent'        => $panel,
			'default_value' => 'no'
		));
		blaze_edge_add_admin_field(array(
			'name'          => 'portfolio_single_hide_pagination',
			'type'          => 'yesno',
			'label'         => esc_html__('Hide Pagination','blaze'),
			'description'   => esc_html__('Enabling this option will turn off portfolio pagination functionality.','blaze'),
			'parent'        => $panel,
			'default_value' => 'yes',
			'args' => array(
				'dependence' => true,
				'dependence_hide_on_yes' => '#edgtf_navigate_same_category_container'
			)
		));

		$container_navigate_category = blaze_edge_add_admin_container(array(
			'name'            => 'navigate_same_category_container',
			'parent'          => $panel,
			'hidden_property' => 'portfolio_single_hide_pagination',
			'hidden_value'    => 'yes'
		));

		blaze_edge_add_admin_field(array(
			'name'            => 'portfolio_single_nav_same_category',
			'type'            => 'yesno',
			'label'           => esc_html__('Enable Pagination Through Same Category','blaze'),
			'description'     => esc_html__('Enabling this option will make portfolio pagination sort through current category.','blaze'),
			'parent'          => $container_navigate_category,
			'default_value'   => 'no'
		));

		blaze_edge_add_admin_field(array(
			'name'        => 'portfolio_single_numb_columns',
			'type'        => 'select',
			'label'       => esc_html__('Number of Columns','blaze'),
			'default_value' => 'two-columns',
			'description' => esc_html__('Enter the number of columns for Portfolio Gallery type','blaze'),
			'parent'      => $panel,
			'options'     => array(
				'two-columns' => esc_html__('2 columns','blaze'),
				'three-columns' => esc_html__('3 columns','blaze'),
				'four-columns' => esc_html__('4 columns','blaze')
			)
		));

		blaze_edge_add_admin_field(array(
			'name'        => 'portfolio_single_slug',
			'type'        => 'text',
			'label'       => esc_html__('Portfolio Single Slug','blaze'),
			'description' => esc_html__('Enter if you wish to use a different Single Project slug (Note: After entering slug, navigate to Settings -> Permalinks and click "Save" in order for changes to take effect)','blaze'),
			'parent'      => $panel,
			'args'        => array(
				'col_width' => 3
			)
		));

	}

	add_action( 'blaze_edge_options_map', 'blaze_edge_portfolio_options_map', 13);

}