<?php

if ( ! function_exists('blaze_edge_logo_options_map') ) {

	function blaze_edge_logo_options_map() {

		blaze_edge_add_admin_page(
			array(
				'slug' => '_logo_page',
				'title' => esc_html__('Logo', 'blaze'),
				'icon' => 'fa fa-coffee'
			)
		);

		$panel_logo = blaze_edge_add_admin_panel(
			array(
				'page' => '_logo_page',
				'name' => 'panel_logo',
				'title' => esc_html__('Logo', 'blaze')
			)
		);

		blaze_edge_add_admin_field(
			array(
				'parent' => $panel_logo,
				'type' => 'yesno',
				'name' => 'hide_logo',
				'default_value' => 'no',
				'label' => esc_html__('Hide Logo', 'blaze'),
				'description' => esc_html__('Enabling this option will hide logo image', 'blaze'),
				'args' => array(
					"dependence" => true,
					"dependence_hide_on_yes" => "#edgtf_hide_logo_container",
					"dependence_show_on_yes" => ""
				)
			)
		);

		$hide_logo_container = blaze_edge_add_admin_container(
			array(
				'parent' => $panel_logo,
				'name' => 'hide_logo_container',
				'hidden_property' => 'hide_logo',
				'hidden_value' => 'yes'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'name' => 'logo_image',
				'type' => 'image',
				'default_value' => EDGE_ASSETS_ROOT."/img/logo.png",
				'label' => esc_html__('Logo Image - Default', 'blaze'),
				'description' => esc_html__('Choose a default logo image to display ', 'blaze'),
				'parent' => $hide_logo_container
			)
		);

		blaze_edge_add_admin_field(
			array(
				'name' => 'logo_image_dark',
				'type' => 'image',
				'default_value' => EDGE_ASSETS_ROOT."/img/logo_black.png",
				'label' => esc_html__('Logo Image - Dark', 'blaze'),
				'description' => esc_html__('Choose a default logo image to display ', 'blaze'),
				'parent' => $hide_logo_container
			)
		);

		blaze_edge_add_admin_field(
			array(
				'name' => 'logo_image_light',
				'type' => 'image',
				'default_value' => EDGE_ASSETS_ROOT."/img/logo_white.png",
				'label' => esc_html__('Logo Image - Light', 'blaze'),
				'description' => esc_html__('Choose a default logo image to display ', 'blaze'),
				'parent' => $hide_logo_container
			)
		);

		blaze_edge_add_admin_field(
			array(
				'name' => 'logo_image_sticky',
				'type' => 'image',
				'default_value' => EDGE_ASSETS_ROOT."/img/logo-sticky.png",
				'label' => esc_html__('Logo Image - Sticky', 'blaze'),
				'description' => esc_html__('Choose a default logo image to display ', 'blaze'),
				'parent' => $hide_logo_container
			)
		);

		blaze_edge_add_admin_field(
			array(
				'name' => 'logo_image_fullscreen_menu',
				'type' => 'image',
				'default_value' => EDGE_ASSETS_ROOT."/img/logo_white.png",
				'label' => esc_html__('Logo Image - Full Screen Menu', 'blaze'),
				'description' => esc_html__('Choose a default logo image to display when full screen menu is opened', 'blaze'),
				'parent' => $hide_logo_container
			)
		);

		blaze_edge_add_admin_field(
			array(
				'name' => 'logo_image_mobile',
				'type' => 'image',
				'default_value' => EDGE_ASSETS_ROOT."/img/logo.png",
				'label' => esc_html__('Logo Image - Mobile', 'blaze'),
				'description' => esc_html__('Choose a default logo image to display ', 'blaze'),
				'parent' => $hide_logo_container
			)
		);

	}

	add_action( 'blaze_edge_options_map', 'blaze_edge_logo_options_map', 2);

}