<?php

if ( ! function_exists('blaze_edge_sidebar_options_map') ) {

	function blaze_edge_sidebar_options_map() {

		blaze_edge_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__('Sidebar', 'blaze'),
				'icon'  => 'fa fa-indent'
			)
		);

		$panel_widgets = blaze_edge_add_admin_panel(
			array(
				'page'  => '_sidebar_page',
				'name'  => 'panel_widgets',
				'title' => esc_html__('Widgets', 'blaze')
			)
		);

		/**
		 * Navigation style
		 */
		blaze_edge_add_admin_field(array(
			'type'			=> 'color',
			'name'			=> 'sidebar_background_color',
			'default_value'	=> '',
			'label'			=> esc_html__('Sidebar Background Color', 'blaze'),
			'description'	=> esc_html__('Choose background color for sidebar', 'blaze'),
			'parent'		=> $panel_widgets
		));

		$group_sidebar_padding = blaze_edge_add_admin_group(array(
			'name'		=> 'group_sidebar_padding',
			'title'		=> esc_html__('Padding', 'blaze'),
			'parent'	=> $panel_widgets
		));

		$row_sidebar_padding = blaze_edge_add_admin_row(array(
			'name'		=> 'row_sidebar_padding',
			'parent'	=> $group_sidebar_padding
		));

		blaze_edge_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'sidebar_padding_top',
			'default_value'	=> '',
			'label'			=> esc_html__('Top Padding', 'blaze'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_sidebar_padding
		));

		blaze_edge_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'sidebar_padding_right',
			'default_value'	=> '',
			'label'			=> esc_html__('Right Padding', 'blaze'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_sidebar_padding
		));

		blaze_edge_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'sidebar_padding_bottom',
			'default_value'	=> '',
			'label'			=> esc_html__('Bottom Padding', 'blaze'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_sidebar_padding
		));

		blaze_edge_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'sidebar_padding_left',
			'default_value'	=> '',
			'label'			=> esc_html__('Left Padding', 'blaze'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_sidebar_padding
		));

		blaze_edge_add_admin_field(array(
			'type'			=> 'select',
			'name'			=> 'sidebar_alignment',
			'default_value'	=> '',
			'label'			=> esc_html__('Text Alignment', 'blaze'),
			'description'	=> esc_html__('Choose text aligment', 'blaze'),
			'options'		=> array(
				'left' 			=> esc_html__('Left', 'blaze'),
				'center' 		=> esc_html__('Center', 'blaze'),
				'right' 		=> esc_html__('Right', 'blaze')
			),
			'parent'		=> $panel_widgets
		));

	}

	add_action( 'blaze_edge_options_map', 'blaze_edge_sidebar_options_map', 9);

}