<?php

if ( ! function_exists('blaze_edge_reset_options_map') ) {
	/**
	 * Reset options panel
	 */
	function blaze_edge_reset_options_map() {

		blaze_edge_add_admin_page(
			array(
				'slug'  => '_reset_page',
				'title' => esc_html__('Reset', 'blaze'),
				'icon'  => 'fa fa-retweet'
			)
		);

		$panel_reset = blaze_edge_add_admin_panel(
			array(
				'page'  => '_reset_page',
				'name'  => 'panel_reset',
				'title' => esc_html__('Reset', 'blaze')
			)
		);

		blaze_edge_add_admin_field(array(
			'type'	=> 'yesno',
			'name'	=> 'reset_to_defaults',
			'default_value'	=> 'no',
			'label'			=> esc_html__('Reset to Defaults', 'blaze'),
			'description'	=> esc_html__('This option will reset all Edge Options values to defaults', 'blaze'),
			'parent'		=> $panel_reset
		));

	}

	add_action( 'blaze_edge_options_map', 'blaze_edge_reset_options_map', 21 );

}