<?php

if ( ! function_exists('blaze_edge_general_options_map') ) {
    /**
     * General options page
     */
    function blaze_edge_general_options_map() {

        blaze_edge_add_admin_page(
            array(
                'slug'  => '',
                'title' => esc_html__('General', 'blaze'),
                'icon'  => 'fa fa-institution'
            )
        );

        $panel_design_style = blaze_edge_add_admin_panel(
            array(
                'page'  => '',
                'name'  => 'panel_design_style',
                'title' => esc_html__('Design Style', 'blaze')
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'google_fonts',
                'type'          => 'font',
                'default_value' => '-1',
                'label'         => esc_html__('Font Family', 'blaze'),
                'description'   => esc_html__('Choose a default Google font for your site', 'blaze'),
                'parent' => $panel_design_style
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'additional_google_fonts',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__('Additional Google Fonts', 'blaze'),
                'description'   => '',
                'parent'        => $panel_design_style,
                'args'          => array(
                    "dependence" => true,
                    "dependence_hide_on_yes" => "",
                    "dependence_show_on_yes" => "#edgtf_additional_google_fonts_container"
                )
            )
        );

        $additional_google_fonts_container = blaze_edge_add_admin_container(
            array(
                'parent'            => $panel_design_style,
                'name'              => 'additional_google_fonts_container',
                'hidden_property'   => 'additional_google_fonts',
                'hidden_value'      => 'no'
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'additional_google_font1',
                'type'          => 'font',
                'default_value' => '-1',
                'label'         => esc_html__('Font Family', 'blaze'),
                'description'   => esc_html__('Choose additional Google font for your site', 'blaze'),
                'parent'        => $additional_google_fonts_container
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'additional_google_font2',
                'type'          => 'font',
                'default_value' => '-1',
                'label'         => esc_html__('Font Family', 'blaze'),
                'description'   => esc_html__('Choose additional Google font for your site', 'blaze'),
                'parent'        => $additional_google_fonts_container
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'additional_google_font3',
                'type'          => 'font',
                'default_value' => '-1',
                'label'         => esc_html__('Font Family', 'blaze'),
                'description'   => esc_html__('Choose additional Google font for your site', 'blaze'),
                'parent'        => $additional_google_fonts_container
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'additional_google_font4',
                'type'          => 'font',
                'default_value' => '-1',
                'label'         => esc_html__('Font Family', 'blaze'),
                'description'   => esc_html__('Choose additional Google font for your site', 'blaze'),
                'parent'        => $additional_google_fonts_container
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'additional_google_font5',
                'type'          => 'font',
                'default_value' => '-1',
                'label'         => esc_html__('Font Family', 'blaze'),
                'description'   => esc_html__('Choose additional Google font for your site', 'blaze'),
                'parent'        => $additional_google_fonts_container
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'first_color',
                'type'          => 'color',
                'label'         => esc_html__('First Main Color', 'blaze'),
                'description'   => esc_html__('Choose the most dominant theme color. Default color is #303030', 'blaze'),
                'parent'        => $panel_design_style
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'page_background_color',
                'type'          => 'color',
                'label'         => esc_html__('Page Background Color', 'blaze'),
                'description'   => esc_html__('Choose the background color for page content. Default color is #ffffff', 'blaze'),
                'parent'        => $panel_design_style
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'selection_color',
                'type'          => 'color',
                'label'         => esc_html__('Text Selection Color', 'blaze'),
                'description'   => esc_html__('Choose the color users see when selecting text', 'blaze'),
                'parent'        => $panel_design_style
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'boxed',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__('Boxed Layout', 'blaze'),
                'description'   => '',
                'parent'        => $panel_design_style,
                'args'          => array(
                    "dependence" => true,
                    "dependence_hide_on_yes" => "",
                    "dependence_show_on_yes" => "#edgtf_boxed_container"
                )
            )
        );

        $boxed_container = blaze_edge_add_admin_container(
            array(
                'parent'            => $panel_design_style,
                'name'              => 'boxed_container',
                'hidden_property'   => 'boxed',
                'hidden_value'      => 'no'
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'page_background_color_in_box',
                'type'          => 'color',
                'label'         => esc_html__('Page Background Color', 'blaze'),
                'description'   => esc_html__('Choose the page background color outside box.', 'blaze'),
                'parent'        => $boxed_container
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'boxed_background_image',
                'type'          => 'image',
                'label'         => esc_html__('Background Image', 'blaze'),
                'description'   => esc_html__('Choose an image to be displayed in background', 'blaze'),
                'parent'        => $boxed_container
            )
        );

		blaze_edge_add_admin_field(
			array(
				'name'          => 'boxed_background_image_repeating',
				'type'          => 'select',
				'default_value' => 'no',
				'label'         => esc_html__('Use Background Image as Pattern', 'blaze'),
				'description'   => esc_html__('Set this option to "yes" to use the background image as repeating pattern', 'blaze'),
				'parent'        => $boxed_container,
				'options'       => array(
					'no'	=>	esc_html__('No', 'blaze'),
					'yes'	=>	esc_html__('Yes', 'blaze')
				)
			)
		);

        blaze_edge_add_admin_field(
            array(
                'name'          => 'boxed_background_image_attachment',
                'type'          => 'select',
                'default_value' => 'fixed',
                'label'         => esc_html__('Background Image Behaviour', 'blaze'),
                'description'   => esc_html__('Choose background image behaviour', 'blaze'),
                'parent'        => $boxed_container,
                'options'       => array(
                    'fixed'     => esc_html__('Fixed', 'blaze'),
                    'scroll'    => esc_html__('Scroll', 'blaze')
                )
            )
        );
		blaze_edge_add_admin_field(
			array(
				'name'          => 'passepartout',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__('Passepartout', 'blaze'),
				'description'   => esc_html__('Enabling this option will display passepartout around site content', 'blaze'),
				'parent'        => $panel_design_style,
				'args'          => array(
					"dependence" => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#edgtf_passepartout_container"
				)
			)
		);

		$passepartout_container = blaze_edge_add_admin_container(
			array(
				'parent'            => $panel_design_style,
				'name'              => 'passepartout_container',
				'hidden_property'   => 'passepartout',
				'hidden_value'      => 'no'
			)
		);

		blaze_edge_add_admin_field(
			array(
				'name'          => 'passepartout_color',
				'type'          => 'color',
				'label'         => esc_html__('Passepartout Color', 'blaze'),
				'description'   => esc_html__('Choose Passepartout color.', 'blaze'),
				'parent'        => $passepartout_container
			)
		);
        blaze_edge_add_admin_field(
            array(
                'name'          => 'initial_content_width',
                'type'          => 'select',
                'default_value' => '',
                'label'         => esc_html__('Initial Width of Content', 'blaze'),
                'description'   => esc_html__('Choose the initial width of content which is in grid (Applies to pages set to "Default Template" and rows set to "In Grid")', 'blaze'),
                'parent'        => $panel_design_style,
                'options'       => array(
                    ""          => esc_html__("1300px - default", 'blaze'),
                    "grid-1300" => "1300px",
                    "grid-1200" => "1200px",
                    "grid-1000" => "1000px",
                    "grid-800"  => "800px"
                )
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'preload_pattern_image',
                'type'          => 'image',
                'label'         => esc_html__('Preload Pattern Image', 'blaze'),
                'description'   => esc_html__('Choose preload pattern image to be displayed until images are loaded ', 'blaze'),
                'parent'        => $panel_design_style
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name' => 'element_appear_amount',
                'type' => 'text',
                'label' => esc_html__('Element Appearance', 'blaze'),
                'description' => esc_html__('For animated elements, set distance (related to browser bottom) to start the animation', 'blaze'),
                'parent' => $panel_design_style,
                'args' => array(
                    'col_width' => 2,
                    'suffix' => 'px'
                )
            )
        );

        $panel_settings = blaze_edge_add_admin_panel(
            array(
                'page'  => '',
                'name'  => 'panel_settings',
                'title' => esc_html__('Settings', 'blaze')
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'smooth_scroll',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__('Smooth Scroll', 'blaze'),
                'description'   => esc_html__('Enabling this option will perform a smooth scrolling effect on every page (except on Mac and touch devices)', 'blaze'),
                'parent'        => $panel_settings
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'smooth_page_transitions',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__('Smooth Page Transitions', 'blaze'),
                'description'   => esc_html__('Enabling this option will perform a smooth transition between pages when clicking on links.', 'blaze'),
                'parent'        => $panel_settings,
                'args'          => array(
                    "dependence" => true,
                    "dependence_hide_on_yes" => "",
                    "dependence_show_on_yes" => "#edgtf_page_transitions_container, #edgtf_smooth_pt_spinner_text"
                )
            )
        );

        $page_transitions_container = blaze_edge_add_admin_container(
            array(
                'parent'            => $panel_settings,
                'name'              => 'page_transitions_container',
                'hidden_property'   => 'smooth_page_transitions',
                'hidden_value'      => 'no',
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'smooth_pt_bgnd_color',
                'type'          => 'color',
                'label'         => esc_html__('Page Loader Background Color', 'blaze'),
                'parent'        => $page_transitions_container
            )
        );

        $group_pt_spinner_animation = blaze_edge_add_admin_group(array(
            'name'          => 'group_pt_spinner_animation',
            'title'         => esc_html__('Loader Style', 'blaze'),
            'description'   => esc_html__('Choose a spinner for landing page loading animation. Define styles for loader spinner.', 'blaze'),
            'parent'        => $page_transitions_container
        ));

        $row_pt_spinner_animation = blaze_edge_add_admin_row(array(
            'name'      => 'row_pt_spinner_animation',
            'parent'    => $group_pt_spinner_animation
        ));

        blaze_edge_add_admin_field(array(
            'type'          => 'selectsimple',
            'name'          => 'smooth_pt_spinner_type',
            'default_value' => '',
            'label'         => esc_html__('Spinner Type', 'blaze'),
            'parent'        => $row_pt_spinner_animation,
            'options'       => array(
                "blaze" => esc_html__("Blaze", 'blaze'),
				"cube_text" => esc_html__("Cube Text", 'blaze'),
                "pulse" => esc_html__("Pulse", 'blaze'),
                "double_pulse" => esc_html__("Double Pulse", 'blaze'),
                "cube" => esc_html__("Cube", 'blaze'),
                "rotating_cubes" => esc_html__("Rotating Cubes", 'blaze'),
                "stripes" => esc_html__("Stripes", 'blaze'),
                "wave" => esc_html__("Wave", 'blaze'),
                "two_rotating_circles" => esc_html__("2 Rotating Circles", 'blaze'),
                "five_rotating_circles" => esc_html__("5 Rotating Circles", 'blaze'),
                "atom" => esc_html__("Atom", 'blaze'),
                "clock" => esc_html__("Clock", 'blaze'),
                "mitosis" => esc_html__("Mitosis", 'blaze'),
                "lines" => esc_html__("Lines", 'blaze'),
                "fussion" => esc_html__("Fussion", 'blaze'),
                "wave_circles" => esc_html__("Wave Circles", 'blaze'),
                "pulse_circles" => esc_html__("Pulse Circles", 'blaze')
            ),
			'args'          => array(
				"dependence"             => true,
				'show'        => array(
                    ""                       => "",
                    "blaze"                 => "",
					"cube_text"             => "#edgtf_smooth_pt_spinner_text",
                    "pulse"                 => "",
					"double_pulse"          => "",
					"cube"                  => "",
					"rotating_cubes"        => "",
					"stripes"               => "",
					"wave"                  => "",
					"two_rotating_circles"  => "",
					"five_rotating_circles" => "",
					"atom"                  => "",
					"clock"                 => "",
					"mitosis"               => "",
					"lines"                 => "",
					"fussion"               => "",
					"wave_circles"          => "",
					"pulse_circles"         => ""
				),
				'hide'        => array(
                    ""                      => "#edgtf_smooth_pt_spinner_text",
                    "blaze"                 => "#edgtf_smooth_pt_spinner_text",
					"cube_text"             => "",
					"pulse"                 => "#edgtf_smooth_pt_spinner_text",
					"double_pulse"          => "#edgtf_smooth_pt_spinner_text",
					"cube"                  => "#edgtf_smooth_pt_spinner_text",
					"rotating_cubes"        => "#edgtf_smooth_pt_spinner_text",
					"stripes"               => "#edgtf_smooth_pt_spinner_text",
					"wave"                  => "#edgtf_smooth_pt_spinner_text",
					"two_rotating_circles"  => "#edgtf_smooth_pt_spinner_text",
					"five_rotating_circles" => "#edgtf_smooth_pt_spinner_text",
					"atom"                  => "#edgtf_smooth_pt_spinner_text",
					"clock"                 => "#edgtf_smooth_pt_spinner_text",
					"mitosis"               => "#edgtf_smooth_pt_spinner_text",
					"lines"                 => "#edgtf_smooth_pt_spinner_text",
					"fussion"               => "#edgtf_smooth_pt_spinner_text",
					"wave_circles"          => "#edgtf_smooth_pt_spinner_text",
					"pulse_circles"         => "#edgtf_smooth_pt_spinner_text"
				)
			)
        ));

        blaze_edge_add_admin_field(array(
            'type'          => 'colorsimple',
            'name'          => 'smooth_pt_spinner_color',
            'default_value' => '',
            'label'         => esc_html__('Spinner Color', 'blaze'),
            'parent'        => $row_pt_spinner_animation
        ));

		blaze_edge_add_admin_field(array(
			'type'          => 'text',
			'name'          => 'smooth_pt_spinner_text',
			'default_value' => '',
			'label'         => esc_html__('Spinner Text', 'blaze'),
			'parent'        => $page_transitions_container,
			'args'			=> array(
				'col_width' => 2
			),
            'description'   => esc_html__('Enter spinner text for Cube Text spinner.', 'blaze'),
		));

        blaze_edge_add_admin_field(
            array(
                'name'          => 'show_back_button',
                'type'          => 'yesno',
                'default_value' => 'yes',
                'label'         => esc_html__('Show "Back To Top Button"', 'blaze'),
                'description'   => esc_html__('Enabling this option will display a Back to Top button on every page', 'blaze'),
                'parent'        => $panel_settings
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'responsiveness',
                'type'          => 'yesno',
                'default_value' => 'yes',
                'label'         => esc_html__('Responsiveness', 'blaze'),
                'description'   => esc_html__('Enabling this option will make all pages responsive', 'blaze'),
                'parent'        => $panel_settings
            )
        );

        $panel_custom_code = blaze_edge_add_admin_panel(
            array(
                'page'  => '',
                'name'  => 'panel_custom_code',
                'title' => esc_html__('Custom Code', 'blaze')
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'custom_css',
                'type'          => 'textarea',
                'label'         => esc_html__('Custom CSS', 'blaze'),
                'description'   => esc_html__('Enter your custom CSS here', 'blaze'),
                'parent'        => $panel_custom_code
            )
        );

        blaze_edge_add_admin_field(
            array(
                'name'          => 'custom_js',
                'type'          => 'textarea',
                'label'         => esc_html__('Custom JS', 'blaze'),
                'description'   => esc_html__('Enter your custom Javascript here', 'blaze'),
                'parent'        => $panel_custom_code
            )
        );

		$panel_google_api = blaze_edge_add_admin_panel(
			array(
				'page'  => '',
				'name'  => 'panel_google_api',
				'title' => esc_html__('Google API', 'blaze')
			)
		);

		blaze_edge_add_admin_field(
			array(
				'name'        => 'google_maps_api_key',
				'type'        => 'text',
				'label'       => esc_html__('Google Maps Api Key', 'blaze'),
				'description' => esc_html__('Insert your Google Maps API key here. For instructions on how to create a Google Maps API key, please refer to our documentation.', 'blaze'),
				'parent'      => $panel_google_api
			)
		);
    }

    add_action( 'blaze_edge_options_map', 'blaze_edge_general_options_map', 1);

}