<?php

if ( ! function_exists('blaze_edge_error_404_options_map') ) {

	function blaze_edge_error_404_options_map() {

		blaze_edge_add_admin_page(array(
			'slug' => '__404_error_page',
			'title' => esc_html__('404 Error Page', 'blaze'),
			'icon' => 'fa fa-exclamation-triangle'
		));

		$panel_404_options = blaze_edge_add_admin_panel(array(
			'page' => '__404_error_page',
			'name'	=> 'panel_404_options',
			'title'	=> esc_html__('404 Page Option', 'blaze')
		));

        blaze_edge_add_admin_field(array(
            'parent' => $panel_404_options,
            'type' => 'image',
            'name' => '404_image',
            'default_value' => '',
            'label' => esc_html__('Background Image', 'blaze'),
            'description' => esc_html__('Choose background image for 404 page', 'blaze'),
        ));

		blaze_edge_add_admin_field(array(
			'parent' => $panel_404_options,
			'type' => 'text',
			'name' => '404_title',
			'default_value' => '',
			'label' => esc_html__('Title', 'blaze'),
			'description' => esc_html__('Enter title for 404 page', 'blaze')
		));

		blaze_edge_add_admin_field(array(
			'parent' => $panel_404_options,
			'type' => 'text',
			'name' => '404_text',
			'default_value' => '',
			'label' => esc_html__('Text', 'blaze'),
			'description' => esc_html__('Enter text for 404 page', 'blaze')
		));

	}

	add_action( 'blaze_edge_options_map', 'blaze_edge_error_404_options_map', 18);

}