<?php
if(!function_exists('blaze_edge_map_title_meta_fields')) {

    function blaze_edge_map_title_meta_fields() {

        $title_meta_box = blaze_edge_create_meta_box(
            array(
                'scope' => array('page', 'portfolio-item', 'post'),
                'title' => esc_html__('Title', 'blaze'),
                'name' => 'title_meta'
            )
        );

            blaze_edge_create_meta_box_field(
                array(
                    'name' => 'edgtf_show_title_area_meta',
                    'type' => 'select',
                    'default_value' => '',
                    'label' => esc_html__('Show Title Area', 'blaze'),
                    'description' => esc_html__('Disabling this option will turn off page title area', 'blaze'),
                    'parent' => $title_meta_box,
                    'options' => array(
                        '' => '',
                        'no' => esc_html__('No', 'blaze'),
                        'yes' => esc_html__('Yes', 'blaze')
                    ),
                    'args' => array(
                        "dependence" => true,
                        "hide" => array(
                            "" => "",
                            "no" => "#edgtf_edgtf_show_title_area_meta_container",
                            "yes" => ""
                        ),
                        "show" => array(
                            "" => "#edgtf_edgtf_show_title_area_meta_container",
                            "no" => "",
                            "yes" => "#edgtf_edgtf_show_title_area_meta_container"
                        )
                    )
                )
            );

            $show_title_area_meta_container = blaze_edge_add_admin_container(
                array(
                    'parent' => $title_meta_box,
                    'name' => 'edgtf_show_title_area_meta_container',
                    'hidden_property' => 'edgtf_show_title_area_meta',
                    'hidden_value' => 'no'
                )
            );


                blaze_edge_create_meta_box_field(
                    array(
                        'name' => 'edgtf_title_in_grid_meta',
                        'type' => 'select',
                        'default_value' => '',
                        'label' => esc_html__('Title Area in Grid', 'blaze'),
                        'description' => esc_html__('Choose wheter for title content to be in grid', 'blaze'),
                        'parent' => $show_title_area_meta_container,
                        'options' => array(
                            '' => '',
                            'yes' => esc_html__('Yes', 'blaze'),
                            'no' => esc_html__('No', 'blaze')
                        )
                    )
                );

                blaze_edge_create_meta_box_field(
                    array(
                        'name' => 'edgtf_title_area_type_meta',
                        'type' => 'select',
                        'default_value' => '',
                        'label' => esc_html__('Title Area Type', 'blaze'),
                        'description' => esc_html__('Choose title type', 'blaze'),
                        'parent' => $show_title_area_meta_container,
                        'options' => array(
                            '' => '',
                            'standard' => esc_html__('Standard', 'blaze'),
                            'breadcrumb' => esc_html__('Breadcrumb', 'blaze')
                        ),
                        'args' => array(
                            "dependence" => true,
                            "hide" => array(
                                "standard" => "",
                                "standard" => "",
                                "breadcrumb" => "#edgtf_edgtf_title_area_type_meta_container"
                            ),
                            "show" => array(
                                "" => "#edgtf_edgtf_title_area_type_meta_container",
                                "standard" => "#edgtf_edgtf_title_area_type_meta_container",
                                "breadcrumb" => ""
                            )
                        )
                    )
                );

                $title_area_type_meta_container = blaze_edge_add_admin_container(
                    array(
                        'parent' => $show_title_area_meta_container,
                        'name' => 'edgtf_title_area_type_meta_container',
                        'hidden_property' => 'edgtf_title_area_type_meta',
                        'hidden_value' => '',
                        'hidden_values' => array('breadcrumb'),
                    )
                );

                    blaze_edge_create_meta_box_field(
                        array(
                            'name' => 'edgtf_title_area_enable_breadcrumbs_meta',
                            'type' => 'select',
                            'default_value' => '',
                            'label' => esc_html__('Enable Breadcrumbs', 'blaze'),
                            'description' => esc_html__('This option will display Breadcrumbs in Title Area', 'blaze'),
                            'parent' => $title_area_type_meta_container,
                            'options' => array(
                                '' => '',
                                'no' => esc_html__('No', 'blaze'),
                                'yes' => esc_html__('Yes', 'blaze')
                            ),
                        )
                    );

                blaze_edge_create_meta_box_field(
                    array(
                        'name' => 'edgtf_title_area_animation_meta',
                        'type' => 'select',
                        'default_value' => '',
                        'label' => esc_html__('Animations', 'blaze'),
                        'description' => esc_html__('Choose an animation for Title Area', 'blaze'),
                        'parent' => $show_title_area_meta_container,
                        'options' => array(
                            '' => '',
                            'no' => esc_html__('No Animation', 'blaze'),
                            'right-left' => esc_html__('Text right to left', 'blaze'),
                            'left-right' => esc_html__('Text left to right', 'blaze')
                        )
                    )
                );

                blaze_edge_create_meta_box_field(
                    array(
                        'name' => 'edgtf_title_area_vertial_alignment_meta',
                        'type' => 'select',
                        'default_value' => '',
                        'label' => esc_html__('Vertical Alignment', 'blaze'),
                        'description' => esc_html__('Specify title vertical alignment', 'blaze'),
                        'parent' => $show_title_area_meta_container,
                        'options' => array(
                            '' => '',
                            'header_bottom' => esc_html__('From Bottom of Header', 'blaze'),
							'header_middle' => esc_html__('From Middle of Header','blaze'),
                            'window_top' => esc_html__('From Window Top', 'blaze')
                        )
                    )
                );

                blaze_edge_create_meta_box_field(
                    array(
                        'name' => 'edgtf_title_area_content_alignment_meta',
                        'type' => 'select',
                        'default_value' => '',
                        'label' => esc_html__('Horizontal Alignment', 'blaze'),
                        'description' => esc_html__('Specify title horizontal alignment', 'blaze'),
                        'parent' => $show_title_area_meta_container,
                        'options' => array(
                            '' => '',
                            'left' => esc_html__('Left', 'blaze'),
                            'center' => esc_html__('Center', 'blaze'),
                            'right' => esc_html__('Right', 'blaze')
                        )
                    )
                );

        		blaze_edge_create_meta_box_field(
        			array(
        				'name'			=> 'edgtf_title_area_text_size_meta',
        				'type'			=> 'select',
        				'default_value'	=> '',
        				'label'			=> esc_html__('Text Size', 'blaze'),
        				'description'	=> esc_html__('Choose a default Title size', 'blaze'),
        				'parent'		=> $show_title_area_meta_container,
        				'options'		=> array(
        					'' => '',
        					'small'     => esc_html__('Small', 'blaze'),
        					'medium'    => esc_html__('Medium', 'blaze'),
        					'large'     => esc_html__('Large', 'blaze')


        				)
        			)
        		);

                blaze_edge_create_meta_box_field(
                    array(
                        'name' => 'edgtf_title_text_color_meta',
                        'type' => 'color',
                        'label' => esc_html__('Title Color', 'blaze'),
                        'description' => esc_html__('Choose a color for title text', 'blaze'),
                        'parent' => $show_title_area_meta_container
                    )
                );

                blaze_edge_create_meta_box_field(
                    array(
                        'name' => 'edgtf_title_breadcrumb_color_meta',
                        'type' => 'color',
                        'label' => esc_html__('Breadcrumb Color', 'blaze'),
                        'description' => esc_html__('Choose a color for breadcrumb text', 'blaze'),
                        'parent' => $show_title_area_meta_container
                    )
                );

                blaze_edge_create_meta_box_field(
                    array(
                        'name' => 'edgtf_title_area_background_color_meta',
                        'type' => 'color',
                        'label' => esc_html__('Background Color', 'blaze'),
                        'description' => esc_html__('Choose a background color for Title Area', 'blaze'),
                        'parent' => $show_title_area_meta_container
                    )
                );

                blaze_edge_create_meta_box_field(
                    array(
                        'name' => 'edgtf_hide_background_image_meta',
                        'type' => 'yesno',
                        'default_value' => 'no',
                        'label' => esc_html__('Hide Background Image', 'blaze'),
                        'description' => esc_html__('Enable this option to hide background image in Title Area', 'blaze'),
                        'parent' => $show_title_area_meta_container,
                        'args' => array(
                            "dependence" => true,
                            "dependence_hide_on_yes" => "#edgtf_edgtf_hide_background_image_meta_container",
                            "dependence_show_on_yes" => ""
                        )
                    )
                );

                $hide_background_image_meta_container = blaze_edge_add_admin_container(
                    array(
                        'parent' => $show_title_area_meta_container,
                        'name' => 'edgtf_hide_background_image_meta_container',
                        'hidden_property' => 'edgtf_hide_background_image_meta',
                        'hidden_value' => 'yes'
                    )
                );

                blaze_edge_create_meta_box_field(
                    array(
                        'name' => 'edgtf_title_area_background_image_meta',
                        'type' => 'image',
                        'label' => esc_html__('Background Image', 'blaze'),
                        'description' => esc_html__('Choose an Image for Title Area', 'blaze'),
                        'parent' => $hide_background_image_meta_container
                    )
                );

                blaze_edge_create_meta_box_field(
                    array(
                        'name' => 'edgtf_title_area_background_image_responsive_meta',
                        'type' => 'select',
                        'default_value' => '',
                        'label' => esc_html__('Background Responsive Image', 'blaze'),
                        'description' => esc_html__('Enabling this option will make Title background image responsive', 'blaze'),
                        'parent' => $hide_background_image_meta_container,
                        'options' => array(
                            '' => '',
                            'no' => esc_html__('No', 'blaze'),
                            'yes' => esc_html__('Yes', 'blaze')
                        ),
                        'args' => array(
                            "dependence" => true,
                            "hide" => array(
                                "" => "",
                                "no" => "",
                                "yes" => "#edgtf_edgtf_title_area_background_image_responsive_meta_container, #edgtf_edgtf_title_area_height_meta"
                            ),
                            "show" => array(
                                "" => "#edgtf_edgtf_title_area_background_image_responsive_meta_container, #edgtf_edgtf_title_area_height_meta",
                                "no" => "#edgtf_edgtf_title_area_background_image_responsive_meta_container, #edgtf_edgtf_title_area_height_meta",
                                "yes" => ""
                            )
                        )
                    )
                );

                $title_area_background_image_responsive_meta_container = blaze_edge_add_admin_container(
                    array(
                        'parent' => $hide_background_image_meta_container,
                        'name' => 'edgtf_title_area_background_image_responsive_meta_container',
                        'hidden_property' => 'edgtf_title_area_background_image_responsive_meta',
                        'hidden_value' => 'yes'
                    )
                );

                    blaze_edge_create_meta_box_field(
                        array(
                            'name' => 'edgtf_title_area_background_image_parallax_meta',
                            'type' => 'select',
                            'default_value' => '',
                            'label' => esc_html__('Background Image in Parallax', 'blaze'),
                            'description' => esc_html__('Enabling this option will make Title background image parallax', 'blaze'),
                            'parent' => $title_area_background_image_responsive_meta_container,
                            'options' => array(
                                '' => '',
                                'no' => esc_html__('No', 'blaze'),
                                'yes' => esc_html__('Yes', 'blaze'),
                                'yes_zoom' => esc_html__('Yes, with zoom out', 'blaze')
                            )
                        )
                    );

                blaze_edge_create_meta_box_field(array(
                    'name' => 'edgtf_title_area_height_meta',
                    'type' => 'text',
                    'label' => esc_html__('Height', 'blaze'),
                    'description' => esc_html__('Set a height for Title Area', 'blaze'),
                    'parent' => $show_title_area_meta_container,
                    'args' => array(
                        'col_width' => 2,
                        'suffix' => 'px'
                    )
                ));

                blaze_edge_create_meta_box_field(array(
                    'name' => 'edgtf_title_area_subtitle_meta',
                    'type' => 'text',
                    'default_value' => '',
                    'label' => esc_html__('Subtitle Text', 'blaze'),
                    'description' => esc_html__('Enter your subtitle text', 'blaze'),
                    'parent' => $show_title_area_meta_container,
                    'args' => array(
                        'col_width' => 6
                    )
                ));

                blaze_edge_create_meta_box_field(
                    array(
                        'name' => 'edgtf_subtitle_color_meta',
                        'type' => 'color',
                        'label' => esc_html__('Subtitle Color', 'blaze'),
                        'description' => esc_html__('Choose a color for subtitle text', 'blaze'),
                        'parent' => $show_title_area_meta_container
                    )
                );

        		blaze_edge_create_meta_box_field(
        			array(
        				'name'			=> 'edgtf_subtitle_size_meta',
        				'type'			=> 'select',
        				'default_value'	=> '',
        				'label'			=> esc_html__('Subtitle Text Size', 'blaze'),
        				'description'	=> esc_html__('Choose a default subtitle size', 'blaze'),
        				'parent'		=> $show_title_area_meta_container,
        				'options'		=> array(
        					'' => '',
        					'small'     => esc_html__('Small', 'blaze'),
        					'medium'    => esc_html__('Medium', 'blaze'),
        					'large'     => esc_html__('Large', 'blaze')
        				)
        			)
        		);
            }

    add_action('blaze_edge_meta_boxes_map', 'blaze_edge_map_title_meta_fields');
}