<?php
if(!function_exists('blaze_edge_map_testimonials_meta_fields')) {

    function blaze_edge_map_testimonials_meta_fields() {

        //Testimonials

        $testimonial_meta_box = blaze_edge_create_meta_box(
            array(
                'scope' => array('testimonials'),
                'title' => esc_html__('Testimonial', 'blaze'),
                'name' => 'testimonial_meta'
            )
        );

            blaze_edge_create_meta_box_field(
                array(
                    'name'        	=> 'edgtf_testimonial_title',
                    'type'        	=> 'text',
                    'label'       	=> esc_html__('Title', 'blaze'),
                    'description' 	=> esc_html__('Enter testimonial title', 'blaze'),
                    'parent'      	=> $testimonial_meta_box,
                )
            );


            blaze_edge_create_meta_box_field(
                array(
                    'name'        	=> 'edgtf_testimonial_author',
                    'type'        	=> 'text',
                    'label'       	=>  esc_html__('Author', 'blaze'),
                    'description' 	=>  esc_html__('Enter author name', 'blaze'),
                    'parent'      	=> $testimonial_meta_box,
                )
            );

            blaze_edge_create_meta_box_field(
                array(
                    'name'        	=> 'edgtf_testimonial_author_position',
                    'type'        	=> 'text',
                    'label'       	=>  esc_html__('Job Position', 'blaze'),
                    'description' 	=>  esc_html__('Enter job position', 'blaze'),
                    'parent'      	=> $testimonial_meta_box,
                )
            );

            blaze_edge_create_meta_box_field(
                array(
                    'name'        	=> 'edgtf_testimonial_text',
                    'type'        	=> 'text',
                    'label'       	=>  esc_html__('Text', 'blaze'),
                    'description' 	=>  esc_html__('Enter testimonial text', 'blaze'),
                    'parent'      	=> $testimonial_meta_box,
                )
            );
        }

    add_action('blaze_edge_meta_boxes_map', 'blaze_edge_map_testimonials_meta_fields');
}