<?php
if(!function_exists('blaze_edge_map_sidebar_meta_fields')) {

    function blaze_edge_map_sidebar_meta_fields() {

        $custom_sidebars = blaze_edge_get_custom_sidebars();

        $sidebar_meta_box = blaze_edge_create_meta_box(
            array(
                'scope' => array('page', 'portfolio-item', 'post'),
                'title' => esc_html__('Sidebar', 'blaze'),
                'name' => 'sidebar_meta'
            )
        );

            blaze_edge_create_meta_box_field(
                array(
                    'name'        => 'edgtf_sidebar_meta',
                    'type'        => 'select',
                    'label'       => esc_html__('Layout', 'blaze'),
                    'description' => esc_html__('Choose the sidebar layout', 'blaze'),
                    'parent'      => $sidebar_meta_box,
                    'options'     => array(
        						''			        => esc_html__('Default', 'blaze'),
        						'no-sidebar'		=> esc_html__('No Sidebar', 'blaze'),
        						'sidebar-33-right'	=> esc_html__('Sidebar 1/3 Right', 'blaze'),
        						'sidebar-25-right' 	=> esc_html__('Sidebar 1/4 Right', 'blaze'),
        						'sidebar-33-left' 	=> esc_html__('Sidebar 1/3 Left', 'blaze'),
        						'sidebar-25-left' 	=> esc_html__('Sidebar 1/4 Left', 'blaze'),
        					)
                )
            );

        if(count($custom_sidebars) > 0) {
            blaze_edge_create_meta_box_field(array(
                'name' => 'edgtf_custom_sidebar_meta',
                'type' => 'selectblank',
                'label' => esc_html__('Choose Widget Area in Sidebar', 'blaze'),
                'description' => esc_html__('Choose Custom Widget area to display in Sidebar"', 'blaze'),
                'parent' => $sidebar_meta_box,
                'options' => $custom_sidebars
            ));
        }
     }

    add_action('blaze_edge_meta_boxes_map', 'blaze_edge_map_sidebar_meta_fields');
}