<?php
if(!function_exists('blaze_edge_map_header_meta_fields')) {

    function blaze_edge_map_header_meta_fields() {

		$header_meta_box = blaze_edge_create_meta_box(
		    array(
		        'scope' => array('page', 'portfolio-item', 'post'),
		        'title' => esc_html__('Header', 'blaze'),
		        'name' => 'header_meta'
		    )
		);

		$temp_holder_show		= '';
		$temp_holder_hide		= '';
		$temp_array_standard	= array();
		$temp_array_vertical	= array();
		$temp_array_full_screen	= array();
		$temp_array_behaviour	= array();
		switch (blaze_edge_options()->getOptionValue('header_type')) {

			case 'header-standard':
				$temp_holder_show = '#edgtf_edgtf_header_standard_type_meta_container,#edgtf_edgtf_header_behaviour_meta_container';
				$temp_holder_hide = '#edgtf_edgtf_header_vertical_type_meta_container,#edgtf_edgtf_header_full_screen_type_meta_container,#edgtf_edgtf_header_expanding_type_meta_container';

				$temp_array_standard = array(
					'hidden_value' => 'default',
					'hidden_values' => array('header-vertical','header-full-screen','header-expanding')
				);
				$temp_array_vertical = array(
					'hidden_values' => array('','header-standard','header-full-screen','header-expanding')
				);
				$temp_array_full_screen = array(
					'hidden_values' => array('','header-standard', 'header-vertical','header-expanding')
				);
				$temp_array_expanding = array(
					'hidden_values' => array('','header-standard', 'header-vertical','header-full-screen')
				);
				$temp_array_behaviour = array(
					'hidden_value' => 'header-vertical'
				);
				break;

			case 'header-vertical':
				$temp_holder_show = '#edgtf_edgtf_header_vertical_type_meta_container';
				$temp_holder_hide = '#edgtf_edgtf_header_standard_type_meta_container,#edgtf_edgtf_header_full_screen_type_meta_container,#edgtf_edgtf_header_behaviour_meta_container,#edgtf_edgtf_header_expanding_type_meta_container';

				$temp_array_standard = array(
					'hidden_values' => array('', 'header-vertical', 'header-full-screen','header-expanding')
				);
				$temp_array_vertical = array(
					'hidden_value' => 'default',
					'hidden_values' => array('header-standard','header-full-screen','header-expanding')
				);
				$temp_array_full_screen = array(
					'hidden_values' => array('','header-standard', 'header-vertical','header-expanding')
				);
				$temp_array_expanding = array(
					'hidden_values' => array('','header-standard', 'header-vertical','header-full-screen')
				);
				$temp_array_behaviour = array(
					'hidden_value' => 'default',
					'hidden_values' => array('','header-vertical')
				);
				break;
			case 'header-full-screen':
				$temp_holder_show = '#edgtf_edgtf_header_full_screen_type_meta_container,#edgtf_edgtf_header_behaviour_meta_container';
				$temp_holder_hide = '#edgtf_edgtf_header_standard_type_meta_container,#edgtf_edgtf_header_vertical_type_meta_container,#edgtf_edgtf_header_expanding_type_meta_container';
				$temp_array_standard = array(
					'hidden_values' => array('', 'header-vertical', 'header-full-screen','header-expanding')
				);

				$temp_array_vertical = array(
					'hidden_values' => array('', 'header-standard','header-full-screen','header-expanding')
				);

				$temp_array_full_screen = array(
					'hidden_value' => 'default',
					'hidden_values' => array('header-vertical','header-standard','header-expanding')
				);
				$temp_array_expanding = array(
					'hidden_values' => array('','header-standard', 'header-vertical','header-full-screen')
				);
				$temp_array_behaviour = array(
					'hidden_value' => 'header-vertical'
				);
				break;
			case 'header-expanding':
				$temp_holder_show = '#edgtf_edgtf_header_expanding_type_meta_container,#edgtf_edgtf_header_behaviour_meta_container';
				$temp_holder_hide = '#edgtf_edgtf_header_standard_type_meta_container,#edgtf_edgtf_header_vertical_type_meta_container,#edgtf_edgtf_header_full_screen_type_meta_container';
				$temp_array_standard = array(
					'hidden_values' => array('', 'header-vertical', 'header-standard','header-full-screen')
				);

				$temp_array_vertical = array(
					'hidden_values' => array('', 'header-standard','header-full-screen','header-expanding')
				);

				$temp_array_full_screen = array(
					'hidden_values' => array('','header-vertical','header-full-screen','header-expanding')
				);
				$temp_array_expanding = array(
					'hidden_value' => 'default',
					'hidden_values' => array('header-standard', 'header-vertical','header-full-screen')
				);
				$temp_array_behaviour = array(
					'hidden_value' => 'header-vertical'
				);
				break;
		}

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_header_type_meta',
				'type' => 'select',
				'default_value' => '',
				'label' => esc_html__('Choose Header Type', 'blaze'),
				'description' => esc_html__('Select header type layout', 'blaze'),
				'parent' => $header_meta_box,
				'options' => array(
					'' => esc_html__('Default', 'blaze'),
					'header-standard' => esc_html__('Standard Header Layout', 'blaze'),
					'header-vertical' => esc_html__('Vertical Header Layout', 'blaze'),
					'header-full-screen' => esc_html__('Minimal Header Layout', 'blaze'),
					'header-expanding' => esc_html__('Expanding Header Layout', 'blaze')
				),
				'args' => array(
					"dependence" => true,
					"hide" => array(
						"" => $temp_holder_hide,
						'header-standard' 		=> '#edgtf_edgtf_header_vertical_type_meta_container,#edgtf_edgtf_header_full_screen_type_meta_container,#edgtf_edgtf_header_expanding_type_meta_container',
						'header-vertical' 		=> '#edgtf_edgtf_header_standard_type_meta_container,#edgtf_edgtf_header_full_screen_type_meta_container,#edgtf_edgtf_header_expanding_type_meta_container',
						'header-full-screen'	=> '#edgtf_edgtf_header_standard_type_meta_container,#edgtf_edgtf_header_vertical_type_meta_container,#edgtf_edgtf_header_expanding_type_meta_container',
						'header-expanding'	    => '#edgtf_edgtf_header_standard_type_meta_container,#edgtf_edgtf_header_vertical_type_meta_container,#edgtf_edgtf_header_full_screen_type_meta_container'
					),
					"show" => array(
						"" => $temp_holder_show,
						"header-standard" 		=> '#edgtf_edgtf_header_standard_type_meta_container',
						"header-vertical" 		=> '#edgtf_edgtf_header_vertical_type_meta_container',
						"header-full-screen" 	=> '#edgtf_edgtf_header_full_screen_type_meta_container',
						"header-expanding"	 	=> '#edgtf_edgtf_header_expanding_type_meta_container'
					)
				)
			)
		);
		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_header_style_meta',
				'type' => 'select',
				'default_value' => '',
				'label' => esc_html__('Header Skin', 'blaze'),
				'description' => esc_html__('Choose a header style to make header elements (logo, main menu, side menu button) in that predefined style', 'blaze'),
				'parent' => $header_meta_box,
				'options' => array(
					'' => '',
					'light-header' => esc_html__('Light', 'blaze'),
					'dark-header' => esc_html__('Dark', 'blaze')
				)
			)
		);

	    blaze_edge_create_meta_box_field(
		    array(
			    'name'          => 'edgtf_disable_header_widget_menu_area_meta',
			    'type'          => 'yesno',
			    'default_value' => 'no',
			    'label'         => esc_html__( 'Disable Header Menu Area Widget', 'blaze' ),
			    'description'   => esc_html__( 'Enabling this option will hide widget area from the menu area', 'blaze' ),
			    'parent'        => $header_meta_box
		    )
	    );

	    $blaze_edge_custom_sidebars = blaze_edge_get_custom_sidebars();
	    if ( count( $blaze_edge_custom_sidebars ) > 0 ) {
		    blaze_edge_create_meta_box_field(
			    array(
				    'name'        => 'edgtf_custom_menu_area_sidebar_meta',
				    'type'        => 'selectblank',
				    'label'       => esc_html__( 'Choose Custom Widget Area In Menu Area', 'blaze' ),
				    'description' => esc_html__( 'Choose custom widget area to display in header menu area"', 'blaze' ),
				    'parent'      => $header_meta_box,
				    'options'     => $blaze_edge_custom_sidebars
			    )
		    );
	    }

	    $blaze_edge_custom_sidebars = blaze_edge_get_custom_sidebars();
	    if ( count( $blaze_edge_custom_sidebars ) > 0 ) {
		    blaze_edge_create_meta_box_field(
			    array(
				    'name'        => 'edgtf_custom_sticky_area_sidebar_meta',
				    'type'        => 'selectblank',
				    'label'       => esc_html__( 'Choose Custom Widget Area In Sticky Menu Widget Area', 'blaze' ),
				    'description' => esc_html__( 'Choose custom widget area to display in sticky header widget area"', 'blaze' ),
				    'parent'      => $header_meta_box,
				    'options'     => $blaze_edge_custom_sidebars
			    )
		    );
	    }

		blaze_edge_create_meta_box_field(
			array(
				'parent' => $header_meta_box,
				'type' => 'select',
				'name' => 'edgtf_enable_header_style_on_scroll_meta',
				'default_value' => '',
				'label' => esc_html__('Enable Header Style on Scroll', 'blaze'),
				'description' => esc_html__('Enabling this option, header will change style depending on row settings for dark/light style', 'blaze'),
				'options' => array(
					'' => '',
					'no' 	=> esc_html__('No', 'blaze'),
					'yes' 	=> esc_html__('Yes', 'blaze')
				)
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'parent' => $header_meta_box,
				'type' => 'text',
				'name' => 'edgtf_menu_area_padding_header_full_width_meta',
				'default_value' => '',
				'label' => esc_html__('Full Width Header Left/Right Padding', 'blaze'),
				'description' => esc_html__('Set left/right padding for header full width with px or %', 'blaze'),
				'args' => array(
					'col_width' => 3
				)
			)
		);

		$header_standard_type_meta_container = blaze_edge_add_admin_container(
			array_merge(
				array(
					'parent' => $header_meta_box,
					'name' => 'edgtf_header_standard_type_meta_container',
					'hidden_property' => 'edgtf_header_type_meta',

				),
				$temp_array_standard
			)
		);

        blaze_edge_create_meta_box_field(
            array(
                'parent' => $header_standard_type_meta_container,
                'type' => 'select',
                'name' => 'edgtf_menu_position_header_strandard_meta',
                'default_value' => '',
                'label' => esc_html__('Menu Position', 'blaze'),
                'description' => esc_html__('Choose menu position for Standard Header type', 'blaze'),
                'options' => array(
                    '' => '',
                    'left' => esc_html__('Left', 'blaze'),
                    'center' => esc_html__('Center', 'blaze'),
                    'right' => esc_html__('Right', 'blaze'),
                )
            )
        );

        blaze_edge_create_meta_box_field(
            array(
                'parent' => $header_standard_type_meta_container,
                'type' => 'select',
                'name' => 'edgtf_menu_area_in_grid_header_standard_meta',
                'default_value' => '',
                'label' => esc_html__('Header in grid', 'blaze'),
                'description' => esc_html__('Set header content to be in grid', 'blaze'),
                'options' => array(
                    '' => '',
                    'yes' => esc_html__('Yes', 'blaze'),
                    'no' => esc_html__('No', 'blaze'),
                )
            )
        );

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_menu_area_background_color_header_standard_meta',
				'type' => 'color',
				'label' => esc_html__('Background Color', 'blaze'),
				'description' => esc_html__('Choose a background color for header area', 'blaze'),
				'parent' => $header_standard_type_meta_container
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_menu_area_background_transparency_header_standard_meta',
				'type' => 'text',
				'label' => esc_html__('Background Transparency', 'blaze'),
				'description' => esc_html__('Choose a transparency for the header background color (0 = fully transparent, 1 = opaque)', 'blaze'),
				'parent' => $header_standard_type_meta_container,
				'args' => array(
					'col_width' => 2
				)
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_menu_area_height_header_standard_meta',
				'type' => 'text',
				'label' => esc_html__('Height', 'blaze'),
				'description' => esc_html__('Enter header height', 'blaze'),
				'parent' => $header_standard_type_meta_container,
				'args' => array(
					'col_width' => 2,
					'suffix' => 'px'
				)
			)
		);

		$header_vertical_type_meta_container = blaze_edge_add_admin_container(
			array_merge(
				array(
					'parent' => $header_meta_box,
					'name' => 'edgtf_header_vertical_type_meta_container',
					'hidden_property' => 'edgtf_header_type_meta',
					'hidden_values' => array('header-standard')
				),
				$temp_array_vertical
			)
		);

		blaze_edge_create_meta_box_field(array(
			'name'        => 'edgtf_vertical_header_background_color_meta',
			'type'        => 'color',
			'label'       => esc_html__('Background Color', 'blaze'),
			'description' => esc_html__('Set background color for vertical menu', 'blaze'),
			'parent'      => $header_vertical_type_meta_container
		));

		blaze_edge_create_meta_box_field(array(
			'name'        => 'edgtf_vertical_header_transparency_meta',
			'type'        => 'text',
			'label'       => esc_html__('Background Transparency', 'blaze'),
			'description' => esc_html__('Enter transparency for vertical menu (value from 0 to 1)', 'blaze'),
			'parent'      => $header_vertical_type_meta_container,
			'args'        => array(
				'col_width' => 1
			)
		));

		blaze_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_vertical_header_background_image_meta',
				'type'          => 'image',
				'default_value' => '',
				'label'         => esc_html__('Background Image', 'blaze'),
				'description'   => esc_html__('Set background image for vertical menu', 'blaze'),
				'parent'        => $header_vertical_type_meta_container
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_disable_vertical_header_background_image_meta',
				'type' => 'yesno',
				'default_value' => 'no',
				'label' => esc_html__('Disable Background Image', 'blaze'),
				'description' => esc_html__('Enabling this option will hide background image in Vertical Menu', 'blaze'),
				'parent' => $header_vertical_type_meta_container
			)
		);

		$header_full_screen_type_meta_container = blaze_edge_add_admin_container(
			array_merge(
				array(
					'parent' => $header_meta_box,
					'name' => 'edgtf_header_full_screen_type_meta_container',
					'hidden_property' => 'edgtf_header_type_meta',

				),
				$temp_array_full_screen
			)
		);

        blaze_edge_create_meta_box_field(
            array(
                'parent' => $header_full_screen_type_meta_container,
                'type' => 'select',
                'name' => 'edgtf_logo_position_header_full_screen_meta',
                'default_value' => '',
                'label' => esc_html__('Logo Position', 'blaze'),
                'description' => esc_html__('Choose logo position for Minimal Header type', 'blaze'),
                'options' => array(
                    '' => '',
                    'left' => esc_html__('Left', 'blaze'),
                    'center' => esc_html__('Center', 'blaze'),
                )
            )
        );

        blaze_edge_create_meta_box_field(
            array(
                'parent' => $header_full_screen_type_meta_container,
                'type' => 'select',
                'name' => 'edgtf_enable_full_screen_menu_header_full_screen_meta',
                'default_value' => '',
				'label' => esc_html__('Enable Full Screen Menu','blaze'),
				'description' => esc_html__('Set header menu to open in fullscreen','blaze'),
                'options' => array(
                    '' => '',
                    'yes' => esc_html__('Yes', 'blaze'),
                    'no' => esc_html__('No', 'blaze'),
                )
            )
        );

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_menu_area_background_color_header_full_screen_meta',
				'type' => 'color',
				'label' => esc_html__('Background Color', 'blaze'),
				'description' => esc_html__('Choose a background color for Minimal header area', 'blaze'),
				'parent' => $header_full_screen_type_meta_container
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_menu_area_background_transparency_header_full_screen_meta',
				'type' => 'text',
				'label' => esc_html__('Background Transparency', 'blaze'),
				'description' => esc_html__('Choose a transparency for the Minimal header background color (0 = fully transparent, 1 = opaque)', 'blaze'),
				'parent' => $header_full_screen_type_meta_container,
				'args' => array(
					'col_width' => 2
				)
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_menu_area_height_header_full_screen_meta',
				'type' => 'text',
				'label' => esc_html__('Height', 'blaze'),
				'description' => esc_html__('Enter header height', 'blaze'),
				'parent' => $header_full_screen_type_meta_container,
				'args' => array(
					'col_width' => 2,
					'suffix' => 'px'
				)
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_fullscreen_menu_icon_background_color_meta',
				'type' => 'color',
				'label' => esc_html__('Icon Background Color', 'blaze'),
				'description' => esc_html__('Choose a background color for Minimal Icon', 'blaze'),
				'parent' => $header_full_screen_type_meta_container
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_fullscreen_menu_icon_background_hover_color_meta',
				'type' => 'color',
				'label' => esc_html__('Icon Background Hover Color', 'blaze'),
				'description' => esc_html__('Choose a background hover color for Minimal Icon', 'blaze'),
				'parent' => $header_full_screen_type_meta_container
			)
		);

		$header_expanding_type_meta_container = blaze_edge_add_admin_container(
			array_merge(
				array(
					'parent' => $header_meta_box,
					'name' => 'edgtf_header_expanding_type_meta_container',
					'hidden_property' => 'edgtf_header_type_meta',

				),
				$temp_array_expanding
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_menu_area_background_color_header_expanding_meta',
				'type' => 'color',
				'label' => esc_html__('Background Color', 'blaze'),
				'description' => esc_html__('Choose a background color for Expanding header area', 'blaze'),
				'parent' => $header_expanding_type_meta_container
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_menu_area_background_transparency_header_expanding_meta',
				'type' => 'text',
				'label' => esc_html__('Background Transparency', 'blaze'),
				'description' => esc_html__('Choose a transparency for the Expanding header background color (0 = fully transparent, 1 = opaque)', 'blaze'),
				'parent' => $header_expanding_type_meta_container,
				'args' => array(
					'col_width' => 2
				)
			)
		);
		
		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_menu_area_height_header_expanding_meta',
				'type' => 'text',
				'label' => esc_html__('Height', 'blaze'),
				'description' => esc_html__('Enter header height', 'blaze'),
				'parent' => $header_expanding_type_meta_container,
				'args' => array(
					'col_width' => 2,
					'suffix' => 'px'
				)
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_menu_icon_background_color_header_expanding_meta',
				'type' => 'color',
				'label' => esc_html__('Menu Icon Background Color', 'blaze'),
				'description' => esc_html__('Choose a background color for Expanding header menu icon', 'blaze'),
				'parent' => $header_expanding_type_meta_container
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_menu_icon_background_transparency_header_expanding_meta',
				'type' => 'text',
				'label' => esc_html__('Menu Icon Background Transparency', 'blaze'),
				'description' => esc_html__('Choose a transparency for the Expanding header menu icon background color (0 = fully transparent, 1 = opaque)', 'blaze'),
				'parent' => $header_expanding_type_meta_container,
				'args' => array(
					'col_width' => 2
				)
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name' => 'edgtf_menu_icon_background_spread_header_expanding_meta',
				'type' => 'select',
				'default_value' => '',
				'parent' => $header_expanding_type_meta_container,
				'label' => esc_html__('Spread Icon Background', 'blaze'),
				'description' => esc_html__('Enable this option to enable spreading of Icon background over header', 'blaze'),
				'options' => array(
					'' => '',
					'no' 	=> esc_html__('No', 'blaze'),
					'yes'	=> esc_html__('Yes', 'blaze')
				)
			)
		);

		$header_behaviour_meta_container = blaze_edge_add_admin_container(
			array_merge(
				array(
					'parent' => $header_meta_box,
					'name' => 'edgtf_header_behaviour_meta_container',
					'hidden_property' => 'edgtf_header_type_meta',

				),
				$temp_array_behaviour
			)
		);

		blaze_edge_create_meta_box_field(
			array(
				'name'            => 'edgtf_scroll_amount_for_sticky_meta',
				'type'            => 'text',
				'label'           => esc_html__('Scroll amount for sticky header appearance', 'blaze'),
				'description'     => esc_html__('Define scroll amount for sticky header appearance', 'blaze'),
				'parent'          => $header_behaviour_meta_container,
				'args'            => array(
					'col_width' => 2,
					'suffix'    => 'px'
				),
				'hidden_property' => 'edgtf_header_behaviour',
				'hidden_values'   => array("sticky-header-on-scroll-up", "fixed-on-scroll")
			)
		);


		blaze_edge_add_admin_section_title(array(
			'name'   => 'top_bar_section_title',
			'parent' => $header_meta_box,
			'title'  => esc_html__('Top Bar', 'blaze')
		));

		$top_bar_global_option      = blaze_edge_options()->getOptionValue('top_bar');
		$top_bar_default_dependency = array(
			'' => '#edgtf_top_bar_container_no_style'
		);

		$top_bar_show_array = array(
			'yes' => '#edgtf_top_bar_container_no_style'
		);

		$top_bar_hide_array = array(
			'no' => '#edgtf_top_bar_container_no_style'
		);

		if($top_bar_global_option === 'yes') {
			$top_bar_show_array = array_merge($top_bar_show_array, $top_bar_default_dependency);
			$temp_top_no = array(
				'hidden_value' => 'no'
			);
		} else {
			$top_bar_hide_array = array_merge($top_bar_hide_array, $top_bar_default_dependency);
			$temp_top_no = array(
				'hidden_values'   => array('','no')
			);
		}


		blaze_edge_create_meta_box_field(array(
			'name'          => 'edgtf_top_bar_meta',
			'type'          => 'select',
			'label'         => esc_html__('Enable Top Bar on This Page', 'blaze'),
			'description'   => esc_html__('Enabling this option will enable top bar on this page', 'blaze'),
			'parent'        => $header_meta_box,
			'default_value' => '',
			'options'       => array(
				''    => esc_html__('Default', 'blaze'),
				'yes' => esc_html__('Yes', 'blaze'),
				'no'  => esc_html__('No', 'blaze')
			),
			'args' => array(
				"dependence" => true,
				'show'       => $top_bar_show_array,
				'hide'       => $top_bar_hide_array
			)
		));

		$top_bar_container = blaze_edge_add_admin_container_no_style(array_merge(array(
			'name'            => 'top_bar_container_no_style',
			'parent'          => $header_meta_box,
			'hidden_property' => 'edgtf_top_bar_meta'
		),
			$temp_top_no));

		blaze_edge_create_meta_box_field(array(
			'name'    => 'edgtf_top_bar_skin_meta',
			'type'    => 'select',
			'label'   => esc_html__('Top Bar Skin', 'blaze'),
			'options' => array(
				''      => esc_html__('Default', 'blaze'),
				'light' => esc_html__('Light', 'blaze'),
				'dark'  => esc_html__('Dark', 'blaze')
			),
			'parent'  => $top_bar_container
		));

		blaze_edge_create_meta_box_field(array(
			'name'   => 'edgtf_top_bar_background_color_meta',
			'type'   => 'color',
			'label'  => esc_html__('Top Bar Background Color', 'blaze'),
			'parent' => $top_bar_container
		));

		blaze_edge_create_meta_box_field(array(
			'name'        => 'edgtf_top_bar_background_transparency_meta',
			'type'        => 'text',
			'label'       => esc_html__('Top Bar Background Color Transparency', 'blaze'),
			'description' => esc_html__('Set top bar background color transparenct. Value should be between 0 and 1', 'blaze'),
			'parent'      => $top_bar_container,
			'args'        => array(
				'col_width' => 3
			)
		));
	}

    add_action('blaze_edge_meta_boxes_map', 'blaze_edge_map_header_meta_fields');
}