<?php
if(!function_exists('blaze_edge_map_footer_meta_fields')) {

    function blaze_edge_map_footer_meta_fields() {

        $footer_meta_box = blaze_edge_create_meta_box(
            array(
                'scope' => array('page', 'portfolio-item', 'post'),
                'title' => esc_html__('Footer', 'blaze'),
                'name' => 'footer_meta'
            )
        );

        blaze_edge_create_meta_box_field(
            array(
                'name' => 'edgtf_disable_footer_meta',
                'type' => 'yesno',
                'default_value' => 'no',
                'label' => esc_html__('Disable Footer for this Page', 'blaze'),
                'description' => esc_html__('Enabling this option will hide footer on this page', 'blaze'),
                'parent' => $footer_meta_box,
            )
        );

        blaze_edge_create_meta_box_field(
            array(
                'type' => 'select',
                'name' => 'edgtf_uncovering_footer_meta',
                'default_value' => '',
                'label' => esc_html__('Uncovering Footer','blaze'),
                'description' => esc_html__('Enabling this option will make Footer gradually appear on scroll','blaze'),
                'options' => array(
                    '' => '',
                    'no'    => esc_html__('No', 'blaze'),
                    'yes'   => esc_html__('Yes', 'blaze')
                ),
                'parent' => $footer_meta_box,
            )
        );
    }

    add_action('blaze_edge_meta_boxes_map', 'blaze_edge_map_footer_meta_fields');
}