<?php
if(!function_exists('blaze_edge_map_carousel_meta_fields')) {

    function blaze_edge_map_carousel_meta_fields() {

        //Carousels

        $carousel_meta_box = blaze_edge_create_meta_box(
            array(
                'scope' => array('carousels'),
                'title' => esc_html__('Carousel', 'blaze'),
                'name' => 'carousel_meta'
            )
        );

            blaze_edge_create_meta_box_field(
                array(
                    'name'        => 'edgtf_carousel_image',
                    'type'        => 'image',
                    'label'       => esc_html__('Carousel Image', 'blaze'),
                    'description' => esc_html__('Choose carousel image (min width needs to be 215px)', 'blaze'),
                    'parent'      => $carousel_meta_box
                )
            );

            blaze_edge_create_meta_box_field(
                array(
                    'name'        => 'edgtf_carousel_hover_image',
                    'type'        => 'image',
                    'label'       => esc_html__('Carousel Hover Image', 'blaze'),
                    'description' => esc_html__('Choose carousel hover image (min width needs to be 215px)', 'blaze'),
                    'parent'      => $carousel_meta_box
                )
            );

            blaze_edge_create_meta_box_field(
                array(
                    'name'        => 'edgtf_carousel_item_link',
                    'type'        => 'text',
                    'label'       => esc_html__('Link', 'blaze'),
                    'description' => esc_html__('Enter the URL to which you want the image to link to (e.g. http://www.example.com)', 'blaze'),
                    'parent'      => $carousel_meta_box
                )
            );

            blaze_edge_create_meta_box_field(
                array(
                    'name'        => 'edgtf_carousel_item_target',
                    'type'        => 'selectblank',
                    'label'       => esc_html__('Target', 'blaze'),
                    'description' => esc_html__('Specify where to open the linked document', 'blaze'),
                    'parent'      => $carousel_meta_box,
                    'options' => array(
                    	'_self'    => esc_html__('Self', 'blaze'),
                    	'_blank'   => esc_html__('Blank', 'blaze')
                	)
                )
            );
        }

    add_action('blaze_edge_meta_boxes_map', 'blaze_edge_map_carousel_meta_fields');
}