<?php
if(!function_exists('blaze_edge_map_blog_meta_fields')) {

    function blaze_edge_map_blog_meta_fields() {

        $edgt_blog_categories = array();
        $categories = get_categories();
        foreach($categories as $category) {
            $edgt_blog_categories[$category->term_id] = $category->name;
        }

        $blog_meta_box = blaze_edge_create_meta_box(
            array(
                'scope' => array('page'),
                'title' => esc_html__('Blog', 'blaze'),
                'name' => 'blog_meta'
            )
        );

            blaze_edge_create_meta_box_field(
                array(
                    'name'        => 'edgtf_blog_category_meta',
                    'type'        => 'selectblank',
                    'label'       => esc_html__('Blog Category', 'blaze'),
                    'description' => esc_html__('Choose category of posts to display (leave empty to display all categories)', 'blaze'),
                    'parent'      => $blog_meta_box,
                    'options'     => $edgt_blog_categories
                )
            );

            blaze_edge_create_meta_box_field(
                array(
                    'name'        => 'edgtf_show_posts_per_page_meta',
                    'type'        => 'text',
                    'label'       => esc_html__('Number of Posts', 'blaze'),
                    'description' => esc_html__('Enter the number of posts to display', 'blaze'),
                    'parent'      => $blog_meta_box,
                    'options'     => $edgt_blog_categories,
                    'args'        => array("col_width" => 3)
                )
            );
        }

    add_action('blaze_edge_meta_boxes_map', 'blaze_edge_map_blog_meta_fields');
}