<?php
namespace BlazeEdge\Modules\Shortcodes\ProgressBar;

use BlazeEdge\Modules\Shortcodes\Lib\ShortcodeInterface;

class ProgressBar implements ShortcodeInterface{
	private $base;
	
	function __construct() {
		$this->base = 'edgtf_progress_bar';
		add_action('vc_before_init', array($this, 'vcMap'));
	}
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {

		vc_map( array(
			'name' => esc_html__('Progress Bar', 'edge-cpt'),
			'base' => $this->base,
			'icon' => 'icon-wpb-progress-bar extended-custom-icon',
			'category' => esc_html__( 'by EDGE', 'edge-cpt' ),
			'allowed_container_element' => 'vc_row',
			'params' => array(
				array(
					'type' => 'textfield',
					'admin_label' => true,
					'heading' => esc_html__('Title', 'edge-cpt'),
					'param_name' => 'title',
					'description' => ''
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__('Skin', 'edge-cpt'),
					'param_name' => 'skin',
					'value' => array(
						esc_html__('Dark', 'edge-cpt') => 'dark',
						esc_html__('Light', 'edge-cpt') => 'light',
						esc_html__('Grey', 'edge-cpt') => 'grey'
					)
				),
				array(
					'type' => 'dropdown',
					'admin_label' => true,
					'heading' => esc_html__('Title Tag', 'edge-cpt'),
					'param_name' => 'title_tag',
					'value' => array(
						''   => '',
						'h2' => 'h2',
						'h3' => 'h3',
						'h4' => 'h4',	
						'h5' => 'h5',	
						'h6' => 'h6',	
					),
					'description' => ''
				),
				array(
					'type' => 'textfield',
					'admin_label' => true,
					'heading' => esc_html__('Percentage', 'edge-cpt'),
					'param_name' => 'percent',
					'description' => ''
				),	
				array(
					'type' => 'dropdown',
					'admin_label' => true,
					'heading' => esc_html__('Percentage Type', 'edge-cpt'),
					'param_name' => 'percentage_type',
					'value' => array(
						esc_html__('Floating', 'edge-cpt')  => 'floating',
						esc_html__('Static', 'edge-cpt') => 'static'
					),
					'dependency' => Array('element' => 'percent', 'not_empty' => true)
				)
			)
		) );

	}

	public function render($atts, $content = null) {
		$args = array(
            'title' => '',
            'title_tag' => 'h6',
            'percent' => '100',
            'percentage_type' => 'floating',
			'skin' => 'dark'
        );
		$params = shortcode_atts($args, $atts);

		//Extract params for use in method
		extract($params);
		$headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');

        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];
		
		$params['percentage_classes'] = $this->getPercentageClasses($params);
		$params['progress_bar_classes'] = $this->getProgressBarClasses($params);

        //init variables
		$html = edge_cpt_get_cpt_shortcode_template_part('templates/progress-bar-template', 'progress-bar', '', $params);
		
        return $html;
		
	}
	/**
    * Generates css classes for progress bar
    *
    * @param $params
    *
    * @return array
    */
	private function getPercentageClasses($params){
		
		$percentClassesArray = array();
		
		if(!empty($params['percentage_type']) !=''){
			
			if($params['percentage_type'] == 'floating'){
				
				$percentClassesArray[]= 'edgtf-floating';


			}
			elseif($params['percentage_type'] == 'static'){
				
				$percentClassesArray[] = 'edgtf-static';
				
			}
		}
		return implode(' ', $percentClassesArray);
	}

	/**
	 * Generates css classes for Progress Bar
	 *
	 * @param $params
	 *
	 * @return array
	 */
	private function getProgressBarClasses($params){

		$progress_bar_classes = array();
		$progress_bar_classes[] = 'edgtf-progress-bar';


		if($params['skin'] !== ''){
			$progress_bar_classes[] = 'edgtf-progress-bar-'.$params['skin'];
		}

		return implode(' ', $progress_bar_classes);
	}
}