<?php
namespace BlazeEdge\Modules\Shortcodes\InteractiveLinkShowcase;

use BlazeEdge\Modules\Shortcodes\Lib\ShortcodeInterface;

class InteractiveLinkShowcase implements ShortcodeInterface{
	private $base;
	
	public function __construct() {
		$this->base = 'edgtf_interactive_text';

		add_action('vc_before_init', array($this, 'vcMap'));
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer. Hooked on vc_before_init
	 */
	public function vcMap() {
		if(function_exists('vc_map')) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Interactive Text', 'edge-cpt' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by EDGE', 'edge-cpt' ),
					'icon'                      => 'icon-wpb-interactive-text extended-custom-icon',
                    'allowed_container_element' => 'vc_row',
					'params'                    => array(
						array(
							'type' => 'dropdown',
							'heading' => esc_html__('Direction', 'edge-cpt'),
							'param_name' => 'slider_direction',
							'value' => array(
								esc_html__('Horizontal', 'edge-cpt') => 'horizontal',
								esc_html__('Vertical', 'edge-cpt') => 'vertical',
							)
						),
						array(
							'type' => 'dropdown',
							'heading' => esc_html__('Alignment', 'edge-cpt'),
							'param_name' => 'alignment',
							'value' => array(
								esc_html__('Default', 'edge-cpt') => '',
								esc_html__('Left', 'edge-cpt') => 'left',
								esc_html__('Center', 'edge-cpt') => 'center',
								esc_html__('Right', 'edge-cpt') => 'right',
							),
							'dependency' => array('element' => 'slider_direction', 'value' => array('vertical'))
						),
						array(
							'type' => 'textfield',
							'heading' => esc_html__('Holder Padding', 'edge-cpt'),
							'param_name' => 'padding',
							'description' => esc_html__('Insert padding in form (2% 0 2% 5%)', 'edge-cpt'),
							'dependency' => array('element' => 'slider_direction', 'value' => array('vertical'))
						),
                        array(
                        	'type' => 'param_group',
                            'heading' => esc_html__( 'Interactive Text Items', 'edge-cpt' ),
                            'param_name' => 'interactive_text_items',
                            'value' => '',
                            'params' => array(
                                array(
                                    'type'        => 'textfield',
                                    'param_name'  => 'title',
                                    'heading'     => esc_html__( 'Title', 'edge-cpt' ),
                                    'admin_label' => true
                                ),
                                array(
                                    'type'        => 'textfield',
                                    'param_name'  => 'sup_text',
                                    'heading'     => esc_html__( 'Superscript Text', 'edge-cpt' ),
                                    'admin_label' => true
                                ),
                                array(
                                    'type'       => 'colorpicker',
                                    'param_name' => 'text_color',
                                    'heading'    => esc_html__( 'Title Color', 'edge-cpt' )
                                ),
                                array(
                                    'type'        => 'textfield',
                                    'param_name'  => 'subtitle',
                                    'heading'     => esc_html__( 'Subtitle', 'edge-cpt' ),
                                    'admin_label' => true
                                ),
                                array(
                                    'type'       => 'colorpicker',
                                    'param_name' => 'subtitle_color',
                                    'heading'    => esc_html__( 'Subtitle Color', 'edge-cpt' )
                                ),
                                array(
                                    'type'       => 'textfield',
                                    'param_name' => 'link',
                                    'heading'    => esc_html__( 'Link', 'edge-cpt' )
                                ),
                                array(
                                    'type'        => 'attach_image',
                                    'param_name'  => 'image',
                                    'heading'     => esc_html__( 'Background Image', 'edge-cpt' ),
                                    'description' => esc_html__( 'Select image from media library', 'edge-cpt' )
                                ),
                            )
                        ),
                    )
				)
			);
		}
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $atts array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render($atts, $content = null) {
		$args = array(
			'slider_direction' => 'horizontal',
			'alignment' => 'center',
			'padding' => '',
         	'interactive_text_items' => ''
		);
		
		$params = shortcode_atts($args, $atts);
        $params['content'] = $content;
        $params['interactive_text_items'] = json_decode(urldecode($params['interactive_text_items']), true);
        $params['classes'] = $this->getSliderClasses($params);
        $params['holder_style'] = $this->getHolderStyle($params);

		$html = edge_cpt_get_cpt_shortcode_template_part('templates/interactive-text-template', 'interactive-text', '', $params);
		
		return $html;
	}

	private function getSliderClasses($params){
		$classes = array();

		if ($params['slider_direction'] !== ''){
			$classes[] = 'edgtf-it-direction-'.$params['slider_direction'];
		} else {
			$classes[] = 'edgtf-it-direction-horizontal';
		}

		if ($params['alignment'] !== ''){
			$classes[] = 'edgtf-it-alignment-'.$params['alignment'];
		} else {
			$classes[] = 'edgtf-it-alignment-center';
		}

		return implode(' ', $classes);
	}

	private function getHolderStyle($params){
		$style = array();

		if ($params['padding'] !== ''){
			$style[] = 'padding: '.$params['padding'];
		}

		return implode(' ', $style);
	}
}