<?php
namespace BlazeEdge\Modules\Shortcodes\Clients;

use BlazeEdge\Modules\Shortcodes\Lib\ShortcodeInterface;
/**
 * Class Clients
 */

class Clients implements ShortcodeInterface{
	private $base;
	function __construct() {
		$this->base = 'edgtf_clients';
		add_action('vc_before_init', array($this, 'vcMap'));
	}
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		vc_map( array(
			'name' => esc_html__('Clients', 'edge-cpt'),
			'base' => $this->base,
			'as_parent' => array('only' => 'edgtf_client'),
			'content_element' => true,
			'category' => esc_html__( 'by EDGE', 'edge-cpt' ),
			'icon' => 'icon-wpb-clients extended-custom-icon',
			'show_settings_on_create' => true,
			'params' => array(
				array(
					'type' => 'dropdown',
					'admin_label' => true,
					'heading' => esc_html__('Columns', 'edge-cpt'),
					'param_name' => 'columns',
					'value' => array(
						esc_html__('Two', 'edge-cpt')   => 'two-columns',
						esc_html__('Three', 'edge-cpt') => 'three-columns',
						esc_html__('Four', 'edge-cpt')  => 'four-columns',
						esc_html__('Five', 'edge-cpt')  => 'five-columns',
						esc_html__('Six', 'edge-cpt')   => 'six-columns'
					),
					'save_always' => true,
					'description' => ''
				)
			),
			'js_view' => 'VcColumnView'

		));
	}

	public function render($atts, $content = null) {
	
		$args = array(
			'columns' 			=> ''
		);
		$params = shortcode_atts($args, $atts);
		extract($params);
		$params['content']= $content;
		$html	= '';

		$html = edge_cpt_get_cpt_shortcode_template_part('templates/clients-template', 'clients', '', $params);

		return $html;

	}

}
